/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.panels;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.CommonUtils;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.api.ProgressDisplayer;
import org.netbeans.modules.profiler.api.java.ExternalPackages;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourcePackageInfo;
import org.netbeans.modules.profiler.selector.api.SelectionTreeBuilderFactory;
import org.netbeans.modules.profiler.selector.api.SelectionTreeBuilderType;
import org.netbeans.modules.profiler.selector.spi.SelectionTreeBuilder;
import org.netbeans.modules.profiler.selector.ui.RootSelectorTree;
import org.netbeans.modules.profiler.selector.ui.TreePathSearch;
import org.netbeans.modules.profiler.ui.ProfilerProgressDisplayer;
import org.netbeans.modules.profiler.ui.panels.Bundle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public final class FileSelectRootMethodsPanel
extends JPanel {
    private static final String HELP_CTX_KEY = "ClassSelectRootMethodsPanel.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ClassSelectRootMethodsPanel.HelpCtx");
    private static final Dimension PREFERRED_TOPTREE_DIMENSION = new Dimension(500, 250);
    private JButton okButton;
    private RootSelectorTree fileTreeView;

    public static final FileSelectRootMethodsPanel getDefault() {
        return Singleton.INSTANCE;
    }

    private FileSelectRootMethodsPanel() {
        this.init(this);
    }

    private void init(Container container) {
        this.okButton = new JButton(Bundle.SelectRootMethodsPanel_OkButtonText());
        ProfilerProgressDisplayer profilerProgressDisplayer = ProfilerProgressDisplayer.getDefault();
        this.fileTreeView = new RootSelectorTree((ProgressDisplayer)profilerProgressDisplayer, new TreePathSearch.ClassIndex(){

            public List<SourceClassInfo> getClasses(String string, Lookup lookup) {
                Object object;
                Pattern pattern = Pattern.compile(string, 2);
                ArrayList<SourceClassInfo> arrayList = new ArrayList<SourceClassInfo>();
                SourceClassInfo sourceClassInfo = (SourceClassInfo)lookup.lookup(SourceClassInfo.class);
                if (sourceClassInfo != null) {
                    this.addClassRecursively(sourceClassInfo, arrayList);
                } else {
                    object = (FileObject)lookup.lookup(FileObject.class);
                    if (FileUtil.isArchiveFile((FileObject)object) || object.isFolder()) {
                        for (SourcePackageInfo sourcePackageInfo : ExternalPackages.forPath((FileObject)object)) {
                            this.addPackageRecursively(sourcePackageInfo, arrayList);
                        }
                    }
                }
                object = arrayList.iterator();
                while (object.hasNext()) {
                    sourceClassInfo = (SourceClassInfo)object.next();
                    if (pattern.matcher(sourceClassInfo.getSimpleName()).matches()) continue;
                    object.remove();
                }
                Collections.sort(arrayList, SourceClassInfo.COMPARATOR);
                return arrayList;
            }

            private void addPackageRecursively(SourcePackageInfo sourcePackageInfo, List<SourceClassInfo> list) {
                for (SourcePackageInfo sourcePackageInfo2 : sourcePackageInfo.getSubpackages()) {
                    this.addPackageRecursively(sourcePackageInfo2, list);
                }
                for (SourcePackageInfo sourcePackageInfo2 : sourcePackageInfo.getClasses()) {
                    this.addClassRecursively((SourceClassInfo)sourcePackageInfo2, list);
                }
            }

            private void addClassRecursively(SourceClassInfo sourceClassInfo, List<SourceClassInfo> list) {
                list.add(sourceClassInfo);
                for (SourceClassInfo sourceClassInfo2 : sourceClassInfo.getInnerClases()) {
                    this.addClassRecursively(sourceClassInfo2, list);
                }
            }
        });
        container.setLayout(new GridBagLayout());
        this.fileTreeView.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        JScrollPane jScrollPane = new JScrollPane((Component)this.fileTreeView);
        jScrollPane.setPreferredSize(PREFERRED_TOPTREE_DIMENSION);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        container.add((Component)jScrollPane, gridBagConstraints);
    }

    public ClientUtils.SourceCodeSelection[] getRootMethods(final FileObject fileObject, final ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        this.fileTreeView.reset();
        this.updateSelector(new Runnable(){

            @Override
            public void run() {
                List list = SelectionTreeBuilderFactory.buildersFor((FileObject)fileObject);
                FileSelectRootMethodsPanel.this.fileTreeView.setSelection(sourceCodeSelectionArray, Lookups.fixed((Object[])list.toArray(new SelectionTreeBuilder[list.size()])));
                List list2 = FileSelectRootMethodsPanel.this.fileTreeView.getBuilderTypes();
                if (list2.size() > 0) {
                    FileSelectRootMethodsPanel.this.fileTreeView.setBuilderType((SelectionTreeBuilderType)list2.get(0));
                }
            }
        });
        final DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, Bundle.SelectRootMethodsPanel_Title(), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, null, null);
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        Cancellable cancellable = new Cancellable(){

            public boolean cancel() {
                dialogDescriptor.setValue(DialogDescriptor.CANCEL_OPTION);
                dialog.setVisible(false);
                FileSelectRootMethodsPanel.this.fileTreeView.setCancelHandler(null);
                return true;
            }
        };
        this.fileTreeView.setCancelHandler(cancellable);
        dialog.pack();
        dialog.setVisible(true);
        if (dialogDescriptor.getValue().equals(this.okButton)) {
            ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray2 = this.fileTreeView.getSelection();
            return sourceCodeSelectionArray2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSelector(Runnable runnable) {
        final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)Bundle.SelectRootMethodsPanel_ParsingProjectStructureMessage());
        CommonUtils.runInEventDispatchThreadAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                progressHandle.setInitialDelay(500);
                progressHandle.start();
            }
        });
        try {
            this.fileTreeView.setEnabled(false);
            this.okButton.setEnabled(false);
            runnable.run();
        }
        finally {
            progressHandle.finish();
            this.okButton.setEnabled(true);
            this.fileTreeView.setEnabled(true);
        }
    }

    private static final class Singleton {
        private static final FileSelectRootMethodsPanel INSTANCE = new FileSelectRootMethodsPanel();

        private Singleton() {
        }
    }
}

