/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.jdp.client;

import com.jrockit.mc.jdp.client.Discoverable;
import com.jrockit.mc.jdp.client.DiscoveryEvent;
import com.jrockit.mc.jdp.client.DiscoveryListener;
import com.jrockit.mc.jdp.client.JDPClient;
import com.jrockit.mc.jdp.common.JDPPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class PacketProcessor {
    private static final String KEY_BROADCAST_PERIOD = "com.oracle.jdp.period";
    private final List<DiscoveryListener> listeners = new ArrayList<DiscoveryListener>();
    final Map<String, DiscoverableInfo> infoMap = new HashMap<String, DiscoverableInfo>();

    PacketProcessor() {
    }

    public synchronized void process(JDPPacket packet) {
        DiscoverableInfo info = this.infoMap.get(packet.getSessionId());
        long now = System.currentTimeMillis();
        if (info == null) {
            info = new DiscoverableInfo();
            info.timestamp = now;
            info.packet = packet;
            this.infoMap.put(packet.getSessionId(), info);
            long broadcastPeriod = this.getBroadcastPeriodFromPayload(packet.getPayload());
            if (broadcastPeriod > 0L) {
                info.heartBeat = broadcastPeriod;
                info.needToCalculateHeartBeat = false;
            }
            JDPClient.LOGGER.fine("Found " + packet);
            this.fireEvent(new DiscoveryEvent(DiscoveryEvent.Kind.FOUND, packet));
        } else if (!info.packet.equals(packet)) {
            JDPClient.LOGGER.fine("Changed " + packet);
            this.fireEvent(new DiscoveryEvent(DiscoveryEvent.Kind.CHANGED, packet));
        }
        if (info.needToCalculateHeartBeat) {
            long newHB = now - info.timestamp;
            info.heartBeat = info.heartBeat == 0L ? newHB : (info.heartBeat + newHB) / 2L;
        }
        info.timestamp = now;
    }

    private long getBroadcastPeriodFromPayload(Map<String, String> payload) {
        if (!payload.containsKey(KEY_BROADCAST_PERIOD)) {
            return -1L;
        }
        return Long.parseLong(payload.get(KEY_BROADCAST_PERIOD));
    }

    synchronized void fireEvent(DiscoveryEvent event) {
        for (DiscoveryListener listener : this.listeners) {
            listener.onDiscovery(event);
        }
    }

    public synchronized Set<Discoverable> getDiscoverables() {
        HashSet<Discoverable> discoverables = new HashSet<Discoverable>();
        for (DiscoverableInfo info : this.infoMap.values()) {
            discoverables.add(info.packet);
        }
        return discoverables;
    }

    public synchronized void addDiscoveryListener(DiscoveryListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeDiscoveryListener(DiscoveryListener listener) {
        this.listeners.remove(listener);
    }

    static class DiscoverableInfo {
        long timestamp;
        long heartBeat;
        boolean needToCalculateHeartBeat = true;
        JDPPacket packet;

        DiscoverableInfo() {
        }
    }
}

