/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.ProfilingEventListener;
import org.netbeans.lib.profiler.client.AppStatusHandler;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.client.ProfilingPointsProcessor;
import org.netbeans.lib.profiler.global.CalibrationDataFileIO;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.EventBufferProcessor;
import org.netbeans.lib.profiler.results.cpu.CPUCCTContainer;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.lib.profiler.wireprotocol.AsyncMessageCommand;
import org.netbeans.lib.profiler.wireprotocol.Command;
import org.netbeans.lib.profiler.wireprotocol.InternalStatsResponse;

public class TargetAppRunner
implements CommonConstants {
    private static final String CLASSPATH_SETTINGS_IGNORED_MSG;
    private static final String ERROR_STARTING_JVM_MSG;
    private static final String CALIBRATION_SUMMARY_SHORT_MSG;
    private static final String CALIBRATION_SUMMARY_DETAILS_MSG;
    private static final String FAILED_ESTABLISH_CONN_MSG;
    private static final String UNEXPECTED_PROBLEM_STARTING_APP_MSG;
    private static final String JVM_TERMINATED_NOTRESPOND_STRING;
    private static final String INTERNAL_PROBLEM_STRING;
    private static final String FAILED_START_APP_CAUSE_MSG;
    private static final String CALIBRATION_RESULTS_MSG;
    private static final String CALIBRATION_ERROR_MSG;
    private static final String INTERNAL_STATISTICS_ONLY_MSG;
    private static final String INSTR_METHODS_COUNT_MSG;
    private static final String CLASSLOAD_FIRSTINV_COUNT_MSG;
    private static final String NON_EMPTY_IMG_COUNT_MSG;
    private static final String EMPTY_IMG_COUNT_MSG;
    private static final String SINGLE_IMG_COUNT_MSG;
    private static final String AVG_METHOD_TIME_MSG;
    private static final String MIN_METHOD_TIME_MSG;
    private static final String MAX_METHOD_TIME_MSG;
    private static final String TOTAL_RUN_TIME_MSG;
    private static final String INJ_INSTR_TIME_MSG;
    private static final String TOTAL_INSTR_HOTSWAP_TIME_MSG;
    private static final String BYTECODE_COMM_TIME_MSG;
    private static final String CLIENT_BYTECODE_TIME_MSG;
    private static final String CLIENT_DISK_PROCESS_MSG;
    private static final String CLIENT_RESULTS_PROCESS_MSG;
    private static final String PERFORMING_CALIBRATION_MSG;
    private static final boolean DEBUG;
    private static TargetAppRunner defaultTAR;
    private static final int EVENT_STARTED = 0;
    private static final int EVENT_STOPPED = 1;
    private static final int EVENT_SUSPENDED = 2;
    private static final int EVENT_RESUMED = 3;
    private static final int EVENT_ATTACHED = 4;
    private static final int EVENT_TERMINATED = 5;
    private static final int EVENT_DETACHED = 6;
    private AppStatusHandler appStatusHandler;
    private Process runningAppProcess;
    private ProfilerClient profilerClient;
    private ProfilerEngineSettings settings;
    private ProfilingPointsProcessor profilingPointProcessor;
    private ProfilingSessionStatus status;
    private Collection<ProfilingEventListener> listeners = new CopyOnWriteArraySet<ProfilingEventListener>();
    private boolean targetAppIsSuspended;

    public TargetAppRunner(ProfilerEngineSettings profilerEngineSettings, AppStatusHandler appStatusHandler, ProfilingPointsProcessor profilingPointsProcessor) {
        this.settings = profilerEngineSettings;
        this.status = new ProfilingSessionStatus();
        this.appStatusHandler = appStatusHandler;
        this.profilingPointProcessor = profilingPointsProcessor;
        this.profilerClient = new ProfilerClient(profilerEngineSettings, this.status, this.appStatusHandler, new AppStatusHandler.ServerCommandHandler(){

            @Override
            public void handleServerCommand(Command command) {
                if (command != null) {
                    if (command.getType() == 14) {
                        AsyncMessageCommand asyncMessageCommand = (AsyncMessageCommand)command;
                        if (asyncMessageCommand.isPositive()) {
                            TargetAppRunner.this.appStatusHandler.displayNotification(asyncMessageCommand.getMessage());
                        } else {
                            TargetAppRunner.this.appStatusHandler.displayError(asyncMessageCommand.getMessage());
                        }
                    } else if (command.getType() == 38) {
                        TargetAppRunner.this.appStatusHandler.resultsAvailable();
                    } else if (command.getType() == 39) {
                        TargetAppRunner.this.appStatusHandler.takeSnapshot();
                    }
                }
            }
        });
        defaultTAR = this;
    }

    public static TargetAppRunner getDefault() {
        return defaultTAR;
    }

    public AppStatusHandler getAppStatusHandler() {
        return this.appStatusHandler;
    }

    public String getInternalStats() throws ClientUtils.TargetAppOrVMTerminated {
        InternalStatsResponse internalStatsResponse = this.status.savedInternalStats != null ? this.status.savedInternalStats : this.profilerClient.getInternalStats();
        return this.getInternalStatsText(internalStatsResponse);
    }

    public ProfilerClient getProfilerClient() {
        return this.profilerClient;
    }

    public ProfilerEngineSettings getProfilerEngineSettings() {
        return this.settings;
    }

    public ProfilingPointsProcessor getProfilingPointsProcessor() {
        return this.profilingPointProcessor;
    }

    public ProfilingSessionStatus getProfilingSessionStatus() {
        return this.status;
    }

    public Process getRunningAppProcess() {
        return this.runningAppProcess;
    }

    public void addProfilingEventListener(ProfilingEventListener profilingEventListener) {
        this.listeners.add(profilingEventListener);
    }

    public boolean attachToTargetVM() {
        if (this.connectToStartedVMAndStartTA(1, false)) {
            this.status.runningInAttachedMode = true;
            this.notifyListeners(4);
            return true;
        }
        return false;
    }

    public boolean attachToTargetVMOnStartup() {
        if (this.connectToStartedVMAndStartTA(2, false)) {
            this.status.runningInAttachedMode = true;
            this.notifyListeners(4);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean calibrateInstrumentationCode() {
        this.status.targetJDKVersionString = this.settings.getTargetJDKVersionString();
        AppStatusHandler.AsyncDialog asyncDialog = this.appStatusHandler.getAsyncDialogInstance(PERFORMING_CALIBRATION_MSG, false, null);
        asyncDialog.display();
        boolean bl = false;
        try {
            if (!this.runJVMToCalibrateInstrumentation()) {
                boolean bl2 = false;
                return bl2;
            }
            bl = CalibrationDataFileIO.saveCalibrationData(this.status);
            boolean bl3 = true;
            return bl3;
        }
        finally {
            asyncDialog.close();
            if (bl) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(CALIBRATION_SUMMARY_DETAILS_MSG);
                this.appendCalibrationData(stringBuffer);
                this.appStatusHandler.displayNotificationWithDetailsAndWaitForConfirm(CALIBRATION_SUMMARY_SHORT_MSG, stringBuffer.toString());
            } else {
                this.appStatusHandler.displayErrorAndWaitForConfirm(CalibrationDataFileIO.getErrorMessage());
            }
        }
    }

    public boolean connectToStartedVMAndStartTA() {
        return this.connectToStartedVMAndStartTA(false);
    }

    public void detachFromTargetJVM() {
        if (this.targetAppIsSuspended) {
            try {
                this.profilerClient.resumeTargetAppThreads();
            }
            catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                // empty catch block
            }
            this.targetAppIsSuspended = false;
        }
        try {
            this.profilerClient.detachFromTargetJVM();
            this.notifyListeners(6);
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            // empty catch block
        }
        this.targetAppIsSuspended = false;
    }

    public boolean hasSupportedJDKForHeapDump() {
        String string;
        int n;
        String string2 = this.getProfilerEngineSettings().getTargetJDKVersionString();
        if ("jdk16".equals(string2) || "jdk17".equals(string2) || "jdk18".equals(string2)) {
            return true;
        }
        return "jdk15".equals(string2) && (n = Platform.getJDKMinorNumber(string = this.getProfilingSessionStatus().fullTargetJDKVersionString)) >= 12;
    }

    public boolean initiateSession(int n, boolean bl, AtomicBoolean atomicBoolean) {
        if (this.targetJVMIsAlive()) {
            return true;
        }
        return this.profilerClient.establishConnectionWithServer(n, bl, atomicBoolean);
    }

    public boolean initiateSession(int n, boolean bl) {
        return this.initiateSession(n, bl, new AtomicBoolean(false));
    }

    public boolean readSavedCalibrationData() {
        this.status.targetJDKVersionString = this.settings.getTargetJDKVersionString();
        int n = CalibrationDataFileIO.readSavedCalibrationData(this.status);
        if (n < 0) {
            this.appStatusHandler.displayErrorAndWaitForConfirm(CalibrationDataFileIO.getErrorMessage());
        }
        return n == 0;
    }

    public void removeProfilingEventListener(ProfilingEventListener profilingEventListener) {
        this.listeners.remove(profilingEventListener);
    }

    public void resetTimers() throws ClientUtils.TargetAppOrVMTerminated {
        this.profilerClient.resetProfilerCollectors();
    }

    public void resumeTargetAppIfSuspended() throws ClientUtils.TargetAppOrVMTerminated {
        if (this.targetAppIsSuspended) {
            this.profilerClient.resumeTargetAppThreads();
            this.targetAppIsSuspended = false;
            this.notifyListeners(3);
        }
    }

    public void runGC() throws ClientUtils.TargetAppOrVMTerminated {
        this.profilerClient.runGC();
    }

    public boolean startTargetVM() {
        return this.startTargetVM(this.settings.getJVMArgs(), this.settings.getMainClassName(), this.settings.getMainArgs(), this.settings.getWorkingDir(), this.settings.getSeparateConsole());
    }

    public void suspendTargetAppIfRunning() throws ClientUtils.TargetAppOrVMTerminated {
        if (!this.targetAppIsSuspended) {
            this.profilerClient.suspendTargetAppThreads();
            this.targetAppIsSuspended = true;
            this.notifyListeners(2);
        }
    }

    public boolean targetAppIsRunning() {
        return this.status.targetAppRunning;
    }

    public boolean targetAppSuspended() {
        return this.targetAppIsSuspended;
    }

    public boolean targetJVMIsAlive() {
        return this.profilerClient.targetJVMIsAlive();
    }

    public void terminateTargetJVM() {
        if (this.targetAppIsSuspended) {
            try {
                this.profilerClient.resumeTargetAppThreads();
            }
            catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                // empty catch block
            }
            this.targetAppIsSuspended = false;
        }
        try {
            this.profilerClient.terminateTargetJVM();
            this.notifyListeners(5);
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            // empty catch block
        }
        this.targetAppIsSuspended = false;
    }

    private String getInternalStatsText(InternalStatsResponse internalStatsResponse) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(2);
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append(INTERNAL_STATISTICS_ONLY_MSG);
        double d = CPUCCTContainer.getWholeGraphGrossTimeAbsForDisplayedThread();
        double d2 = CPUCCTContainer.getTimeInInjectedCodeForDisplayedThread();
        double d3 = d + internalStatsResponse.totalHotswappingTime + internalStatsResponse.clientInstrTime + internalStatsResponse.clientDataProcTime;
        stringBuffer.append(MessageFormat.format(INSTR_METHODS_COUNT_MSG, "" + internalStatsResponse.nTotalInstrMethods));
        stringBuffer.append("\n");
        stringBuffer.append(MessageFormat.format(CLASSLOAD_FIRSTINV_COUNT_MSG, "" + internalStatsResponse.nClassLoads, "" + internalStatsResponse.nFirstMethodInvocations));
        stringBuffer.append("\n");
        stringBuffer.append(MessageFormat.format(NON_EMPTY_IMG_COUNT_MSG, "" + internalStatsResponse.nNonEmptyInstrMethodGroupResponses));
        stringBuffer.append("\n");
        stringBuffer.append(MessageFormat.format(EMPTY_IMG_COUNT_MSG, "" + internalStatsResponse.nEmptyInstrMethodGroupResponses));
        stringBuffer.append("\n");
        stringBuffer.append(MessageFormat.format(SINGLE_IMG_COUNT_MSG, "" + internalStatsResponse.nSingleMethodInstrMethodGroupResponses));
        stringBuffer.append("\n");
        if (internalStatsResponse.nNonEmptyInstrMethodGroupResponses > 0) {
            stringBuffer.append(MessageFormat.format(AVG_METHOD_TIME_MSG, numberFormat.format(internalStatsResponse.averageHotswappingTime)));
            stringBuffer.append("\n");
            stringBuffer.append(MessageFormat.format(MIN_METHOD_TIME_MSG, numberFormat.format(internalStatsResponse.minHotswappingTime)));
            stringBuffer.append("\n");
            stringBuffer.append(MessageFormat.format(MAX_METHOD_TIME_MSG, numberFormat.format(internalStatsResponse.maxHotswappingTime)));
            stringBuffer.append("\n");
        }
        stringBuffer.append("\n");
        stringBuffer.append(MessageFormat.format(TOTAL_RUN_TIME_MSG, numberFormat.format(d3)));
        stringBuffer.append("\n");
        if (d3 == 0.0) {
            d3 = 1.0;
        }
        stringBuffer.append(MessageFormat.format(INJ_INSTR_TIME_MSG, numberFormat.format(d2), numberFormat.format(d2 / d3 * 100.0)));
        stringBuffer.append("\n");
        stringBuffer.append(MessageFormat.format(TOTAL_INSTR_HOTSWAP_TIME_MSG, numberFormat.format(internalStatsResponse.totalHotswappingTime), numberFormat.format(internalStatsResponse.totalHotswappingTime / d3 * 100.0)));
        stringBuffer.append("\n");
        stringBuffer.append(MessageFormat.format(BYTECODE_COMM_TIME_MSG, numberFormat.format(internalStatsResponse.clientInstrTime), numberFormat.format(internalStatsResponse.clientInstrTime / d3 * 100.0)));
        stringBuffer.append("\n");
        stringBuffer.append(MessageFormat.format(CLIENT_BYTECODE_TIME_MSG, "" + this.profilerClient.getInstrProcessingTime()));
        stringBuffer.append("\n");
        stringBuffer.append(MessageFormat.format(CLIENT_DISK_PROCESS_MSG, numberFormat.format(internalStatsResponse.clientDataProcTime), numberFormat.format(internalStatsResponse.clientDataProcTime / d3 * 100.0)));
        stringBuffer.append("\n");
        long l = EventBufferProcessor.getDataProcessingTime();
        stringBuffer.append(MessageFormat.format(CLIENT_RESULTS_PROCESS_MSG, "" + l));
        stringBuffer.append("\n");
        stringBuffer.append("\n");
        this.appendCalibrationData(stringBuffer);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private void appendCalibrationData(StringBuffer stringBuffer) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(4);
        long l = this.status.timerCountsInSecond[0];
        double d = this.status.methodEntryExitCallTime[0] * 1000000.0 / (double)l;
        double d2 = this.status.methodEntryExitCallTime[1] * 1000000.0 / (double)l;
        double d3 = this.status.methodEntryExitCallTime[2] * 1000000.0 / (double)l;
        double d4 = this.status.methodEntryExitCallTime[4] * 1000000.0 / (double)l;
        stringBuffer.append(MessageFormat.format(CALIBRATION_RESULTS_MSG, numberFormat.format(d), numberFormat.format(d2), numberFormat.format(d3), numberFormat.format(d4)));
    }

    private boolean connectToStartedVMAndStartTA(boolean bl) {
        if (!this.connectToStartedVMAndStartTA(0, bl)) {
            return false;
        }
        this.status.runningInAttachedMode = false;
        this.notifyListeners(0);
        return true;
    }

    private boolean connectToStartedVMAndStartTA(int n, boolean bl) {
        if (bl) {
            return true;
        }
        boolean bl2 = n != 1;
        try {
            return this.profilerClient.startTargetApp(bl2);
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            String string = UNEXPECTED_PROBLEM_STARTING_APP_MSG;
            string = targetAppOrVMTerminated.isVMTerminated() ? string + JVM_TERMINATED_NOTRESPOND_STRING : string + INTERNAL_PROBLEM_STRING;
            this.appStatusHandler.displayError(string);
            return false;
        }
        catch (ClientUtils.TargetAppFailedToStart targetAppFailedToStart) {
            this.appStatusHandler.displayError(MessageFormat.format(FAILED_START_APP_CAUSE_MSG, targetAppFailedToStart.getOrigCause()));
            return false;
        }
    }

    private void notifyListeners(int n) {
        for (ProfilingEventListener profilingEventListener : this.listeners) {
            switch (n) {
                case 0: {
                    profilingEventListener.targetAppStarted();
                    break;
                }
                case 1: {
                    profilingEventListener.targetAppStopped();
                    break;
                }
                case 2: {
                    profilingEventListener.targetAppSuspended();
                    break;
                }
                case 3: {
                    profilingEventListener.targetAppResumed();
                    break;
                }
                case 5: {
                    profilingEventListener.targetVMTerminated();
                    break;
                }
                case 4: {
                    profilingEventListener.attachedToTarget();
                    break;
                }
                case 6: {
                    profilingEventListener.detachedFromTarget();
                }
            }
        }
    }

    private boolean runJVMToCalibrateInstrumentation() {
        boolean bl = this.startTargetVM(new String[0], "____Profiler+Calibration+Run____", new String[0], ".", this.settings.getSeparateConsole());
        if (!bl) {
            return false;
        }
        bl = this.initiateSession(0, true);
        while (this.targetJVMIsAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        if (this.status.timerCountsInSecond[0] == 0L) {
            this.appStatusHandler.displayErrorAndWaitForConfirm(CALIBRATION_ERROR_MSG);
            return false;
        }
        return true;
    }

    private boolean startTargetVM(String[] stringArray, String string, String[] stringArray2, String string2, boolean bl) {
        boolean bl2 = Platform.isWindows();
        this.status.savedInternalStats = null;
        File file = new File(string2);
        String string3 = this.settings.getMainClassPath();
        String string4 = this.settings.getJFluidRootDirName();
        String string5 = this.settings.getTargetJDKVersionString();
        if (string5.equals("jdk16") || string5.equals("jdk17") || string5.equals("jdk18")) {
            string5 = "jdk15";
        }
        string5 = string5.substring(3);
        String string6 = string4 + File.separator + "jfluid-server.jar" + File.pathSeparator + string4 + File.separator + "jfluid-server-" + string5 + ".jar";
        String[] stringArray3 = new String[stringArray.length];
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if ((stringArray[i].equals("-classpath") || stringArray[i].equals("-cp")) && i + 1 < stringArray.length) {
                this.appStatusHandler.displayWarning(CLASSPATH_SETTINGS_IGNORED_MSG);
                ++i;
                continue;
            }
            stringArray3[n++] = stringArray[i];
        }
        ArrayList<String> arrayList = new ArrayList<String>(10);
        if (bl) {
            if (bl2) {
                arrayList.add("cmd.exe");
                arrayList.add("/K");
                arrayList.add("start");
                arrayList.add("\"Profiled Application Console\"");
                if (this.settings.getTargetWindowRemains()) {
                    arrayList.add("cmd");
                    arrayList.add("/K");
                }
            } else {
                arrayList.add("xterm");
                arrayList.add("-sb");
                arrayList.add("-sl");
                arrayList.add("1000");
                arrayList.add("-e");
            }
        }
        arrayList.add(this.settings.getTargetJVMExeFile());
        if (this.settings.getTargetJDKVersionString().equals("jdk15") || this.settings.getTargetJDKVersionString().equals("jdk16") || this.settings.getTargetJDKVersionString().equals("jdk17") || this.settings.getTargetJDKVersionString().equals("jdk18")) {
            String string7 = Platform.getAgentNativeLibFullName(this.settings.getJFluidRootDirName(), false, this.settings.getTargetJDKVersionString(), this.settings.getSystemArchitecture());
            arrayList.add("-agentpath:" + string7);
        }
        arrayList.add("-Xbootclasspath/a:" + string6);
        if (string3 != null && !string3.isEmpty()) {
            arrayList.add("-classpath");
            arrayList.add(string3);
        }
        if (!bl2 && this.settings.getTargetWindowRemains()) {
            arrayList.add("-XX:+ShowMessageBoxOnError");
        }
        if (Platform.isLinux() && this.settings.getTargetJDKVersionString().equals("jdk16")) {
            arrayList.add("-XX:+UseLinuxPosixThreadCPUClocks");
        }
        for (int i = 0; i < stringArray3.length; ++i) {
            arrayList.add(stringArray3[i]);
        }
        if (System.getProperty("org.netbeans.lib.profiler.wireprotocol.WireIO.agent") != null) {
            arrayList.add("-Dorg.netbeans.lib.profiler.wireprotocol.WireIO=true");
        }
        if (System.getProperty("org.netbeans.lib.profiler.server.ProfilerInterface.classLoadHook") != null) {
            arrayList.add("-Dorg.netbeans.lib.profiler.server.ProfilerInterface.classLoadHook=true");
        }
        arrayList.add("org.netbeans.lib.profiler.server.ProfilerServer");
        arrayList.add(Platform.getJFluidNativeLibDirName(this.settings.getJFluidRootDirName(), this.settings.getTargetJDKVersionString(), this.settings.getSystemArchitecture()));
        arrayList.add(Integer.toString(this.settings.getPortNo()));
        String string8 = System.getProperty("profiler.agent.connect.timeout", "10");
        arrayList.add(string8);
        if (string != null) {
            arrayList.add(string);
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            arrayList.add(stringArray2[i]);
        }
        String[] stringArray4 = new String[arrayList.size()];
        arrayList.toArray(stringArray4);
        MiscUtils.printInfoMessage("Starting target application...");
        MiscUtils.printVerboseInfoMessage(stringArray4);
        if (DEBUG) {
            System.err.println("TargetAppRunner.DEBUG: Starting VM with " + stringArray4.length + " commands.");
            for (int i = 0; i < stringArray4.length; ++i) {
                System.err.println("TargetAppRunner.DEBUG: cmd[" + i + "] = >" + stringArray4[i] + "<");
            }
        }
        try {
            this.runningAppProcess = Runtime.getRuntime().exec(stringArray4, null, file);
        }
        catch (IOException iOException) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray4.length; ++i) {
                stringBuilder.append(stringArray4[i]).append('\n');
            }
            this.appStatusHandler.displayError(MessageFormat.format(ERROR_STARTING_JVM_MSG, stringBuilder, iOException));
            return false;
        }
        return true;
    }

    static {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.netbeans.lib.profiler.Bundle");
        CLASSPATH_SETTINGS_IGNORED_MSG = resourceBundle.getString("TargetAppRunner_ClasspathSettingsIgnoredMsg");
        ERROR_STARTING_JVM_MSG = resourceBundle.getString("TargetAppRunner_ErrorStartingJvmMsg");
        CALIBRATION_SUMMARY_SHORT_MSG = resourceBundle.getString("TargetAppRunner_CalibrationSummaryShortMsg");
        CALIBRATION_SUMMARY_DETAILS_MSG = resourceBundle.getString("TargetAppRunner_CalibrationSummaryDetailsMsg");
        FAILED_ESTABLISH_CONN_MSG = resourceBundle.getString("TargetAppRunner_FailedEstablishConnMsg");
        UNEXPECTED_PROBLEM_STARTING_APP_MSG = resourceBundle.getString("TargetAppRunner_UnexpectedProblemStartingAppMsg");
        JVM_TERMINATED_NOTRESPOND_STRING = resourceBundle.getString("TargetAppRunner_JvmTerminatedNotRespondString");
        INTERNAL_PROBLEM_STRING = resourceBundle.getString("TargetAppRunner_InternalProblemString");
        FAILED_START_APP_CAUSE_MSG = resourceBundle.getString("TargetAppRunner_FailedStartAppCauseMsg");
        CALIBRATION_RESULTS_MSG = resourceBundle.getString("TargetAppRunner_CalibrationResultsMsg");
        CALIBRATION_ERROR_MSG = resourceBundle.getString("TargetAppRunner_CalibrationErrorMsg");
        INTERNAL_STATISTICS_ONLY_MSG = resourceBundle.getString("TargetAppRunner_InternalStatisticsOnlyMsg");
        INSTR_METHODS_COUNT_MSG = resourceBundle.getString("TargetAppRunner_InstrMethodsCountMsg");
        CLASSLOAD_FIRSTINV_COUNT_MSG = resourceBundle.getString("TargetAppRunner_ClassLoadFirstInvCountMsg");
        NON_EMPTY_IMG_COUNT_MSG = resourceBundle.getString("TargetAppRunner_NonEmptyImgCountMsg");
        EMPTY_IMG_COUNT_MSG = resourceBundle.getString("TargetAppRunner_EmptyImgCountMsg");
        SINGLE_IMG_COUNT_MSG = resourceBundle.getString("TargetAppRunner_SingleImgCountMsg");
        AVG_METHOD_TIME_MSG = resourceBundle.getString("TargetAppRunner_AvgMethodTimeMsg");
        MIN_METHOD_TIME_MSG = resourceBundle.getString("TargetAppRunner_MinMethodTimeMsg");
        MAX_METHOD_TIME_MSG = resourceBundle.getString("TargetAppRunner_MaxMethodTimeMsg");
        TOTAL_RUN_TIME_MSG = resourceBundle.getString("TargetAppRunner_TotalRunTimeMsg");
        INJ_INSTR_TIME_MSG = resourceBundle.getString("TargetAppRunner_InjInstrTimeMsg");
        TOTAL_INSTR_HOTSWAP_TIME_MSG = resourceBundle.getString("TargetAppRunner_TotalInstrHotSwapTimeMsg");
        BYTECODE_COMM_TIME_MSG = resourceBundle.getString("TargetAppRunner_ByteCodeCommTimeMsg");
        CLIENT_BYTECODE_TIME_MSG = resourceBundle.getString("TargetAppRunner_ClientByteCodeTimeMsg");
        CLIENT_DISK_PROCESS_MSG = resourceBundle.getString("TargetAppRunner_ClientDiskProcessTimeMsg");
        CLIENT_RESULTS_PROCESS_MSG = resourceBundle.getString("TargetAppRunner_ClientResultsProcessTimeMsg");
        PERFORMING_CALIBRATION_MSG = resourceBundle.getString("TargetAppRunner_PerformingCalibrationMsg");
        DEBUG = System.getProperty("org.netbeans.lib.profiler.TargetAppRunner") != null;
    }
}

