/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.LongBuffer;
import org.netbeans.lib.profiler.heap.LongMap;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;

class DominatorTree {
    private static final int BUFFER_SIZE = 8192;
    private static final int ADDITIONAL_IDS_THRESHOLD = 30;
    private HprofHeap heap;
    private LongBuffer multipleParents;
    private LongBuffer revertedMultipleParents;
    private LongBuffer currentMultipleParents;
    private Map<Long, Long> map;
    private Set dirtySet = Collections.EMPTY_SET;
    private Map nearestGCRootCache = new NearestGCRootCache(400000);

    DominatorTree(HprofHeap hprofHeap, LongBuffer longBuffer) {
        this.heap = hprofHeap;
        this.currentMultipleParents = this.multipleParents = longBuffer;
        this.map = new HashMap<Long, Long>(longBuffer.getSize());
        try {
            this.revertedMultipleParents = longBuffer.revertBuffer();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getLocalizedMessage(), iOException);
        }
    }

    synchronized void computeDominators() {
        boolean bl = true;
        try {
            boolean bl2;
            do {
                this.currentMultipleParents.rewind();
                bl2 = !bl;
                bl = this.computeOneLevel(bl2);
                this.switchParents();
            } while (bl || !bl2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.deleteBuffers();
        this.nearestGCRootCache = null;
        this.dirtySet = Collections.EMPTY_SET;
    }

    private boolean computeOneLevel(boolean bl) throws IOException {
        boolean bl2 = false;
        HashSet<Long> hashSet = new HashSet<Long>(this.map.size() / 10);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        int n = 0;
        while (true) {
            Long l;
            Long l2;
            long l3;
            if ((l3 = this.readLong()) == 0L) {
                if (n >= arrayList.size()) {
                    if (n <= 0) break;
                    break;
                }
                l3 = (Long)arrayList.get(n++);
            }
            if ((l2 = this.map.get(l = new Long(l3))) != null && (l2 == 0L || !bl && !this.dirtySet.contains(l2) && !this.dirtySet.contains(l))) continue;
            LongMap.Entry entry = this.heap.idToOffsetMap.get(l3);
            List list = entry.getReferences();
            Iterator iterator = list.iterator();
            Long l4 = (Long)iterator.next();
            boolean bl3 = false;
            while (iterator.hasNext() && l4 != 0L) {
                Long l5 = (Long)iterator.next();
                l4 = this.intersect(l4, l5);
            }
            if (l2 == null) {
                this.map.put(l, l4);
                hashSet.add(l4);
                bl2 = true;
                continue;
            }
            if (l2.longValue() == l4.longValue()) continue;
            hashSet.add(l2);
            hashSet.add(l4);
            this.map.put(l, l4);
            if (this.dirtySet.size() < 30) {
                this.updateAdditionalIds(l3, arrayList);
            }
            bl2 = true;
        }
        this.dirtySet = hashSet;
        return bl2;
    }

    private void updateAdditionalIds(long l, List<Long> list) {
        Instance instance = this.heap.getInstanceByID(l);
        if (instance != null) {
            for (Object e : instance.getFieldValues()) {
                long l2;
                Long l3;
                Long l4;
                Instance instance2;
                if (!(e instanceof ObjectFieldValue) || (instance2 = ((ObjectFieldValue)e).getInstance()) == null || (l4 = this.map.get(l3 = new Long(l2 = instance2.getInstanceId()))) == null || l4 == 0L) continue;
                list.add(l3);
            }
        }
    }

    private void deleteBuffers() {
        this.multipleParents.delete();
        this.revertedMultipleParents.delete();
    }

    private long readLong() throws IOException {
        return this.currentMultipleParents.readLong();
    }

    long getIdomId(long l, LongMap.Entry entry) {
        Long l2 = this.map.get(new Long(l));
        if (l2 != null) {
            return l2;
        }
        if (entry == null) {
            entry = this.heap.idToOffsetMap.get(l);
        }
        return entry.getNearestGCRootPointer();
    }

    private Long getNearestGCRootPointer(Long l) {
        Long l2 = (Long)this.nearestGCRootCache.get(l);
        if (l2 != null) {
            return l2;
        }
        LongMap.Entry entry = this.heap.idToOffsetMap.get(l);
        Long l3 = entry.getNearestGCRootPointer();
        this.nearestGCRootCache.put(l, l3);
        return l3;
    }

    private Long getIdomId(Long l) {
        Long l2 = this.map.get(l);
        if (l2 != null) {
            return l2;
        }
        return this.getNearestGCRootPointer(l);
    }

    private Long intersect(Long l, Long l2) {
        if (l.longValue() == l2.longValue()) {
            return l;
        }
        if (l == 0L || l2 == 0L) {
            return 0L;
        }
        HashSet<Long> hashSet = new HashSet<Long>(200);
        HashSet<Long> hashSet2 = new HashSet<Long>(200);
        Long l3 = l;
        Long l4 = l2;
        hashSet.add(l3);
        hashSet2.add(l4);
        while (true) {
            if (l3 != 0L) {
                if (hashSet2.contains(l3 = this.getIdomId(l3))) {
                    return l3;
                }
                hashSet.add(l3);
            }
            if (l4 == 0L) continue;
            if (hashSet.contains(l4 = this.getIdomId(l4))) {
                return l4;
            }
            hashSet2.add(l4);
        }
    }

    private void switchParents() {
        this.currentMultipleParents = this.currentMultipleParents == this.revertedMultipleParents ? this.multipleParents : this.revertedMultipleParents;
    }

    private void printObjs(List<Long> list, List<Long> list2, List<Long> list3, List<Boolean> list4, List<Long> list5) {
        if (list.size() > 20) {
            return;
        }
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        for (int i = 0; i < list.size(); ++i) {
            Number number = list.get(i);
            Long l = list2.get(i);
            Long l2 = list3.get(i);
            Long l3 = list5.get(i);
            Boolean bl = list4.get(i);
            Instance instance = this.heap.getInstanceByID((Long)number);
            int n = instance.getInstanceNumber();
            String string = "Index: " + l3 + (bl != false ? " New " : " Old ") + this.printInstance((Long)number);
            string = string + " OldDom " + this.printInstance(l);
            string = string + " NewDom: " + this.printInstance(l2);
            treeMap.put(n, string);
        }
        for (Number number : treeMap.keySet()) {
            System.out.println((String)treeMap.get(number));
        }
    }

    String printInstance(Long l) {
        if (l == null || l == 0L) {
            return "null";
        }
        Instance instance = this.heap.getInstanceByID(l);
        return instance.getJavaClass().getName() + "#" + instance.getInstanceNumber();
    }

    private static final class NearestGCRootCache
    extends LinkedHashMap {
        private final int maxSize;

        private NearestGCRootCache(int n) {
            super(n, 0.75f, true);
            this.maxSize = n;
        }

        protected boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > this.maxSize;
        }
    }
}

