/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu.cct;

import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.RuntimeCCTNodeProcessor;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainerFree;
import org.netbeans.lib.profiler.results.cpu.TimingAdjusterOld;
import org.netbeans.lib.profiler.results.cpu.cct.CCTResultsFilter;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MethodCPUCCTNode;

public class CCTFlattener
extends RuntimeCCTNodeProcessor.PluginAdapter {
    private static final Logger LOGGER = Logger.getLogger(CCTFlattener.class.getName());
    private final Object containerGuard = new Object();
    private FlatProfileContainer container;
    private ProfilerClient client;
    private Stack parentStack;
    private int[] invDiff;
    private int[] invPM;
    private int[] nCalleeInvocations;
    private long[] timePM0;
    private long[] timePM1;
    private int nMethods;
    private CCTResultsFilter currentFilter = null;

    public CCTFlattener(ProfilerClient profilerClient, CCTResultsFilter cCTResultsFilter) {
        this.client = profilerClient;
        this.parentStack = new Stack();
        this.currentFilter = cCTResultsFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlatProfileContainer getFlatProfile() {
        Object object = this.containerGuard;
        synchronized (object) {
            return this.container;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStart() {
        ProfilingSessionStatus profilingSessionStatus = this.client.getStatus();
        this.nMethods = profilingSessionStatus.getNInstrMethods();
        this.timePM0 = new long[this.nMethods];
        this.timePM1 = new long[profilingSessionStatus.collectingTwoTimeStamps() ? this.nMethods : 0];
        this.invPM = new int[this.nMethods];
        this.invDiff = new int[this.nMethods];
        this.nCalleeInvocations = new int[this.nMethods];
        this.parentStack.clear();
        Object object = this.containerGuard;
        synchronized (object) {
            this.container = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        ProfilingSessionStatus profilingSessionStatus = this.client.getStatus();
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        for (int i = 0; i < this.nMethods; ++i) {
            double d = TimingAdjusterOld.getInstance(profilingSessionStatus).adjustTime(this.timePM0[i], this.invPM[i] + this.invDiff[i], this.nCalleeInvocations[i] + this.invDiff[i], false);
            if (d < 0.0) {
                d = 0.0;
            }
            this.timePM0[i] = (long)d;
            if (i > 0) {
                l = (long)((double)l + d);
            }
            if (profilingSessionStatus.collectingTwoTimeStamps()) {
                d = TimingAdjusterOld.getInstance(profilingSessionStatus).adjustTime(this.timePM1[i], this.invPM[i] + this.invDiff[i], this.nCalleeInvocations[i] + this.invDiff[i], true);
                this.timePM1[i] = (long)d;
                if (i > 0) {
                    l2 = (long)((double)l2 + d);
                }
            }
            l3 += (long)this.invPM[i];
        }
        Object object = this.containerGuard;
        synchronized (object) {
            this.container = new FlatProfileContainerFree(profilingSessionStatus, this.timePM0, this.timePM1, this.invPM, new char[0], l, l2, this.invPM.length);
        }
        this.timePM1 = null;
        this.timePM0 = null;
        this.nCalleeInvocations = null;
        this.invDiff = null;
        this.invPM = null;
        this.parentStack.clear();
    }

    @Override
    public void onNode(MethodCPUCCTNode methodCPUCCTNode) {
        int n;
        String string;
        boolean bl;
        int n2 = methodCPUCCTNode.getMethodId();
        ProfilingSessionStatus profilingSessionStatus = this.client.getStatus();
        InstrumentationFilter instrumentationFilter = this.client.getSettings().getInstrumentationFilter();
        MethodCPUCCTNode methodCPUCCTNode2 = this.parentStack.isEmpty() ? null : (MethodCPUCCTNode)this.parentStack.peek();
        boolean bl2 = bl = methodCPUCCTNode.getFilteredStatus() == 2;
        if (!(bl || this.client.getSettings().getCPUProfilingType() != 2 && methodCPUCCTNode.getFilteredStatus() != 1 || instrumentationFilter.passesFilter(string = profilingSessionStatus.getInstrMethodClasses()[n2].replace('.', '/')))) {
            bl = true;
        }
        if (!bl && this.currentFilter != null) {
            bl = !this.currentFilter.passesFilter();
        }
        int n3 = n = methodCPUCCTNode2 != null ? methodCPUCCTNode2.getMethodId() : -1;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Processing runtime node: {0}.{1}; filtered={2}, time={3}, CPU time={4}", new Object[]{profilingSessionStatus.getInstrMethodClasses()[n2], profilingSessionStatus.getInstrMethodNames()[n2], bl, methodCPUCCTNode.getNetTime0(), methodCPUCCTNode.getNetTime1()});
            String string2 = methodCPUCCTNode2 != null ? profilingSessionStatus.getInstrMethodClasses()[n] + "." + profilingSessionStatus.getInstrMethodNames()[n] : "none";
            LOGGER.log(Level.FINEST, "Currently used parent: {0}", string2);
        }
        if (bl) {
            if (methodCPUCCTNode2 != null && !methodCPUCCTNode2.isRoot()) {
                int n4 = n;
                this.invDiff[n4] = this.invDiff[n4] + methodCPUCCTNode.getNCalls();
                int n5 = n;
                this.timePM0[n5] = this.timePM0[n5] + methodCPUCCTNode.getNetTime0();
                if (profilingSessionStatus.collectingTwoTimeStamps()) {
                    int n6 = n;
                    this.timePM1[n6] = this.timePM1[n6] + methodCPUCCTNode.getNetTime1();
                }
            }
        } else {
            int n7 = n2;
            this.timePM0[n7] = this.timePM0[n7] + methodCPUCCTNode.getNetTime0();
            if (profilingSessionStatus.collectingTwoTimeStamps()) {
                int n8 = n2;
                this.timePM1[n8] = this.timePM1[n8] + methodCPUCCTNode.getNetTime1();
            }
            int n9 = n2;
            this.invPM[n9] = this.invPM[n9] + methodCPUCCTNode.getNCalls();
            if (methodCPUCCTNode2 != null && !methodCPUCCTNode2.isRoot()) {
                int n10 = n;
                this.nCalleeInvocations[n10] = this.nCalleeInvocations[n10] + methodCPUCCTNode.getNCalls();
            }
            methodCPUCCTNode2 = methodCPUCCTNode;
        }
        this.parentStack.push(methodCPUCCTNode);
    }

    @Override
    public void onBackout(MethodCPUCCTNode methodCPUCCTNode) {
        this.parentStack.pop();
    }
}

