/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.threads;

import com.jrockit.mc.console.ui.threads.AllocatedBytesField;
import com.jrockit.mc.console.ui.threads.Messages;
import com.jrockit.mc.console.ui.threads.ThreadCPUField;
import com.jrockit.mc.console.ui.threads.ThreadsModel;
import com.jrockit.mc.console.ui.threads.support.ThreadInfoCompositeSupport;
import com.jrockit.mc.ui.fields.AbstractFieldTableContentProvider;
import com.jrockit.mc.ui.fields.FieldToolkit;
import com.jrockit.mc.ui.model.fields.BooleanField;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.NumberField;
import com.jrockit.mc.ui.model.fields.StringField;

public class AllThreadsContentProvider
extends AbstractFieldTableContentProvider {
    private static int FIELDCOUNT = 0;
    public static final Field FIELD_THREAD_NAME = new StringField(FIELDCOUNT++);
    public static final Field FIELD_BLOCKED_COUNT = new NumberField(FIELDCOUNT++);
    public static final Field FIELD_BLOCKED_TIME = new NumberField(FIELDCOUNT++);
    public static final Field FIELD_LOCK_NAME = new StringField(FIELDCOUNT++);
    public static final Field FIELD_LOCK_OWNER_ID = new NumberField(FIELDCOUNT++);
    public static final Field FIELD_LOCK_OWNER_NAME = new StringField(FIELDCOUNT++);
    public static final Field FIELD_THREAD_ID = new NumberField(FIELDCOUNT++);
    public static final Field FIELD_THREAD_STATE = new StringField(FIELDCOUNT++);
    public static final Field FIELD_WAITED_COUNT = new NumberField(FIELDCOUNT++);
    public static final Field FIELD_WAITED_TIME = new NumberField(FIELDCOUNT++);
    public static final Field FIELD_IS_NATIVE = new BooleanField(FIELDCOUNT++);
    public static final Field FIELD_IS_SUSPENDED = new BooleanField(FIELDCOUNT++);
    public static final Field FIELD_IS_DEADLOCKED = new StringField(FIELDCOUNT++);
    public static final Field FIELD_CPU_TIME = new ThreadCPUField(FIELDCOUNT++);
    public static final Field FIELD_ALLOCATED_BYTES = new AllocatedBytesField(FIELDCOUNT++);

    static {
        FieldToolkit.initializeFields((String)"com.jrockit.mc.console.ui.threads.fields", AllThreadsContentProvider.class);
    }

    public Object[] getRowElements(Object inputElement) {
        ThreadInfoCompositeSupport[] threads;
        if (inputElement instanceof ThreadsModel && (threads = ((ThreadsModel)inputElement).getAllThreadIds()) != null) {
            return threads;
        }
        if (inputElement instanceof ThreadInfoCompositeSupport) {
            ThreadInfoCompositeSupport threadInfo = (ThreadInfoCompositeSupport)((Object)inputElement);
            return threadInfo.getStackTrace();
        }
        return new Object[0];
    }

    private String getDeadlockFieldText(Object isDeadlocked) {
        if (isDeadlocked instanceof Boolean) {
            return new BooleanField(0).formatObject(isDeadlocked);
        }
        return Messages.ThreadTableSectionPart_DEADLOCK_DECECTION_NOT_ENABLED_TEXT;
    }

    public Object[] getColumnObject(Object inputRowElement) {
        if (inputRowElement instanceof ThreadInfoCompositeSupport) {
            ThreadInfoCompositeSupport threadInfo = (ThreadInfoCompositeSupport)((Object)inputRowElement);
            Object[] result = new Object[FIELDCOUNT];
            result[AllThreadsContentProvider.FIELD_THREAD_NAME.INDEX] = threadInfo.getThreadName();
            result[AllThreadsContentProvider.FIELD_BLOCKED_COUNT.INDEX] = threadInfo.getBlockedCount();
            result[AllThreadsContentProvider.FIELD_BLOCKED_TIME.INDEX] = this.getNegativeAsNull(threadInfo.getBlockedTime());
            result[AllThreadsContentProvider.FIELD_LOCK_NAME.INDEX] = threadInfo.getLockName();
            result[AllThreadsContentProvider.FIELD_LOCK_OWNER_ID.INDEX] = this.getNegativeAsNull(threadInfo.getLockOwnerId());
            result[AllThreadsContentProvider.FIELD_LOCK_OWNER_NAME.INDEX] = threadInfo.getLockOwnerName();
            result[AllThreadsContentProvider.FIELD_THREAD_ID.INDEX] = threadInfo.getThreadId();
            result[AllThreadsContentProvider.FIELD_THREAD_STATE.INDEX] = threadInfo.getThreadState();
            result[AllThreadsContentProvider.FIELD_WAITED_COUNT.INDEX] = threadInfo.getWaitedCount();
            result[AllThreadsContentProvider.FIELD_WAITED_TIME.INDEX] = this.getNegativeAsNull(threadInfo.getWaitedTime());
            result[AllThreadsContentProvider.FIELD_IS_NATIVE.INDEX] = threadInfo.isInNative();
            result[AllThreadsContentProvider.FIELD_IS_SUSPENDED.INDEX] = threadInfo.isSuspended();
            result[AllThreadsContentProvider.FIELD_IS_DEADLOCKED.INDEX] = this.getDeadlockFieldText(threadInfo.isDeadlocked());
            result[AllThreadsContentProvider.FIELD_CPU_TIME.INDEX] = threadInfo.getCPUTime();
            result[AllThreadsContentProvider.FIELD_ALLOCATED_BYTES.INDEX] = threadInfo.getAllocatedBytes();
            return result;
        }
        return new Object[0];
    }

    public Long getNegativeAsNull(Long longValue) {
        if (longValue != null && longValue == -1L) {
            return null;
        }
        return longValue;
    }
}

