/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.console.ui.threads;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.console.ui.actions.ResetToDefaultsAction;
import com.jrockit.mc.console.ui.editor.ConsoleTab;
import com.jrockit.mc.console.ui.threads.Messages;
import com.jrockit.mc.console.ui.threads.ThreadMasterDetailBlock;
import com.jrockit.mc.console.ui.threads.ThreadsModel;
import com.jrockit.mc.console.ui.threads.ThreadsPlugin;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.ui.AttributeVisualizerBuilder;
import com.jrockit.mc.rjmx.ui.internal.ChartModel;
import com.jrockit.mc.rjmx.ui.internal.CombinedChartSectionPart;
import com.jrockit.mc.rjmx.ui.internal.ISectionPartModifier;
import com.jrockit.mc.ui.layout.ReflowExpansionListener;
import com.jrockit.mc.ui.layout.SimpleLayout;
import com.jrockit.mc.ui.layout.SimpleLayoutData;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ThreadTab
extends ConsoleTab
implements XmlEnabled {
    private static final String PREFERENCE_KEY_THREADS_DATA = "threadsData";
    private static final String HELP_THREAD_TAB_THREAD_GRAPH_SECTION_CONTEXT = "com.jrockit.mc.console.ui.threads.help_ThreadGraphSection";
    private ThreadsModel m_model;
    private CombinedChartSectionPart m_graphSectionPart;

    private void addResetAction(ContributionManager manager) {
        ActionContributionItem aci = new ActionContributionItem((IAction)new ResetToDefaultsAction(){

            protected void reset() {
                ThreadTab.this.initializeThreadUsageGraph();
            }
        });
        aci.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        manager.insert(0, (IContributionItem)aci);
        manager.update(true);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.m_model = new ThreadsModel(this.getConnectionHandle());
        ScrolledForm form = managedForm.getForm();
        IToolBarManager toolbarManager = form.getToolBarManager();
        if (toolbarManager instanceof ContributionManager) {
            this.addResetAction((ContributionManager)toolbarManager);
        } else {
            ThreadsPlugin.getDefault().getLogger().severe("Eclipse implementation change! Could not add reset action!");
        }
        if (!this.initTabFromStore(ThreadsPlugin.getDefault().getPreferenceStore(), PREFERENCE_KEY_THREADS_DATA, this)) {
            this.createDefaults(managedForm);
        }
        managedForm.reflow(true);
    }

    private void createDefaults(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        this.createThreadUsageGraph(managedForm, form.getBody());
        this.createMasterDetailBlock(managedForm, form.getBody(), this.m_model);
    }

    public void createMasterDetailBlock(IManagedForm managedForm, Composite parent, ThreadsModel model) {
        ThreadMasterDetailBlock masterDetailBlock = new ThreadMasterDetailBlock((IFormPage)this, model);
        SimpleLayoutData layoutData = new SimpleLayoutData();
        layoutData.setWeight(1.0f);
        masterDetailBlock.createContent(managedForm, parent);
        ThreadTab.setUpLayout(parent);
        masterDetailBlock.getSashForm().setLayoutData((Object)layoutData);
        masterDetailBlock.getSashForm().setWeights(new int[]{2, 1});
    }

    private void createThreadUsageGraph(IManagedForm managedForm, Composite parent) {
        ThreadTab.setUpLayout(parent);
        int style = 258;
        AttributeVisualizerBuilder guiBuilder = new AttributeVisualizerBuilder(managedForm, parent, this.getConnectionHandle());
        guiBuilder.setProperty("sectionIdentifier", (Object)HELP_THREAD_TAB_THREAD_GRAPH_SECTION_CONTEXT);
        guiBuilder.setProperty("title", (Object)Messages.ThreadGraphSectionPart_LIVE_THREAD_GRAPH_TITLE);
        guiBuilder.setProperty("sectionStyle", (Object)style);
        guiBuilder.setProperty("rangeTypeY", (Object)ChartModel.AxisRange.AUTO);
        guiBuilder.setProperty("dataType", (Object)ChartModel.DataType.COUNT);
        ThreadTab.setSectionPartModifierProperty(guiBuilder, managedForm);
        this.m_graphSectionPart = guiBuilder.createChart();
        this.initializeThreadUsageGraph();
        this.m_graphSectionPart.setFormInput((Object)this.getConnectionHandle());
    }

    private void initializeThreadUsageGraph() {
        this.m_graphSectionPart.clear();
        this.m_graphSectionPart.add(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=Threading", "PeakThreadCount"));
        this.m_graphSectionPart.add(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=Threading", "ThreadCount"));
        this.m_graphSectionPart.add(new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=Threading", "DaemonThreadCount"));
    }

    private static void setUpLayout(Composite parent) {
        SimpleLayout layout = new SimpleLayout();
        layout.setHorizontalOrientation(false);
        parent.setLayout((Layout)layout);
    }

    public void dispose() {
        if (this.m_model != null) {
            this.m_model.dispose();
            this.m_model = null;
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.exportTabToStore(ThreadsPlugin.getDefault().getPreferenceStore(), PREFERENCE_KEY_THREADS_DATA, this);
    }

    public void exportToXml(Element parentNode) {
        Element e = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        e.setAttribute("uid", this.getConnectionHandle().getServerDescriptor().getGUID());
        this.m_graphSectionPart.exportToXml(e);
    }

    public String getComponentTag() {
        return "ThreadTab";
    }

    public void initializeFromXml(Element node) throws Exception {
        IManagedForm managedForm = this.getManagedForm();
        Composite parent = managedForm.getForm().getBody();
        List l = XmlToolkit.getChildElementsByTag((Node)node, (String)"CombinedChartSectionPart");
        if (ThreadTab.listContainsChart(l)) {
            this.initializeChartFromXml(managedForm, parent, (Element)l.get(0));
        }
        this.createMasterDetailBlock(managedForm, parent, this.m_model);
    }

    private static boolean listContainsChart(List<?> l) {
        return l != null && l.size() == 1;
    }

    private void initializeChartFromXml(IManagedForm managedForm, Composite parent, Element element) throws Exception {
        ThreadTab.setUpLayout(parent);
        AttributeVisualizerBuilder guiBuilder = new AttributeVisualizerBuilder(managedForm, this.getConnectionHandle());
        ThreadTab.setSectionPartModifierProperty(guiBuilder, managedForm);
        this.m_graphSectionPart = guiBuilder.createChart();
        this.m_graphSectionPart.initializeFromXml(element);
    }

    private static void setSectionPartModifierProperty(AttributeVisualizerBuilder guiBuilder, final IManagedForm managedForm) {
        guiBuilder.setProperty("SectionPartModifier", (Object)new ISectionPartModifier(){

            public void modifySectionPart(SectionPart sectionPart) {
                Section section = sectionPart.getSection();
                SimpleLayoutData sd = ReflowExpansionListener.createCollapsed((ExpandableComposite)section);
                sd.setWeight(2.0f);
                section.setLayoutData((Object)sd);
                section.addExpansionListener((IExpansionListener)new ReflowExpansionListener(managedForm));
                section.setExpanded(false);
            }
        });
    }
}

