/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.search;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.modules.search.FindDialogMemory;
import org.openide.util.NbPreferences;

public final class SearchHistory {
    private PropertyChangeSupport pcs;
    private static final int MAX_SEARCH_PATTERNS_ITEMS = 10;
    private List<SearchPattern> searchPatternsList = new ArrayList<SearchPattern>(10);
    private static SearchHistory INSTANCE = null;
    public static final String LAST_SELECTED = "last-selected";
    public static final String ADD_TO_HISTORY = "add-to-history";
    private static Preferences prefs;
    private static final String PREFS_NODE = "SearchHistory";
    private static final String PROP_SEARCH_PATTERN_PREFIX = "search_";

    private SearchHistory() {
        prefs = NbPreferences.forModule(SearchHistory.class).node(PREFS_NODE);
        this.load();
    }

    public static synchronized SearchHistory getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new SearchHistory();
        }
        return INSTANCE;
    }

    private void load() {
        for (int i = 0; i < 10; ++i) {
            SearchPattern searchPattern = SearchPattern.parseSearchPattern(prefs.get(PROP_SEARCH_PATTERN_PREFIX + i, null));
            if (searchPattern == null) continue;
            this.searchPatternsList.add(searchPattern);
        }
    }

    public SearchPattern getLastSelected() {
        return this.searchPatternsList.get(0);
    }

    public void setLastSelected(SearchPattern searchPattern) {
        SearchPattern searchPattern2 = this.searchPatternsList.get(0);
        this.add(searchPattern);
        if (this.pcs != null) {
            this.pcs.firePropertyChange(LAST_SELECTED, searchPattern2, searchPattern);
        }
    }

    private synchronized PropertyChangeSupport getPropertyChangeSupport() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public synchronized List<SearchPattern> getSearchPatterns() {
        return Collections.unmodifiableList(this.searchPatternsList);
    }

    public synchronized void add(SearchPattern searchPattern) {
        int n;
        if (searchPattern == null || searchPattern.getSearchExpression() == null || searchPattern.getSearchExpression().length() == 0 || this.searchPatternsList.size() > 0 && searchPattern.equals(this.searchPatternsList.get(0))) {
            return;
        }
        for (n = 0; n < this.searchPatternsList.size(); ++n) {
            if (!searchPattern.getSearchExpression().equals(this.searchPatternsList.get(n).getSearchExpression())) continue;
            this.searchPatternsList.remove(n);
            break;
        }
        if (this.searchPatternsList.size() == 10) {
            this.searchPatternsList.remove(9);
        }
        this.searchPatternsList.add(0, searchPattern);
        for (n = 0; n < this.searchPatternsList.size(); ++n) {
            prefs.put(PROP_SEARCH_PATTERN_PREFIX + n, this.searchPatternsList.get(n).toCanonicalString());
        }
        if (this.pcs != null) {
            this.pcs.firePropertyChange(ADD_TO_HISTORY, null, searchPattern);
        }
    }

    public void storeFileNamePattern(String string) {
        FindDialogMemory findDialogMemory = FindDialogMemory.getDefault();
        if (string == null) {
            findDialogMemory.setFileNamePatternSpecified(false);
        } else {
            findDialogMemory.setFileNamePatternSpecified(true);
            findDialogMemory.storeFileNamePattern(string);
        }
    }
}

