/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.search;

public final class SearchPattern {
    private String searchExpression;
    private boolean wholeWords;
    private boolean matchCase;
    private boolean regExp;

    private SearchPattern(String string, boolean bl, boolean bl2, boolean bl3) {
        this.searchExpression = string;
        this.wholeWords = bl;
        this.matchCase = bl2;
        this.regExp = bl3;
    }

    public static SearchPattern create(String string, boolean bl, boolean bl2, boolean bl3) {
        return new SearchPattern(string, bl, bl2, bl3);
    }

    public String getSearchExpression() {
        return this.searchExpression;
    }

    public boolean isWholeWords() {
        return this.wholeWords;
    }

    public boolean isMatchCase() {
        return this.matchCase;
    }

    public boolean isRegExp() {
        return this.regExp;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SearchPattern)) {
            return false;
        }
        SearchPattern searchPattern = (SearchPattern)object;
        return this.searchExpression.equals(searchPattern.getSearchExpression()) && this.wholeWords == searchPattern.isWholeWords() && this.matchCase == searchPattern.isMatchCase() && this.regExp == searchPattern.isRegExp();
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + (this.wholeWords ? 1 : 0);
        n = 37 * n + (this.matchCase ? 1 : 0);
        n = 37 * n + (this.regExp ? 1 : 0);
        n = 37 * n + this.searchExpression.hashCode();
        return n;
    }

    public SearchPattern changeSearchExpression(String string) {
        if (string == null && this.searchExpression == null || string != null && string.equals(this.searchExpression)) {
            return this;
        }
        return SearchPattern.create(string, this.wholeWords, this.matchCase, this.regExp);
    }

    public SearchPattern changeWholeWords(boolean bl) {
        if (this.wholeWords == bl) {
            return this;
        }
        return SearchPattern.create(this.searchExpression, bl, this.matchCase, this.regExp);
    }

    public SearchPattern changeMatchCase(boolean bl) {
        if (this.matchCase == bl) {
            return this;
        }
        return SearchPattern.create(this.searchExpression, this.wholeWords, bl, this.regExp);
    }

    public SearchPattern changeRegExp(boolean bl) {
        if (this.regExp == bl) {
            return this;
        }
        return SearchPattern.create(this.searchExpression, this.wholeWords, this.matchCase, bl);
    }

    String toCanonicalString() {
        char c = this.isMatchCase() ? (char)'M' : 'm';
        char c2 = this.isRegExp() ? (char)'R' : 'r';
        char c3 = this.isWholeWords() ? (char)'W' : 'w';
        return "" + c + c2 + c3 + "-" + this.getSearchExpression();
    }

    static SearchPattern parseSearchPattern(String string) {
        if (string == null || Character.toUpperCase(string.charAt(0)) != 'M' || Character.toUpperCase(string.charAt(1)) != 'R' || Character.toUpperCase(string.charAt(2)) != 'W' || string.charAt(3) != '-') {
            return null;
        }
        boolean bl = Character.isUpperCase(string.charAt(0));
        boolean bl2 = Character.isUpperCase(string.charAt(1));
        boolean bl3 = Character.isUpperCase(string.charAt(2));
        String string2 = string.substring(4);
        return new SearchPattern(string2, bl3, bl, bl2);
    }
}

