/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.search.provider.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.search.SearchScopeOptions;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.api.search.provider.impl.AbstractFileObjectIterator;
import org.openide.filesystems.FileObject;

public class CompoundSearchIterator
extends AbstractFileObjectIterator {
    private final SearchInfo[] elements;
    private int elementIndex;
    private Iterator<FileObject> elementIterator = null;
    private FileObject nextObject;
    private boolean upToDate;
    private SearchScopeOptions options;
    private SearchListener listener;
    private AtomicBoolean terminated;

    public CompoundSearchIterator(SearchInfo[] searchInfoArray, SearchScopeOptions searchScopeOptions, SearchListener searchListener, AtomicBoolean atomicBoolean) {
        if (searchInfoArray == null) {
            throw new IllegalArgumentException("Elements are null");
        }
        if (searchScopeOptions == null) {
            throw new IllegalArgumentException("Options are null");
        }
        this.options = searchScopeOptions;
        if (searchInfoArray.length == 0) {
            this.elements = null;
            this.elementIndex = 0;
            this.upToDate = true;
        } else {
            this.elements = searchInfoArray;
            this.upToDate = false;
        }
        this.listener = searchListener;
        this.terminated = atomicBoolean;
    }

    @Override
    public boolean hasNext() {
        if (!this.upToDate) {
            this.update();
        }
        return this.elements != null && this.elementIndex < this.elements.length;
    }

    @Override
    public FileObject next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.upToDate = false;
        return this.nextObject;
    }

    private void update() {
        assert (!this.upToDate);
        if (this.elementIterator == null) {
            this.elementIndex = 0;
            this.elementIterator = this.elements[0].getFilesToSearch(this.options, this.listener, this.terminated).iterator();
        }
        while (!this.elementIterator.hasNext()) {
            this.elements[this.elementIndex] = null;
            if (++this.elementIndex == this.elements.length) break;
            this.elementIterator = this.elements[this.elementIndex].getFilesToSearch(this.options, this.listener, this.terminated).iterator();
        }
        if (this.elementIndex < this.elements.length) {
            this.nextObject = this.elementIterator.next();
        } else {
            this.elementIterator = null;
            this.nextObject = null;
        }
        this.upToDate = true;
    }
}

