/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.search.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.api.search.ui.ComponentController;
import org.netbeans.modules.search.SearchPanel;
import org.netbeans.modules.search.SearchScopeList;
import org.netbeans.spi.search.SearchScopeDefinition;
import org.openide.util.WeakListeners;

public final class ScopeController
extends ComponentController<JComboBox> {
    SearchScopeChangeListener searchScopeChangeListener;
    ChangeListener searchScopeChangeListenerWeak;
    private SearchScopeDefinition selectedSearchScope;
    private ManualSelectionListener manualSelectionListener;
    private String preferredId = null;
    private String manuallySelectedId = null;
    private boolean active = false;
    SearchScopeList scopeList;
    SearchScopeDefinition[] extraSearchScopes;

    ScopeController(JComboBox jComboBox, String string, SearchScopeDefinition ... searchScopeDefinitionArray) {
        super(jComboBox);
        this.preferredId = string;
        this.manuallySelectedId = null;
        this.extraSearchScopes = searchScopeDefinitionArray;
        ((JComboBox)this.component).addHierarchyListener(new ScopeComboBoxHierarchyListener());
        ((JComboBox)this.component).setEditable(false);
    }

    private String chooseId() {
        if (SearchPanel.isOpenedForSelection()) {
            return "node selection";
        }
        return this.preferredId;
    }

    private void updateScopeItems(String string) {
        ((JComboBox)this.component).removeAllItems();
        this.selectedSearchScope = null;
        for (SearchScopeDefinition searchScopeDefinition : this.scopeList.getSeachScopeDefinitions()) {
            if (!searchScopeDefinition.isApplicable()) continue;
            ScopeItem scopeItem = new ScopeItem(searchScopeDefinition);
            ((JComboBox)this.component).addItem(scopeItem);
            if (this.selectedSearchScope != null || !searchScopeDefinition.getTypeId().equals(string)) continue;
            this.selectedSearchScope = searchScopeDefinition;
            ((JComboBox)this.component).setSelectedItem(scopeItem);
        }
        if (this.selectedSearchScope == null) {
            ScopeItem scopeItem = (ScopeItem)((JComboBox)this.component).getItemAt(0);
            this.selectedSearchScope = scopeItem.getSearchScope();
            ((JComboBox)this.component).setSelectedIndex(0);
        }
    }

    private SearchScopeDefinition getSelectedSearchScope() {
        return this.selectedSearchScope;
    }

    @CheckForNull
    public String getSelectedScopeId() {
        SearchScopeDefinition searchScopeDefinition = this.getSelectedSearchScope();
        return searchScopeDefinition == null ? null : searchScopeDefinition.getTypeId();
    }

    @CheckForNull
    public String getSelectedScopeTitle() {
        ScopeItem scopeItem = (ScopeItem)((JComboBox)this.component).getSelectedItem();
        return scopeItem == null ? null : scopeItem.toString();
    }

    @CheckForNull
    public SearchInfo getSearchInfo() {
        SearchScopeDefinition searchScopeDefinition = this.getSelectedSearchScope();
        if (searchScopeDefinition == null) {
            return null;
        }
        SearchInfo searchInfo = searchScopeDefinition.getSearchInfo();
        return searchInfo;
    }

    private class ScopeComboBoxHierarchyListener
    implements HierarchyListener {
        private ScopeComboBoxHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & 4L) != 0L) {
                this.toggleListeners();
            }
        }

        private synchronized void toggleListeners() {
            if (((JComboBox)ScopeController.this.component).isShowing() && !ScopeController.this.active) {
                this.initListeners();
            } else if (!((JComboBox)ScopeController.this.component).isShowing() && ScopeController.this.active) {
                this.cleanListeners();
            }
        }

        private void initListeners() {
            if (ScopeController.this.manuallySelectedId == null) {
                ScopeController.this.manuallySelectedId = ScopeController.this.chooseId();
            }
            ScopeController.this.scopeList = new SearchScopeList(ScopeController.this.extraSearchScopes);
            ScopeController.this.manualSelectionListener = new ManualSelectionListener();
            ScopeController.this.searchScopeChangeListener = new SearchScopeChangeListener();
            ScopeController.this.searchScopeChangeListenerWeak = WeakListeners.change((ChangeListener)ScopeController.this.searchScopeChangeListener, (Object)ScopeController.this.scopeList);
            ScopeController.this.scopeList.addChangeListener(ScopeController.this.searchScopeChangeListenerWeak);
            ScopeController.this.updateScopeItems(ScopeController.this.manuallySelectedId);
            ((JComboBox)ScopeController.this.component).addActionListener(ScopeController.this.manualSelectionListener);
            ScopeController.this.active = true;
        }

        private void cleanListeners() {
            ScopeController.this.scopeList.removeChangeListener(ScopeController.this.searchScopeChangeListenerWeak);
            ScopeController.this.searchScopeChangeListenerWeak = null;
            ScopeController.this.searchScopeChangeListener = null;
            ScopeController.this.scopeList.clean();
            ScopeController.this.scopeList = null;
            ((JComboBox)ScopeController.this.component).removeActionListener(ScopeController.this.manualSelectionListener);
            ScopeController.this.manualSelectionListener = null;
            ScopeController.this.active = false;
        }
    }

    private class ManualSelectionListener
    implements ActionListener {
        private ManualSelectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ScopeItem scopeItem = (ScopeItem)((JComboBox)ScopeController.this.component).getSelectedItem();
            if (scopeItem != null) {
                ScopeController.this.selectedSearchScope = scopeItem.getSearchScope();
                ScopeController.this.manuallySelectedId = ScopeController.this.selectedSearchScope.getTypeId();
                ScopeController.this.selectedSearchScope.selected();
            } else {
                ScopeController.this.selectedSearchScope = null;
            }
        }
    }

    private class SearchScopeChangeListener
    implements ChangeListener {
        private SearchScopeChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (ScopeController.this.manuallySelectedId == null && ScopeController.this.selectedSearchScope != null) {
                ScopeController.this.manuallySelectedId = ScopeController.this.selectedSearchScope.getTypeId();
            }
            ((JComboBox)ScopeController.this.component).removeActionListener(ScopeController.this.manualSelectionListener);
            ScopeController.this.updateScopeItems(ScopeController.this.manuallySelectedId);
            ((JComboBox)ScopeController.this.component).addActionListener(ScopeController.this.manualSelectionListener);
            Dialog dialog = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, ScopeController.this.component);
            if (dialog != null) {
                dialog.repaint();
            }
        }
    }

    private final class ScopeItem {
        private static final String START = "(";
        private static final String END = ")";
        private static final String SP = " ";
        private static final String ELLIPSIS = "...";
        private static final int MAX_EXTRA_INFO_LEN = 20;
        private SearchScopeDefinition searchScope;

        public ScopeItem(SearchScopeDefinition searchScopeDefinition) {
            this.searchScope = searchScopeDefinition;
        }

        public SearchScopeDefinition getSearchScope() {
            return this.searchScope;
        }

        private boolean isAdditionaInfoAvailable() {
            return this.searchScope.getAdditionalInfo() != null && this.searchScope.getAdditionalInfo().length() > 0;
        }

        private String getTextForLabel(String string) {
            String string2;
            String string3 = string2 = this.searchScope.getAdditionalInfo();
            if (string2.length() > 20 && (string3 = string2.substring(0, 20) + ELLIPSIS).length() >= string2.length()) {
                string3 = string2;
            }
            return this.getFullText(string, string3);
        }

        private String getFullText(String string, String string2) {
            return string + SP + START + SP + string2 + SP + END;
        }

        public String toString() {
            if (this.isAdditionaInfoAvailable()) {
                return this.getTextForLabel(this.clr(this.searchScope.getDisplayName()));
            }
            return this.clr(this.searchScope.getDisplayName());
        }

        private String clr(String string) {
            return string == null ? "" : string.replaceAll("\\&", "");
        }
    }
}

