/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.search.SearchHistory;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.api.search.ui.ComponentUtils;
import org.netbeans.api.search.ui.FileNameController;
import org.netbeans.api.search.ui.ScopeController;
import org.netbeans.api.search.ui.ScopeOptionsController;
import org.netbeans.api.search.ui.SearchPatternController;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.FindDialogMemory;
import org.netbeans.modules.search.ListComboBoxModel;
import org.netbeans.modules.search.PatternSandbox;
import org.netbeans.modules.search.SearchPanel;
import org.netbeans.modules.search.ui.CheckBoxWithButtonPanel;
import org.netbeans.modules.search.ui.FormLayoutHelper;
import org.netbeans.modules.search.ui.PatternChangeListener;
import org.netbeans.modules.search.ui.TextFieldFocusListener;
import org.netbeans.modules.search.ui.UiUtils;
import org.netbeans.spi.search.SearchScopeDefinition;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.windows.TopComponent;

final class BasicSearchForm
extends JPanel
implements ChangeListener,
ItemListener {
    private final String preferredSearchScopeType;
    private ChangeListener usabilityChangeListener;
    private BasicSearchCriteria searchCriteria = new BasicSearchCriteria();
    private SearchScopeDefinition[] extraSearchScopes;
    private static final Logger watcherLogger = Logger.getLogger("org.netbeans.modules.search.BasicSearchForm.FileNamePatternWatcher");
    private SearchPatternController cboxTextToFind;
    private JComboBox cboxReplacement;
    private FileNameController cboxFileNamePattern;
    private JCheckBox chkWholeWords;
    private JCheckBox chkCaseSensitive;
    private JCheckBox chkRegexp;
    private JCheckBox chkPreserveCase;
    private JTextComponent replacementPatternEditor;
    protected SearchFormPanel formPanel;
    private JButton btnTestTextToFind;
    private JLabel lblTextToFind;
    private ScopeController cboxScope;
    private JLabel lblFileNamePattern;
    private JLabel lblScope;
    private JLabel lblReplacement;
    private Color errorTextColor;
    private Color defaultTextColor;
    private boolean invalidTextPattern = false;
    private boolean invalidReplacePattern = false;
    private ScopeOptionsController scopeSettingsPanel;

    BasicSearchForm(String string, boolean bl, BasicSearchCriteria basicSearchCriteria, SearchScopeDefinition ... searchScopeDefinitionArray) {
        this.preferredSearchScopeType = string;
        this.extraSearchScopes = searchScopeDefinitionArray;
        this.initComponents(bl);
        this.initAccessibility(bl);
        this.initHistory();
        if (bl && this.searchCriteria.getReplaceExpr() == null) {
            this.searchCriteria.setReplaceExpr("");
        }
        this.initInteraction(bl);
        this.setValuesOfComponents(basicSearchCriteria, bl);
    }

    private void setValuesOfComponents(BasicSearchCriteria basicSearchCriteria, boolean bl) {
        if (basicSearchCriteria != null) {
            this.initValuesFromCriteria(basicSearchCriteria, bl);
        } else {
            this.initValuesFromHistory(bl);
        }
        if (bl) {
            this.updateReplacePatternColor();
        }
        this.useCurrentlySelectedText();
        this.setSearchCriteriaValues();
    }

    public void useCurrentlySelectedText() {
        String string;
        JEditorPane jEditorPane;
        EditorCookie editorCookie;
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray.length > 0 && (editorCookie = (EditorCookie)nodeArray[0].getLookup().lookup(EditorCookie.class)) != null && (jEditorPane = NbDocument.findRecentEditorPane((EditorCookie)editorCookie)) != null && (string = jEditorPane.getSelectedText()) != null) {
            this.cboxTextToFind.setSearchPattern(SearchPattern.create(string, false, false, false));
            this.searchCriteria.setTextPattern(string);
            return;
        }
        this.searchCriteria.setTextPattern(this.cboxTextToFind.getSearchPattern().getSearchExpression());
    }

    private void initComponents(boolean bl) {
        this.lblTextToFind = new JLabel();
        this.cboxTextToFind = ComponentUtils.adjustComboForSearchPattern(new JComboBox());
        this.lblTextToFind.setLabelFor((Component)this.cboxTextToFind.getComponent());
        this.btnTestTextToFind = new JButton();
        if (bl) {
            this.lblReplacement = new JLabel();
            this.cboxReplacement = new JComboBox();
            this.cboxReplacement.setEditable(true);
            this.lblReplacement.setLabelFor(this.cboxReplacement);
            this.chkPreserveCase = new JCheckBox();
        }
        this.lblScope = new JLabel();
        this.cboxScope = ComponentUtils.adjustComboForScope(new JComboBox(), this.preferredSearchScopeType, this.extraSearchScopes);
        this.lblScope.setLabelFor((Component)this.cboxScope.getComponent());
        this.lblFileNamePattern = new JLabel();
        this.cboxFileNamePattern = ComponentUtils.adjustComboForFileName(new JComboBox());
        this.lblFileNamePattern.setLabelFor((Component)this.cboxFileNamePattern.getComponent());
        this.chkWholeWords = new JCheckBox();
        this.chkCaseSensitive = new JCheckBox();
        this.chkRegexp = new JCheckBox();
        TextPatternCheckBoxGroup.bind(this.chkCaseSensitive, this.chkWholeWords, this.chkRegexp, this.chkPreserveCase);
        this.setMnemonics(bl);
        this.initFormPanel(bl);
        this.add(this.formPanel);
        if (this.cboxReplacement != null) {
            Component component = this.cboxReplacement.getEditor().getEditorComponent();
            this.replacementPatternEditor = (JTextComponent)component;
        }
        this.setLayout(new BoxLayout(this, 3));
    }

    protected void initFormPanel(boolean bl) {
        this.formPanel = new SearchFormPanel();
        this.formPanel.addRow(this.lblTextToFind, (JComponent)this.cboxTextToFind.getComponent());
        this.initContainingTextOptionsRow(bl);
        if (bl) {
            this.formPanel.addRow(this.lblReplacement, this.cboxReplacement);
        }
        this.formPanel.addRow(this.lblScope, (JComponent)this.cboxScope.getComponent());
        this.formPanel.addRow(this.lblFileNamePattern, (JComponent)this.cboxFileNamePattern.getComponent());
        this.initScopeOptionsRow(bl);
    }

    private void initContainingTextOptionsRow(boolean bl) {
        JPanel jPanel = new JPanel();
        if (bl) {
            FormLayoutHelper formLayoutHelper = new FormLayoutHelper(jPanel, FormLayoutHelper.DEFAULT_COLUMN, FormLayoutHelper.DEFAULT_COLUMN);
            formLayoutHelper.addRow(this.chkCaseSensitive, this.chkPreserveCase);
            formLayoutHelper.addRow(this.chkWholeWords, new CheckBoxWithButtonPanel(this.chkRegexp, this.btnTestTextToFind));
            jPanel.setMaximumSize(jPanel.getMinimumSize());
            this.formPanel.addRow(new JLabel(), jPanel);
        } else {
            jPanel.setLayout(new FlowLayout(3, 0, 0));
            jPanel.add(this.chkCaseSensitive);
            jPanel.add(this.chkWholeWords);
            jPanel.add(new CheckBoxWithButtonPanel(this.chkRegexp, this.btnTestTextToFind));
            jPanel.setMaximumSize(jPanel.getPreferredSize());
            this.formPanel.addRow(new JLabel(), jPanel);
        }
    }

    private void initScopeOptionsRow(boolean bl) {
        this.scopeSettingsPanel = ComponentUtils.adjustPanelForOptions(new JPanel(), bl, this.cboxFileNamePattern);
        this.formPanel.addRow(new JLabel(), (JComponent)this.scopeSettingsPanel.getComponent());
    }

    private void initAccessibility(boolean bl) {
        this.chkCaseSensitive.getAccessibleContext().setAccessibleDescription(UiUtils.getText("BasicSearchForm.chkCaseSensitive.AccessibleDescription"));
        this.chkRegexp.getAccessibleContext().setAccessibleDescription(UiUtils.getText("BasicSearchForm.chkRegexp.AccessibleDescription"));
        this.chkWholeWords.getAccessibleContext().setAccessibleDescription(UiUtils.getText("BasicSearchForm.chkWholeWords.AccessibleDescription"));
        if (bl) {
            this.cboxReplacement.getAccessibleContext().setAccessibleDescription(UiUtils.getText("BasicSearchForm.cbox.Replacement.AccessibleDescription"));
            this.chkPreserveCase.getAccessibleContext().setAccessibleDescription(UiUtils.getText("BasicSearchForm.chkPreserveCase.AccessibleDescription"));
        }
    }

    private void initValuesFromCriteria(BasicSearchCriteria basicSearchCriteria, boolean bl) {
        this.cboxTextToFind.setSearchPattern(basicSearchCriteria.getSearchPattern());
        if (this.cboxReplacement != null) {
            this.cboxReplacement.setSelectedItem(basicSearchCriteria.getReplaceExpr());
        }
        BasicSearchForm.selectChk(this.chkPreserveCase, basicSearchCriteria.isPreserveCase());
        this.scopeSettingsPanel.setFileNameRegexp(basicSearchCriteria.isFileNameRegexp());
        this.scopeSettingsPanel.setUseIgnoreList(basicSearchCriteria.isUseIgnoreList());
        this.cboxFileNamePattern.setRegularExpression(basicSearchCriteria.isFileNameRegexp());
        this.cboxFileNamePattern.setFileNamePattern(basicSearchCriteria.getFileNamePatternExpr());
        if (!bl) {
            this.scopeSettingsPanel.setSearchInArchives(basicSearchCriteria.isSearchInArchives());
            this.scopeSettingsPanel.setSearchInGenerated(basicSearchCriteria.isSearchInGenerated());
        }
    }

    private static void selectChk(JCheckBox jCheckBox, boolean bl) {
        if (jCheckBox != null) {
            jCheckBox.setSelected(bl);
        }
    }

    private void initInteraction(boolean bl) {
        TextFieldFocusListener textFieldFocusListener = new TextFieldFocusListener();
        if (this.replacementPatternEditor != null) {
            this.replacementPatternEditor.addFocusListener(textFieldFocusListener);
        }
        if (this.replacementPatternEditor != null) {
            this.replacementPatternEditor.getDocument().addDocumentListener(new ReplacementPatternListener());
        }
        this.chkRegexp.addItemListener(this);
        this.cboxTextToFind.bind(SearchPatternController.Option.REGULAR_EXPRESSION, this.chkRegexp);
        this.cboxTextToFind.bind(SearchPatternController.Option.MATCH_CASE, this.chkCaseSensitive);
        this.cboxTextToFind.bind(SearchPatternController.Option.WHOLE_WORDS, this.chkWholeWords);
        boolean bl2 = this.chkRegexp.isSelected();
        boolean bl3 = this.chkCaseSensitive.isSelected();
        this.chkWholeWords.setEnabled(!bl2);
        if (bl) {
            this.chkPreserveCase.addItemListener(this);
            this.chkPreserveCase.setEnabled(!bl2 && !bl3);
        }
        this.searchCriteria.setUsabilityChangeListener(this);
        this.scopeSettingsPanel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                BasicSearchForm.this.searchCriteria.setSearchInArchives(BasicSearchForm.this.scopeSettingsPanel.isSearchInArchives());
                BasicSearchForm.this.searchCriteria.setSearchInGenerated(BasicSearchForm.this.scopeSettingsPanel.isSearchInGenerated());
                BasicSearchForm.this.searchCriteria.setUseIgnoreList(BasicSearchForm.this.scopeSettingsPanel.isUseIgnoreList());
            }
        });
        this.cboxFileNamePattern.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                BasicSearchForm.this.searchCriteria.setFileNamePattern(BasicSearchForm.this.cboxFileNamePattern.getFileNamePattern());
                BasicSearchForm.this.searchCriteria.setFileNameRegexp(BasicSearchForm.this.cboxFileNamePattern.isRegularExpression());
            }
        });
        this.cboxTextToFind.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SearchPattern searchPattern = BasicSearchForm.this.cboxTextToFind.getSearchPattern();
                BasicSearchForm.this.searchCriteria.setTextPattern(searchPattern.getSearchExpression());
                BasicSearchForm.this.searchCriteria.setRegexp(searchPattern.isRegExp());
                BasicSearchForm.this.searchCriteria.setWholeWords(searchPattern.isWholeWords());
                BasicSearchForm.this.searchCriteria.setCaseSensitive(searchPattern.isMatchCase());
            }
        });
        this.initButtonInteraction();
    }

    private void initButtonInteraction() {
        this.btnTestTextToFind.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BasicSearchForm.this.openTextPatternSandbox();
            }
        });
    }

    private void openTextPatternSandbox() {
        SearchPattern searchPattern = this.cboxTextToFind.getSearchPattern();
        String string = searchPattern.getSearchExpression() == null ? "" : searchPattern.getSearchExpression();
        boolean bl = this.chkCaseSensitive.isSelected();
        PatternSandbox.openDialog(new PatternSandbox.TextPatternSandbox(string, bl){

            @Override
            protected void onApply(String string, boolean bl) {
                BasicSearchForm.this.cboxTextToFind.setSearchPattern(SearchPattern.create(string, false, bl, true));
            }
        }, this.btnTestTextToFind);
    }

    private void initHistory() {
        List<String> list;
        FindDialogMemory findDialogMemory = FindDialogMemory.getDefault();
        if (this.cboxReplacement != null && !(list = findDialogMemory.getReplacementExpressions()).isEmpty()) {
            this.cboxReplacement.setModel(new ListComboBoxModel(list, true));
        }
    }

    private void initValuesFromHistory(boolean bl) {
        FindDialogMemory findDialogMemory = FindDialogMemory.getDefault();
        if (findDialogMemory.isFileNamePatternSpecified() && ((JComboBox)this.cboxFileNamePattern.getComponent()).getItemCount() != 0) {
            ((JComboBox)this.cboxFileNamePattern.getComponent()).setSelectedIndex(0);
        }
        if (this.cboxReplacement != null && this.cboxReplacement.getItemCount() != 0) {
            this.cboxReplacement.setSelectedIndex(0);
        }
        this.chkWholeWords.setSelected(findDialogMemory.isWholeWords());
        this.chkCaseSensitive.setSelected(findDialogMemory.isCaseSensitive());
        this.chkRegexp.setSelected(findDialogMemory.isRegularExpression());
        this.scopeSettingsPanel.setFileNameRegexp(findDialogMemory.isFilePathRegex());
        this.scopeSettingsPanel.setUseIgnoreList(findDialogMemory.IsUseIgnoreList());
        if (bl) {
            this.chkPreserveCase.setSelected(findDialogMemory.isPreserveCase());
        } else {
            this.scopeSettingsPanel.setSearchInArchives(findDialogMemory.isSearchInArchives());
            this.scopeSettingsPanel.setSearchInGenerated(findDialogMemory.isSearchInGenerated());
        }
    }

    private void setSearchCriteriaValues() {
        this.searchCriteria.setWholeWords(this.chkWholeWords.isSelected());
        this.searchCriteria.setCaseSensitive(this.chkCaseSensitive.isSelected());
        this.searchCriteria.setRegexp(this.chkRegexp.isSelected());
        this.searchCriteria.setFileNameRegexp(this.scopeSettingsPanel.isFileNameRegExp());
        this.searchCriteria.setUseIgnoreList(this.scopeSettingsPanel.isUseIgnoreList());
        this.searchCriteria.setSearchInArchives(this.scopeSettingsPanel.isSearchInArchives());
        this.searchCriteria.setSearchInGenerated(this.scopeSettingsPanel.isSearchInGenerated());
        if (this.chkPreserveCase != null) {
            this.searchCriteria.setPreserveCase(this.chkPreserveCase.isSelected());
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        return ((JComboBox)this.cboxTextToFind.getComponent()).requestFocusInWindow();
    }

    private void updateReplacePatternColor() {
        boolean bl = this.invalidReplacePattern;
        this.invalidReplacePattern = this.searchCriteria.isReplacePatternInvalid();
        if (this.invalidReplacePattern != bl) {
            if (this.defaultTextColor == null) {
                assert (!bl);
                this.defaultTextColor = this.cboxReplacement.getForeground();
            }
            this.replacementPatternEditor.setForeground(this.invalidReplacePattern ? this.getErrorTextColor() : this.defaultTextColor);
        }
    }

    private static boolean isBackrefSyntaxUsed(String string) {
        int n;
        int n2 = string.length();
        if (n2 < 2) {
            return false;
        }
        String string2 = string.substring(0, n2 - 1);
        int n3 = 0;
        while ((n = string2.indexOf(92, n3)) != -1) {
            char c = string.charAt(n + 1);
            if (c == '\\') {
                n3 = n + 1;
                continue;
            }
            if (c >= '0' && c <= '9') {
                return true;
            }
            n3 = n + 2;
        }
        return false;
    }

    private Color getErrorTextColor() {
        if (this.errorTextColor == null) {
            this.errorTextColor = UIManager.getDefaults().getColor("TextField.errorForeground");
            if (this.errorTextColor == null) {
                this.errorTextColor = Color.RED;
            }
        }
        return this.errorTextColor;
    }

    void setUsabilityChangeListener(ChangeListener changeListener) {
        this.usabilityChangeListener = changeListener;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (this.usabilityChangeListener != null) {
            this.usabilityChangeListener.stateChanged(new ChangeEvent(this));
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (itemSelectable == this.chkRegexp) {
            if (this.cboxReplacement != null) {
                this.updateReplacePatternColor();
            }
            this.setTextToFindToolTip();
        } else if (itemSelectable == this.chkPreserveCase) {
            this.searchCriteria.setPreserveCase(bl);
        } else assert (false);
    }

    private void setTextToFindToolTip() {
        String string = this.searchCriteria.isRegexp() ? null : UiUtils.getText("BasicSearchForm.cboxTextToFind.tooltip");
        ((JComboBox)this.cboxTextToFind.getComponent()).setToolTipText(string);
    }

    void onOk() {
        this.searchCriteria.onOk();
        FindDialogMemory findDialogMemory = FindDialogMemory.getDefault();
        if (this.searchCriteria.isTextPatternUsable()) {
            SearchHistory.getDefault().add(this.getCurrentSearchPattern());
            findDialogMemory.setTextPatternSpecified(true);
        } else {
            findDialogMemory.setTextPatternSpecified(false);
        }
        if (this.searchCriteria.isFileNamePatternUsable()) {
            findDialogMemory.storeFileNamePattern(this.searchCriteria.getFileNamePatternExpr());
            findDialogMemory.setFileNamePatternSpecified(true);
        } else {
            findDialogMemory.setFileNamePatternSpecified(false);
        }
        if (this.replacementPatternEditor != null) {
            findDialogMemory.storeReplacementExpression(this.replacementPatternEditor.getText());
        }
        findDialogMemory.setWholeWords(this.chkWholeWords.isSelected());
        findDialogMemory.setCaseSensitive(this.chkCaseSensitive.isSelected());
        findDialogMemory.setRegularExpression(this.chkRegexp.isSelected());
        if (this.searchCriteria.isSearchAndReplace()) {
            findDialogMemory.setPreserveCase(this.chkPreserveCase.isSelected());
        } else {
            findDialogMemory.setSearchInArchives(this.scopeSettingsPanel.isSearchInArchives());
            findDialogMemory.setSearchInGenerated(this.scopeSettingsPanel.isSearchInGenerated());
        }
        findDialogMemory.setFilePathRegex(this.scopeSettingsPanel.isFileNameRegExp());
        findDialogMemory.setUseIgnoreList(this.scopeSettingsPanel.isUseIgnoreList());
        if (this.cboxScope.getSelectedScopeId() != null && !SearchPanel.isOpenedForSelection()) {
            findDialogMemory.setScopeTypeId(this.cboxScope.getSelectedScopeId());
        }
    }

    private SearchPattern getCurrentSearchPattern() {
        return this.cboxTextToFind.getSearchPattern();
    }

    public SearchInfo getSearchInfo() {
        return this.cboxScope.getSearchInfo();
    }

    public String getSelectedScopeName() {
        return this.cboxScope.getSelectedScopeTitle();
    }

    BasicSearchCriteria getBasicSearchCriteria() {
        return this.searchCriteria;
    }

    boolean isUsable() {
        return this.cboxScope.getSearchInfo() != null && this.searchCriteria.isUsable();
    }

    private void setMnemonics(boolean bl) {
        this.lclz(this.lblTextToFind, "BasicSearchForm.lblTextToFind.text");
        this.lclz(this.lblScope, "BasicSearchForm.lblScope.text");
        this.lclz(this.lblFileNamePattern, "BasicSearchForm.lblFileNamePattern.text");
        this.lclz(this.chkWholeWords, "BasicSearchForm.chkWholeWords.text");
        this.lclz(this.chkCaseSensitive, "BasicSearchForm.chkCaseSensitive.text");
        this.lclz(this.chkRegexp, "BasicSearchForm.chkRegexp.text");
        this.btnTestTextToFind.setText(UiUtils.getHtmlLink("BasicSearchForm.btnTestTextToFind.text"));
        if (bl) {
            this.lclz(this.lblReplacement, "BasicSearchForm.lblReplacement.text");
            this.lclz(this.chkPreserveCase, "BasicSearchForm.chkPreserveCase.text");
        }
        this.setTextToFindToolTip();
    }

    private void lclz(AbstractButton abstractButton, String string) {
        UiUtils.lclz(abstractButton, string);
    }

    private void lclz(JLabel jLabel, String string) {
        UiUtils.lclz(jLabel, string);
    }

    private class ReplacementPatternListener
    extends PatternChangeListener {
        @Override
        public void handleComboBoxChange(String string) {
            BasicSearchForm.this.searchCriteria.setReplaceExpr(string);
            if (BasicSearchForm.this.cboxReplacement != null) {
                BasicSearchForm.this.updateReplacePatternColor();
            }
        }
    }

    static class TextPatternCheckBoxGroup
    implements ItemListener {
        private JCheckBox matchCase;
        private JCheckBox wholeWords;
        private JCheckBox regexp;
        private JCheckBox preserveCase;
        private boolean lastPreserveCaseValue;
        private boolean lastWholeWordsValue;

        private TextPatternCheckBoxGroup(JCheckBox jCheckBox, JCheckBox jCheckBox2, JCheckBox jCheckBox3, JCheckBox jCheckBox4) {
            this.matchCase = jCheckBox;
            this.wholeWords = jCheckBox2;
            this.regexp = jCheckBox3;
            this.preserveCase = jCheckBox4;
        }

        private void initListeners() {
            this.matchCase.addItemListener(this);
            this.wholeWords.addItemListener(this);
            this.regexp.addItemListener(this);
            if (this.preserveCase != null) {
                this.preserveCase.addItemListener(this);
            }
        }

        private void matchCaseChanged() {
            this.updatePreserveCaseAllowed();
        }

        private void regexpChanged() {
            this.updateWholeWordsAllowed();
            this.updatePreserveCaseAllowed();
        }

        private void updateWholeWordsAllowed() {
            if (this.regexp.isSelected() == this.wholeWords.isEnabled()) {
                if (this.regexp.isSelected()) {
                    this.lastWholeWordsValue = this.wholeWords.isSelected();
                    this.wholeWords.setSelected(false);
                    this.wholeWords.setEnabled(false);
                } else {
                    this.wholeWords.setEnabled(true);
                    this.wholeWords.setSelected(this.lastWholeWordsValue);
                }
            }
        }

        private void updatePreserveCaseAllowed() {
            if (this.preserveCase == null) {
                return;
            }
            if (this.preserveCase.isEnabled() == (this.regexp.isSelected() || this.matchCase.isSelected())) {
                if (this.preserveCase.isEnabled()) {
                    this.lastPreserveCaseValue = this.preserveCase.isSelected();
                    this.preserveCase.setSelected(false);
                    this.preserveCase.setEnabled(false);
                } else {
                    this.preserveCase.setEnabled(true);
                    this.preserveCase.setSelected(this.lastPreserveCaseValue);
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemSelectable == this.matchCase) {
                this.matchCaseChanged();
            } else if (itemSelectable == this.regexp) {
                this.regexpChanged();
            }
        }

        static void bind(JCheckBox jCheckBox, JCheckBox jCheckBox2, JCheckBox jCheckBox3, JCheckBox jCheckBox4) {
            TextPatternCheckBoxGroup textPatternCheckBoxGroup = new TextPatternCheckBoxGroup(jCheckBox, jCheckBox2, jCheckBox3, jCheckBox4);
            textPatternCheckBoxGroup.initListeners();
        }
    }

    private final class SearchFormPanel
    extends JPanel {
        private FormLayoutHelper flh = new FormLayoutHelper(this, FormLayoutHelper.DEFAULT_COLUMN, FormLayoutHelper.DEFAULT_COLUMN);

        public SearchFormPanel() {
            this.flh.setAllGaps(true);
        }

        public void addRow(JComponent jComponent, JComponent jComponent2) {
            this.flh.addRow(jComponent, jComponent2);
        }
    }
}

