/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.search.RegexpUtil;
import org.netbeans.api.search.SearchScopeOptions;
import org.netbeans.modules.search.FindDialogMemory;
import org.netbeans.modules.search.PatternSandbox;
import org.netbeans.modules.search.ui.UiUtils;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class IgnoreListPanel
extends JPanel {
    private IgnoredListModel ignoreListModel = new IgnoredListModel();
    private JFileChooser jFileChooser;
    private JButton btnBrowse;
    private JButton btnClose;
    private JButton btnDelete;
    private JButton btnEdit;
    private JButton btnPattern;
    private JScrollPane jScrollPane1;
    private JTable table;

    public IgnoreListPanel() {
        this.initComponents();
        this.setMnemonics();
        this.updateEnabledButtons();
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                IgnoreListPanel.this.updateEnabledButtons();
            }
        });
    }

    private void updateEnabledButtons() {
        int n = this.table.getSelectedRows().length;
        this.btnDelete.setEnabled(n > 0);
        boolean bl = false;
        int n2 = this.table.getSelectedRow();
        if (n == 1 && n2 >= 0) {
            IgnoreListItem ignoreListItem = this.ignoreListModel.list.get(n2);
            bl = ignoreListItem.type == ItemType.PATTERN || ignoreListItem.type == ItemType.REGEXP;
        }
        this.btnEdit.setEnabled(bl);
    }

    private void initComponents() {
        this.btnBrowse = new JButton();
        this.btnPattern = new JButton();
        this.btnDelete = new JButton();
        this.btnClose = new JButton();
        this.btnEdit = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.btnBrowse.setText("Add Folder...");
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IgnoreListPanel.this.btnBrowseActionPerformed(actionEvent);
            }
        });
        this.btnPattern.setText("Add Path Pattern....");
        this.btnPattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IgnoreListPanel.this.btnPatternActionPerformed(actionEvent);
            }
        });
        this.btnDelete.setText("Delete");
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IgnoreListPanel.this.btnDeleteActionPerformed(actionEvent);
            }
        });
        this.btnClose.setText("Close");
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IgnoreListPanel.this.btnCloseActionPerformed(actionEvent);
            }
        });
        this.btnEdit.setText("Edit");
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IgnoreListPanel.this.btnEditActionPerformed(actionEvent);
            }
        });
        this.table.setModel(this.ignoreListModel);
        this.jScrollPane1.setViewportView(this.table);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 331, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnDelete, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.btnEdit, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.btnPattern, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.btnBrowse, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.btnClose, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.btnBrowse, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnPattern).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnEdit).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 53, Short.MAX_VALUE).addComponent(this.btnClose)).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE)).addContainerGap()));
    }

    private void btnDeleteActionPerformed(ActionEvent actionEvent) {
        for (int n : this.table.getSelectedRows()) {
            IgnoreListItem ignoreListItem = this.ignoreListModel.list.get(n);
            this.ignoreListModel.remove(ignoreListItem);
        }
    }

    private void btnCloseActionPerformed(ActionEvent actionEvent) {
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
        if (window != null) {
            window.dispose();
        }
    }

    private void btnBrowseActionPerformed(ActionEvent actionEvent) {
        File[] fileArray;
        int n;
        if (this.jFileChooser == null) {
            this.jFileChooser = new JFileChooser();
            this.jFileChooser.setFileSelectionMode(2);
            this.jFileChooser.setMultiSelectionEnabled(true);
        }
        if ((n = this.jFileChooser.showOpenDialog(this.table)) == 0 && (fileArray = this.jFileChooser.getSelectedFiles()) != null) {
            for (File file : fileArray) {
                this.ignoreListModel.addFile(file);
            }
        }
    }

    private void btnPatternActionPerformed(ActionEvent actionEvent) {
        PatternSandbox.openDialog(new PatternSandbox.PathPatternComposer("", false){

            @Override
            protected void onApply(String string, boolean bl) {
                IgnoreListPanel.this.ignoreListModel.addPattern(string, bl);
            }
        }, this.btnPattern);
    }

    private void btnEditActionPerformed(ActionEvent actionEvent) {
        final IgnoreListItem ignoreListItem = this.ignoreListModel.list.get(this.table.getSelectedRow());
        boolean bl = ignoreListItem.type == ItemType.REGEXP;
        PatternSandbox.openDialog(new PatternSandbox.PathPatternComposer(ignoreListItem.value, bl){

            @Override
            protected void onApply(String string, boolean bl) {
                IgnoreListPanel.this.ignoreListModel.remove(ignoreListItem);
                IgnoreListPanel.this.ignoreListModel.addPattern(string, bl);
            }
        }, this.btnEdit);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        IgnoreListPanel ignoreListPanel = new IgnoreListPanel();
        jFrame.add(ignoreListPanel);
        jFrame.setDefaultCloseOperation(2);
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    private void setMnemonics() {
        IgnoreListPanel.setMnem(this.btnBrowse, "IgnoreListPanel.btnBrowse.text");
        IgnoreListPanel.setMnem(this.btnDelete, "IgnoreListPanel.btnDelete.text");
        IgnoreListPanel.setMnem(this.btnEdit, "IgnoreListPanel.btnEdit.text");
        IgnoreListPanel.setMnem(this.btnClose, "IgnoreListPanel.btnClose.text");
        IgnoreListPanel.setMnem(this.btnPattern, "IgnoreListPanel.btnPattern.text");
    }

    private static void setMnem(AbstractButton abstractButton, String string) {
        Mnemonics.setLocalizedText((AbstractButton)abstractButton, (String)IgnoreListPanel.getText(string));
    }

    private static String getText(String string) {
        return NbBundle.getMessage(IgnoreListPanel.class, (String)string);
    }

    public static void openDialog(JComponent jComponent) {
        JDialog jDialog = new JDialog((JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, jComponent));
        IgnoreListPanel ignoreListPanel = new IgnoreListPanel();
        jDialog.add(ignoreListPanel);
        jDialog.setModal(true);
        jDialog.setLocationRelativeTo(jComponent);
        jDialog.getRootPane().setDefaultButton(ignoreListPanel.btnClose);
        jDialog.pack();
        jDialog.setTitle(IgnoreListPanel.getText("IgnoreListPanel.title"));
        jDialog.setVisible(true);
    }

    static class IgnoreListManager {
        List<IgnoredItemDefinition> items = new LinkedList<IgnoredItemDefinition>();

        public IgnoreListManager(List<String> list) {
            for (String string : list) {
                IgnoreListItem ignoreListItem = IgnoreListItem.fromString(string);
                switch (ignoreListItem.type) {
                    case PATTERN: {
                        this.items.add(new IgnoredPatternDefinition(ignoreListItem.value));
                        break;
                    }
                    case REGEXP: {
                        this.items.add(new IgnoredRegexpDefinition(ignoreListItem.value));
                        break;
                    }
                    case FILE: 
                    case FOLDER: {
                        this.items.add(new IgnoredDirDefinition(ignoreListItem.value));
                    }
                }
            }
        }

        boolean isIgnored(FileObject fileObject) {
            for (IgnoredItemDefinition ignoredItemDefinition : this.items) {
                if (!ignoredItemDefinition.isIgnored(fileObject)) continue;
                return true;
            }
            return false;
        }

        private class IgnoredDirDefinition
        extends IgnoredItemDefinition {
            FileObject dir;

            public IgnoredDirDefinition(String string) {
                this.dir = FileUtil.toFileObject((File)new File(string));
            }

            @Override
            boolean isIgnored(FileObject fileObject) {
                return FileUtil.isParentOf((FileObject)this.dir, (FileObject)fileObject) || fileObject.equals(this.dir);
            }
        }

        private class IgnoredRegexpDefinition
        extends IgnoredItemDefinition {
            private Pattern p;

            public IgnoredRegexpDefinition(String string) {
                this.p = Pattern.compile(string);
            }

            @Override
            boolean isIgnored(FileObject fileObject) {
                return this.p.matcher(fileObject.getPath()).find();
            }
        }

        private class IgnoredPatternDefinition
        extends IgnoredItemDefinition {
            private Pattern p;

            public IgnoredPatternDefinition(String string) {
                this.p = RegexpUtil.makeFileNamePattern(SearchScopeOptions.create(string, false));
            }

            @Override
            boolean isIgnored(FileObject fileObject) {
                return this.p.matcher(fileObject.getNameExt()).matches();
            }
        }

        private abstract class IgnoredItemDefinition {
            private IgnoredItemDefinition() {
            }

            abstract boolean isIgnored(FileObject var1);
        }
    }

    class IgnoredListModel
    extends AbstractTableModel {
        List<IgnoreListItem> list;

        public void remove(Object object) {
            int n = this.list.indexOf(object);
            this.list.remove(n);
            this.fireTableRowsDeleted(n, n);
            this.persist();
        }

        public void addFile(File file) {
            this.list.add(IgnoreListItem.forFile(file));
            this.fireTableRowsInserted(this.list.size() - 1, this.list.size());
            this.persist();
        }

        public void addPattern(String string, boolean bl) {
            if (bl) {
                this.addRegularExpression(string);
            } else {
                this.addSimplePatter(string);
            }
        }

        public void addSimplePatter(String string) {
            this.list.add(IgnoreListItem.forPattern(string));
            this.fireTableRowsInserted(this.list.size() - 1, this.list.size());
            this.persist();
        }

        public void addRegularExpression(String string) {
            this.list.add(IgnoreListItem.forRegexp(string));
            this.fireTableRowsInserted(this.list.size() - 1, this.list.size());
            this.persist();
        }

        public IgnoredListModel() {
            List<String> list = FindDialogMemory.getDefault().getIgnoreList();
            this.list = new ArrayList<IgnoreListItem>(list.size());
            for (String string : list) {
                IgnoreListItem ignoreListItem = IgnoreListItem.fromString(string);
                if (ignoreListItem.type == ItemType.INVALID) continue;
                this.list.add(ignoreListItem);
            }
        }

        public void persist() {
            ArrayList<String> arrayList = new ArrayList<String>(this.list.size());
            for (IgnoreListItem ignoreListItem : this.list) {
                arrayList.add(ignoreListItem.toString());
            }
            FindDialogMemory.getDefault().setIgnoreList(arrayList);
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            IgnoreListItem ignoreListItem = this.list.get(n);
            if (n2 == 0) {
                String string;
                switch (ignoreListItem.type) {
                    case FILE: {
                        string = "IgnoreListPanel.type.file";
                        break;
                    }
                    case FOLDER: {
                        string = "IgnoreListPanel.type.folder";
                        break;
                    }
                    case PATTERN: {
                        string = "IgnoreListPanel.type.pattern";
                        break;
                    }
                    case REGEXP: {
                        string = "IgnoreListPanel.type.regexp";
                        break;
                    }
                    default: {
                        string = "IgnoreListPanel.type.invalid";
                    }
                }
                return UiUtils.getText(string);
            }
            return ignoreListItem.value;
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return UiUtils.getText("IgnoreListPanel.item.type");
            }
            return UiUtils.getText("IgnoreListPanel.item.value");
        }
    }

    static class IgnoreListItem {
        private ItemType type;
        private String value;

        private IgnoreListItem(String string) {
            if (ItemType.PATTERN.isTypeOf(string)) {
                this.type = ItemType.PATTERN;
                this.value = string.substring(3);
            } else if (ItemType.REGEXP.isTypeOf(string)) {
                this.type = ItemType.REGEXP;
                this.value = string.substring(3);
            } else if (ItemType.FILE.isTypeOf(string)) {
                String string2 = string.substring(3);
                File file = new File(string2);
                if (!file.exists()) {
                    this.type = ItemType.INVALID;
                    return;
                }
                this.type = file.isDirectory() ? ItemType.FOLDER : ItemType.FILE;
                this.value = string2;
            } else {
                this.type = ItemType.INVALID;
                return;
            }
        }

        private IgnoreListItem(ItemType itemType, String string) {
            this.type = itemType;
            this.value = string;
        }

        public String toString() {
            return this.type.getTypePrefix() + this.value;
        }

        static IgnoreListItem fromString(String string) {
            return new IgnoreListItem(string);
        }

        static IgnoreListItem forFile(File file) {
            ItemType itemType = !file.exists() ? ItemType.INVALID : (file.isDirectory() ? ItemType.FOLDER : ItemType.FILE);
            return new IgnoreListItem(itemType, file.getAbsolutePath());
        }

        static IgnoreListItem forRegexp(String string) {
            return new IgnoreListItem(ItemType.REGEXP, string);
        }

        static IgnoreListItem forPattern(String string) {
            return new IgnoreListItem(ItemType.PATTERN, string);
        }
    }

    static enum ItemType {
        FILE("f: "),
        FOLDER("f: "),
        REGEXP("x: "),
        PATTERN("s: "),
        INVALID("i: ");

        private String typePrefix;

        private ItemType(String string2) {
            this.typePrefix = string2;
        }

        public String getTypePrefix() {
            return this.typePrefix;
        }

        public boolean isTypeOf(String string) {
            return string.startsWith(this.typePrefix);
        }
    }
}

