/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.netbeans.modules.search.CopyTextAction;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.NodeRenderer;
import org.netbeans.modules.search.NodeSelector;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultTreeModel;
import org.openide.actions.EditAction;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.util.lookup.Lookups;

final class NodeListener
implements MouseListener,
KeyListener,
TreeWillExpandListener,
TreeExpansionListener {
    private static final boolean COLLAPSE_FILE_ON_SELECTION = false;
    private static final boolean COLLAPSE_FILE_ON_UNSELECTION = true;
    private boolean selectionChangeEnabled = true;
    private int treeHeightWhenLastPressed = 0;

    NodeListener() {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        JTree jTree = (JTree)mouseEvent.getSource();
        if (jTree.getHeight() != this.treeHeightWhenLastPressed) {
            return;
        }
        int n = mouseEvent.getClickCount();
        if (n != 1 && n != 2) {
            return;
        }
        TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        ResultModel resultModel = this.getResultModel(jTree);
        boolean bl = this.isInsideCheckBox(jTree, treePath, resultModel, mouseEvent);
        int n2 = mouseEvent.getModifiersEx();
        if (n2 == 0 || n2 == 16 || n2 == 1024) {
            if (n == 1 && bl) {
                assert (treePath != null);
                this.toggleSelection(jTree, treePath);
            }
            if (n == 2 && !bl) {
                if (treePath.getPathCount() == 1) {
                    this.toggleExpansionState(jTree, treePath);
                } else {
                    Node node = NodeListener.getNbNode(treePath, resultModel);
                    this.callDefaultAction(node, mouseEvent.getSource(), mouseEvent.getID(), "double-click");
                }
            }
        }
    }

    private static boolean checkPathCounts(TreePath[] treePathArray, int n) {
        for (TreePath treePath : treePathArray) {
            if (treePath.getPathCount() == n) continue;
            return false;
        }
        return true;
    }

    private void popupTriggerEventFired(MouseEvent mouseEvent) {
        int n;
        JTree jTree = (JTree)mouseEvent.getSource();
        TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        if (!NodeListener.isPathSelected(treePath, jTree)) {
            jTree.setSelectionPath(treePath);
        }
        if ((n = jTree.getSelectionCount()) >= 1) {
            ResultModel resultModel = this.getResultModel(jTree);
            if (n > 1) {
                this.showPopup(jTree, null, resultModel, mouseEvent);
            } else if (!this.isInsideCheckBox(jTree, treePath, resultModel, mouseEvent)) {
                this.showPopup(jTree, treePath, resultModel, mouseEvent);
            }
        }
    }

    private static boolean isPathSelected(TreePath treePath, JTree jTree) {
        int n = jTree.getSelectionCount();
        if (n == 0) {
            return false;
        }
        if (n == 1) {
            return jTree.getSelectionPath().equals(treePath);
        }
        for (TreePath treePath2 : jTree.getSelectionPaths()) {
            if (!treePath2.equals(treePath)) continue;
            return true;
        }
        return false;
    }

    private boolean isInsideCheckBox(JTree jTree, TreePath treePath, ResultModel resultModel, MouseEvent mouseEvent) {
        if (resultModel == null || !resultModel.searchAndReplace) {
            return false;
        }
        Rectangle rectangle = jTree.getPathBounds(treePath);
        Rectangle rectangle2 = NodeRenderer.getCheckBoxRectangle();
        rectangle2.setLocation(rectangle.x + rectangle2.x, rectangle.y + rectangle2.y);
        return rectangle2.contains(mouseEvent.getPoint());
    }

    private void showPopup(JTree jTree, TreePath treePath, ResultModel resultModel, MouseEvent mouseEvent) {
        int n;
        TreePath[] treePathArray;
        if (treePath != null) {
            treePathArray = null;
            n = treePath.getPathCount();
        } else {
            treePathArray = jTree.getSelectionPaths();
            assert (treePathArray.length > 1);
            if (NodeListener.checkPathCounts(treePathArray, 2)) {
                n = 2;
            } else {
                return;
            }
        }
        if (n != 1) {
            if (n == 2) {
                Serializable serializable;
                JPopupMenu jPopupMenu = null;
                if (jTree.getSelectionCount() > 1) {
                    serializable = new StringBuilder(30);
                    HashSet<String> hashSet = new HashSet<String>();
                    final ArrayList<Node> arrayList = new ArrayList<Node>(treePathArray.length);
                    for (TreePath treePath2 : treePathArray) {
                        String string;
                        Node node = NodeListener.getNbNode(treePath2, resultModel);
                        if (node == null) continue;
                        arrayList.add(node);
                        Action action = this.getDefaultAction(node);
                        if (action == null || (string = NodeListener.getMenuItemLabel(action)).length() == 0 || !hashSet.add(string)) continue;
                        ((StringBuilder)serializable).append('/').append(string);
                    }
                    if (hashSet.isEmpty()) {
                        return;
                    }
                    JMenuItem jMenuItem = new JMenuItem(((StringBuilder)serializable).toString().substring(1));
                    jMenuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            NodeListener.this.callResultNodesDefaultActions(arrayList, actionEvent);
                        }
                    });
                    jPopupMenu = new JPopupMenu();
                    jPopupMenu.add(jMenuItem);
                } else {
                    jPopupMenu = this.createFileNodePopupMenu(treePath, resultModel);
                }
                if (jPopupMenu != null) {
                    serializable = NodeListener.getPopupMenuLocation(jTree, treePath, mouseEvent);
                    jPopupMenu.show(jTree, ((Point)serializable).x, ((Point)serializable).y);
                }
            } else if (n == 3) {
                Node node;
                if (jTree.getSelectionCount() == 1 && (node = NodeListener.getNbNode(treePath, resultModel)) != null) {
                    Point point = NodeListener.getPopupMenuLocation(jTree, treePath, mouseEvent);
                    node.getContextMenu().show(jTree, point.x, point.y);
                }
            } else assert (false);
        }
    }

    private void callResultNodesDefaultActions(Collection<Node> collection, ActionEvent actionEvent) {
        assert (collection != null && !collection.isEmpty());
        Object object = actionEvent.getSource();
        int n = actionEvent.getID();
        for (Node node : collection) {
            this.callDefaultAction(node, object, n, "click");
        }
    }

    private static Point getPopupMenuLocation(JTree jTree, TreePath treePath, MouseEvent mouseEvent) {
        Serializable serializable;
        if (mouseEvent != null) {
            return new Point(mouseEvent.getX(), mouseEvent.getY());
        }
        Point point = null;
        if (treePath != null) {
            point = jTree.getPathBounds(treePath).getLocation();
        } else if (jTree.getLeadSelectionPath() != null && jTree.isPathSelected((TreePath)(serializable = jTree.getLeadSelectionPath()))) {
            point = jTree.getPathBounds((TreePath)serializable).getLocation();
        }
        serializable = jTree.getVisibleRect();
        if (point == null || !((Rectangle)serializable).contains(point)) {
            Point point2 = NodeListener.getHighestVisibleSelectedNodeLocation(jTree);
            if (point2 != null) {
                return point2;
            }
            return new Point(((Rectangle)serializable).x, ((Rectangle)serializable).y);
        }
        return point;
    }

    private static Point getHighestVisibleSelectedNodeLocation(JTree jTree) {
        TreePath[] treePathArray;
        Rectangle rectangle = jTree.getVisibleRect();
        Point point = null;
        for (TreePath treePath : treePathArray = jTree.getSelectionPaths()) {
            Point point2 = jTree.getPathBounds(treePath).getLocation();
            if (point != null && !(point2.getY() < point.getY()) || !rectangle.contains(point2)) continue;
            point = point2;
        }
        return point;
    }

    private boolean autocollapseFileNodeIfNeeded(JTree jTree, TreePath treePath, MatchingObject matchingObject, boolean bl) {
        boolean bl2;
        boolean bl3;
        assert (treePath.getPathCount() == 2 && treePath.getLastPathComponent() == matchingObject);
        boolean bl4 = bl3 = !bl;
        if (bl3) {
            if (matchingObject.isExpanded()) {
                jTree.collapsePath(treePath);
            }
            bl2 = true;
        } else {
            bl2 = !jTree.isExpanded(treePath);
        }
        return bl2;
    }

    private void toggleRootNodeSelection(JTree jTree, TreePath treePath) {
        boolean bl;
        ResultTreeModel resultTreeModel = this.getResultTreeModel(treePath);
        ResultModel resultModel = resultTreeModel.resultModel;
        boolean bl2 = resultTreeModel.isSelected();
        boolean bl3 = !bl2;
        boolean bl4 = bl = !bl3;
        if (resultModel == null) {
            return;
        }
        List<MatchingObject> list = resultModel.getMatchingObjects();
        Object object = null;
        MatchingObject[] matchingObjectArray = null;
        ArrayList<MatchingObject> arrayList = null;
        int n = 0;
        int n2 = 0;
        for (MatchingObject matchingObjectArray2 : list) {
            boolean bl5;
            boolean bl6 = bl5 = !matchingObjectArray2.isExpanded();
            if (bl && !bl5) {
                jTree.collapsePath(treePath.pathByAddingChild(matchingObjectArray2));
                bl5 = true;
            }
            if (matchingObjectArray2.isSelected() == bl3) continue;
            matchingObjectArray2.setSelected(bl3);
            if (n == 0) {
                int n3 = list.size() - n2;
                object = new int[n3];
                matchingObjectArray = new MatchingObject[n3];
            }
            object[n] = (Iterator)n2;
            matchingObjectArray[n] = matchingObjectArray2;
            ++n;
            if (bl5) {
                matchingObjectArray2.markChildrenSelectionDirty();
            } else {
                if (arrayList == null) {
                    arrayList = new ArrayList<MatchingObject>(6);
                }
                arrayList.add(matchingObjectArray2);
            }
            ++n2;
        }
        if (n != 0 && n != list.size()) {
            Iterator iterator = (Iterator)new int[n];
            System.arraycopy(object, 0, iterator, 0, n);
            object = iterator;
            MatchingObject[] matchingObjectArray2 = new MatchingObject[n];
            System.arraycopy(matchingObjectArray, 0, matchingObjectArray2, 0, n);
            matchingObjectArray = matchingObjectArray2;
        }
        resultTreeModel.setRootNodeSelected(bl3);
        if (n != 0) {
            assert ((object).length == n);
            assert (matchingObjectArray.length == n);
            resultTreeModel.fireFileNodesSelectionChanged((int[])object, matchingObjectArray);
        }
        if (arrayList != null) {
            for (MatchingObject matchingObject : arrayList) {
                resultTreeModel.fireFileNodeChildrenSelectionChanged(matchingObject);
            }
        }
    }

    private void setFileNodeSelected(JTree jTree, TreePath treePath, MatchingObject matchingObject, boolean bl) {
        assert (treePath.getPathCount() == 2);
        this.autocollapseFileNodeIfNeeded(jTree, treePath, matchingObject, bl);
        matchingObject.setSelected(bl);
        this.getResultTreeModel(treePath).fileNodeSelectionChanged(matchingObject, true);
    }

    private void toggleDetailNodeSelection(JTree jTree, ResultModel resultModel, MatchingObject matchingObject, int n) {
        boolean bl = matchingObject.toggleSubnodeSelection(resultModel, n);
        ResultTreeModel resultTreeModel = this.getResultTreeModel(jTree);
        resultTreeModel.fireDetailNodeSelectionChanged(matchingObject, n);
        if (bl) {
            resultTreeModel.fileNodeSelectionChanged(matchingObject, false);
        }
    }

    private ResultTreeModel getResultTreeModel(TreePath treePath) {
        return (ResultTreeModel)treePath.getPathComponent(0);
    }

    private ResultTreeModel getResultTreeModel(JTree jTree) {
        return (ResultTreeModel)jTree.getPathForRow(0).getPathComponent(0);
    }

    private ResultModel getResultModel(JTree jTree) {
        return ((ResultTreeModel)jTree.getPathForRow((int)0).getPathComponent((int)0)).resultModel;
    }

    private static Node getNbNode(TreePath treePath, ResultModel resultModel) {
        Node node;
        boolean bl;
        MatchingObject matchingObject;
        Object object = treePath.getLastPathComponent();
        if (object.getClass() == MatchingObject.class) {
            matchingObject = (MatchingObject)object;
            bl = true;
        } else {
            Object object2 = treePath.getParentPath().getLastPathComponent();
            assert (object2.getClass() == MatchingObject.class);
            matchingObject = (MatchingObject)object2;
            bl = false;
        }
        if (!matchingObject.isObjectValid()) {
            return null;
        }
        if (bl) {
            node = resultModel == null ? null : (matchingObject.getDataObject() != null ? matchingObject.getDataObject().getNodeDelegate() : null);
        } else {
            assert (object instanceof Node);
            node = (Node)object;
        }
        return node;
    }

    private static MatchingObject getMatchingObject(TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        return object instanceof MatchingObject ? (MatchingObject)object : null;
    }

    private JPopupMenu createFileNodePopupMenu(TreePath treePath, ResultModel resultModel) {
        Node node = NodeListener.getNbNode(treePath, resultModel);
        if (node == null) {
            return null;
        }
        Action action = this.getDefaultAction(node);
        if (action == null) {
            return null;
        }
        assert (action.isEnabled());
        JMenuItem jMenuItem = NodeListener.getJMenuItem(action);
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (jMenuItem != null) {
            jPopupMenu.add(jMenuItem);
        } else {
            jPopupMenu.add(action);
        }
        CopyTextAction copyTextAction = this.newCopyTextAction(treePath);
        if (copyTextAction != null) {
            jPopupMenu.add(copyTextAction);
        }
        return jPopupMenu;
    }

    private CopyTextAction newCopyTextAction(TreePath treePath) {
        try {
            MatchingObject matchingObject = NodeListener.getMatchingObject(treePath);
            FileObject fileObject = matchingObject.getFileObject();
            File file = FileUtil.toFile((FileObject)fileObject);
            String string = file != null ? file.getCanonicalPath() : fileObject.getPath();
            String string2 = NbBundle.getBundle(this.getClass()).getString("LBL_CopyFilePathAction");
            CopyTextAction copyTextAction = new CopyTextAction(string2);
            copyTextAction.setTextCopy(string);
            return copyTextAction;
        }
        catch (IOException iOException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    private static String getMenuItemLabel(Action action) {
        JMenuItem jMenuItem = NodeListener.getJMenuItem(action);
        return jMenuItem != null ? jMenuItem.getText() : (String)action.getValue("Name");
    }

    private static JMenuItem getJMenuItem(Action action) {
        return action instanceof Presenter.Popup ? ((Presenter.Popup)action).getPopupPresenter() : null;
    }

    private Action getDefaultAction(Node node) {
        Action action;
        EditAction editAction = (EditAction)SharedClassObject.findObject(EditAction.class, (boolean)true);
        if (editAction != null && (action = editAction.createContextAwareInstance(Lookups.singleton((Object)node))).isEnabled()) {
            return action;
        }
        Action action2 = node.getPreferredAction();
        if (action2 == null) {
            return null;
        }
        action = action2;
        if (action instanceof NodeAction) {
            action = ((NodeAction)action).createContextAwareInstance(Lookups.singleton((Object)node));
        }
        return action != null && action.isEnabled() ? action : null;
    }

    private void callDefaultAction(Node node, Object object, int n, String string) {
        if (node == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        EditCookie editCookie = (EditCookie)node.getCookie(EditCookie.class);
        if (editCookie != null) {
            editCookie.edit();
            return;
        }
        Action action = node.getPreferredAction();
        if (action == null) {
            return;
        }
        if (action instanceof NodeAction) {
            action = ((NodeAction)action).createContextAwareInstance(Lookups.singleton((Object)node));
        }
        if (action != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent(object, n, string));
        }
    }

    private void toggleExpansionState(JTree jTree, TreePath treePath) {
        if (jTree.isCollapsed(treePath)) {
            jTree.expandPath(treePath);
        } else {
            jTree.collapsePath(treePath);
        }
    }

    private void toggleSelection(JTree jTree, TreePath treePath) {
        assert (EventQueue.isDispatchThread());
        if (!this.selectionChangeEnabled) {
            return;
        }
        int n = treePath.getPathCount();
        if (n == 1) {
            this.toggleRootNodeSelection(jTree, treePath);
        } else if (n == 2) {
            MatchingObject matchingObject;
            this.setFileNodeSelected(jTree, treePath, matchingObject, !(matchingObject = (MatchingObject)treePath.getPathComponent(1)).isSelected());
        } else {
            assert (n == 3);
            MatchingObject matchingObject = (MatchingObject)treePath.getPathComponent(1);
            int n2 = jTree.getRowForPath(treePath.getParentPath());
            int n3 = jTree.getRowForPath(treePath);
            int n4 = n3 - n2 - 1;
            this.toggleDetailNodeSelection(jTree, this.getResultModel(jTree), matchingObject, n4);
        }
    }

    void setSelectionChangeEnabled(boolean bl) {
        assert (EventQueue.isDispatchThread());
        this.selectionChangeEnabled = bl;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof JTree) {
            this.treeHeightWhenLastPressed = ((JTree)mouseEvent.getSource()).getHeight();
        }
        if (mouseEvent.isPopupTrigger()) {
            this.popupTriggerEventFired(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popupTriggerEventFired(mouseEvent);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        JTree jTree = (JTree)keyEvent.getSource();
        ResultModel resultModel = this.getResultModel(jTree);
        if (keyEvent.getKeyChar() == ' ') {
            TreePath treePath = jTree.getSelectionPath();
            if (treePath != null) {
                if (resultModel.searchAndReplace) {
                    this.toggleSelection(jTree, treePath);
                } else if (jTree.isCollapsed(treePath)) {
                    jTree.expandPath(treePath);
                } else {
                    jTree.collapsePath(treePath);
                }
            }
        } else if (keyEvent.getKeyCode() == 10 && keyEvent.getModifiersEx() == 0) {
            List<Object> list;
            Object object;
            TreeSelectionModel treeSelectionModel = jTree.getSelectionModel();
            if (treeSelectionModel.getSelectionCount() == 0) {
                return;
            }
            if (treeSelectionModel.getSelectionCount() == 1) {
                object = treeSelectionModel.getLeadSelectionPath();
                if (object == null || ((TreePath)object).getParentPath() == null) {
                    return;
                }
                list = Collections.singletonList(object);
            } else {
                object = treeSelectionModel.getSelectionPaths();
                if (object == null || ((TreePath[])object).length < 2) {
                    assert (false);
                    return;
                }
                list = NodeSelector.selectMainNodes((TreePath[])object, resultModel.canHaveDetails());
            }
            for (TreePath treePath : list) {
                Node node = NodeListener.getNbNode(treePath, resultModel);
                this.callDefaultAction(node, keyEvent.getSource(), keyEvent.getID(), "enter");
            }
        } else if (keyEvent.getKeyCode() == 525 && keyEvent.getModifiersEx() == 0 || keyEvent.getKeyCode() == 121 && keyEvent.isShiftDown()) {
            keyEvent.consume();
            int n = jTree.getSelectionCount();
            if (n >= 1) {
                if (n > 1) {
                    this.showPopup(jTree, null, resultModel, null);
                } else {
                    TreePath treePath = jTree.getSelectionPath();
                    this.showPopup(jTree, treePath, resultModel, null);
                }
            }
        }
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        MatchingObject matchingObject;
        TreePath treePath = treeExpansionEvent.getPath();
        if (treePath.getPathCount() == 2 && (matchingObject = (MatchingObject)treePath.getLastPathComponent()).isChildrenSelectionDirty()) {
            this.getResultTreeModel(treePath).fireFileNodeChildrenSelectionChanged(matchingObject);
            matchingObject.markChildrenSelectionClean();
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        if (treePath.getPathCount() == 2) {
            ((MatchingObject)treePath.getLastPathComponent()).markExpanded(true);
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        if (treePath.getPathCount() == 2) {
            ((MatchingObject)treePath.getLastPathComponent()).markExpanded(false);
        }
    }
}

