/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.tree.TreePath;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.TextDetail;

final class NodeSelector {
    private final TreePath[] nodes;
    private final Map<TreePathWrapper, Boolean> map;
    private boolean detailNodeAdded = false;
    private TreePath lsfn = null;
    private TreePath ldn = null;
    private TreePath ldfn = null;
    private final Logger log = Logger.getLogger(this.getClass().getName());

    static List<TreePath> selectMainNodes(TreePath[] treePathArray, boolean bl) {
        Logger logger = Logger.getLogger(NodeSelector.class.getName());
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("selectMainNodes(canHaveDetails = " + bl + ')');
        }
        if (!bl) {
            return NodeSelector.simpleSelect(treePathArray);
        }
        return new NodeSelector(treePathArray).selectMainNodes();
    }

    private static List<TreePath> simpleSelect(TreePath[] treePathArray) {
        int n;
        TreePath treePath = NodeSelector.findRootNode(treePathArray[0]);
        int n2 = -1;
        for (int i = 0; i < treePathArray.length; ++i) {
            if (treePathArray[i] != treePath) continue;
            n2 = i;
            break;
        }
        if (n2 == -1) {
            return Arrays.asList(treePathArray);
        }
        if (n2 == 0) {
            return Arrays.asList(treePathArray).subList(1, treePathArray.length);
        }
        if (n2 == treePathArray.length - 1) {
            return Arrays.asList(treePathArray).subList(0, treePathArray.length - 1);
        }
        ArrayList<TreePath> arrayList = new ArrayList<TreePath>(treePathArray.length - 1);
        for (n = 0; n < n2; ++n) {
            arrayList.add(treePathArray[n]);
        }
        for (n = n2 + 1; n < treePathArray.length; ++n) {
            arrayList.add(treePathArray[n]);
        }
        assert (arrayList.size() == treePathArray.length - 1);
        return arrayList;
    }

    private NodeSelector(TreePath[] treePathArray) {
        this.nodes = treePathArray;
        this.map = new LinkedHashMap<TreePathWrapper, Boolean>((int)((double)treePathArray.length * 1.35 + 0.5), 0.75f);
    }

    private List<TreePath> selectMainNodes() {
        TreePath treePath;
        boolean bl = this.log.isLoggable(Level.FINEST);
        TreePath treePath2 = NodeSelector.findRootNode(this.nodes[0]);
        if (bl) {
            this.log.finest("Selected nodes:");
            for (TreePath object : this.nodes) {
                if (object == treePath2) {
                    this.log.finest("* <root>");
                    continue;
                }
                treePath = object.getParentPath();
                assert (treePath != null);
                if (treePath == treePath2) {
                    this.log.finest("* " + NodeSelector.getFileNodeName(object));
                    continue;
                }
                this.log.finest("* " + NodeSelector.getDetailNodeName(object, -1));
            }
            this.log.finest("");
        }
        for (TreePath treePath3 : this.nodes) {
            if (treePath3 == treePath2) {
                this.log.finest("*** <root> - filtered out");
                continue;
            }
            assert (this.ldfn == null == (this.ldn == null));
            assert (this.ldfn == null || this.ldfn == this.ldn.getParentPath());
            assert (treePath3 != this.ldfn || treePath3 != this.lsfn);
            treePath = treePath3.getParentPath();
            assert (treePath != null);
            if (bl) {
                this.log.finest("*** " + (treePath == treePath2 ? NodeSelector.getFileNodeName(treePath3) : NodeSelector.getDetailNodeName(treePath3, -1)));
            }
            if (treePath == treePath2) {
                if (treePath3 == this.lsfn) {
                    if (!bl) continue;
                    this.log.finest(NodeSelector.getFileNodeName(treePath3) + " has been already selected");
                    continue;
                }
                if (this.ldfn != null && treePath3 != this.ldfn) {
                    if (bl) {
                        this.log.finest("handlePendingDetailNode(...)");
                    }
                    this.handlePendingDetailNode();
                }
                if (bl) {
                    this.log.finest("map.put(" + NodeSelector.getFileNodeName(treePath3) + ", TRUE)");
                    this.log.finest("LSFN = " + NodeSelector.getFileNodeName(treePath3));
                    this.log.finest("LDFN = null");
                    this.log.finest("LDN = null");
                }
                this.map.put(new TreePathWrapper(treePath3), Boolean.TRUE);
                this.lsfn = treePath3;
                this.ldfn = null;
                this.ldn = null;
                continue;
            }
            if (treePath == this.lsfn) {
                if (!bl) continue;
                this.log.finest(NodeSelector.getDetailNodeName(treePath3) + " - its parent is already selected");
                continue;
            }
            if (treePath == this.ldfn) {
                this.map.put(new TreePathWrapper(this.ldfn), Boolean.TRUE);
                if (bl) {
                    this.log.finest(NodeSelector.getDetailNodeName(treePath3) + " - at least second selected node" + " under the same parent (" + NodeSelector.getFileNodeName(treePath) + ") - will be added permanently");
                    this.log.finest("map.put(" + NodeSelector.getFileNodeName(this.ldfn) + " /LDFN/, TRUE)");
                    this.log.finest("LSFN = " + NodeSelector.getFileNodeName(treePath) + " /parent/");
                    this.log.finest("LDFN = null");
                    this.log.finest("LDN = null");
                }
                this.lsfn = treePath;
                this.ldfn = null;
                this.ldn = null;
                continue;
            }
            if (bl && this.map.containsKey(new TreePathWrapper(treePath))) {
                this.log.finest(NodeSelector.getDetailNodeName(treePath3) + " - added under a file node (" + NodeSelector.getFileNodeName(treePath) + ") that is selected but is not" + " the most recently selected" + " file node");
            }
            if (this.ldfn != null) {
                if (bl) {
                    this.log.finest("handlePendingDetailNode(...)");
                }
                this.handlePendingDetailNode();
            }
            if (treePath == this.lsfn) {
                this.ldfn = null;
                this.ldn = null;
            } else {
                this.ldfn = treePath;
                this.ldn = treePath3;
            }
            if (!bl) continue;
            this.log.finest("LDFN = " + NodeSelector.getFileNodeName(treePath) + " /parent/");
            this.log.finest("LDN = " + NodeSelector.getDetailNodeName(treePath3) + " /current/");
        }
        if (this.ldfn != null) {
            if (bl) {
                this.log.finest("*** END");
                this.log.finest("handlePendingDetailNode(...)");
            }
            this.handlePendingDetailNode();
            this.ldfn = null;
            this.ldn = null;
        }
        this.log.finest("***");
        this.log.finest("*** BUILDING RESULT LIST");
        ArrayList arrayList = new ArrayList(this.map.size());
        if (!this.detailNodeAdded) {
            this.log.finest("No detail nodes - simple case");
            for (Map.Entry<TreePathWrapper, Boolean> entry : this.map.entrySet()) {
                arrayList.add(entry.getKey().treePath);
                if (!bl) continue;
                this.log.finest("+ " + NodeSelector.getFileNodeName(entry.getKey().treePath));
            }
        } else {
            for (Map.Entry<TreePathWrapper, Boolean> entry : this.map.entrySet()) {
                if (entry.getValue() == Boolean.FALSE) {
                    assert (!entry.getKey().isDetail);
                    if (!bl) continue;
                    this.log.finest("- " + NodeSelector.getFileNodeName(entry.getKey().treePath) + " (FALSE)");
                    continue;
                }
                TreePathWrapper treePathWrapper = entry.getKey();
                if (!treePathWrapper.isDetail) {
                    assert (entry.getValue() == Boolean.TRUE);
                    arrayList.add(treePathWrapper.treePath);
                    if (!bl) continue;
                    this.log.finest("+ " + NodeSelector.getFileNodeName(treePathWrapper.treePath));
                    continue;
                }
                if (this.map.get(new TreePathWrapper(treePathWrapper.treePath.getParentPath())) != Boolean.TRUE) {
                    arrayList.add(treePathWrapper.treePath);
                    if (!bl) continue;
                    this.log.finest("+ " + NodeSelector.getDetailNodeName(treePathWrapper.treePath, -1));
                    continue;
                }
                if (!bl) continue;
                this.log.finest("- " + NodeSelector.getDetailNodeName(treePathWrapper.treePath, -1) + " - parent (" + NodeSelector.getFileNodeName(treePathWrapper.treePath.getParentPath()) + ") selected");
            }
        }
        this.map.clear();
        assert (!arrayList.isEmpty());
        return arrayList;
    }

    private void handlePendingDetailNode() {
        assert (this.ldfn != null);
        assert (this.ldn != null);
        Boolean bl = this.map.put(new TreePathWrapper(this.ldfn), Boolean.TRUE);
        if (bl == null) {
            this.map.put(new TreePathWrapper(this.ldfn), Boolean.FALSE);
            this.map.put(new TreePathWrapper(this.ldn), Boolean.TRUE);
            this.detailNodeAdded = true;
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("map.put(" + NodeSelector.getFileNodeName(this.ldfn) + " /LDFN/, FALSE)");
                this.log.finest("map.put(" + NodeSelector.getDetailNodeName(this.ldn) + " /LDN/, TRUE)");
            }
        } else if (bl == Boolean.FALSE) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest(NodeSelector.getFileNodeName(this.ldfn) + " - membership status changed" + " (conditional -> permanent)");
            }
            this.lsfn = this.ldfn;
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("LSFN = " + NodeSelector.getFileNodeName(this.ldfn) + " /LDFN/");
            }
        } else assert (bl == Boolean.TRUE);
    }

    private static String getFileNodeName(TreePath treePath) {
        return ((MatchingObject)treePath.getLastPathComponent()).getName();
    }

    private static String getDetailNodeName(TreePath treePath) {
        return NodeSelector.getDetailNodeName(treePath, 15);
    }

    private static String getDetailNodeName(TreePath treePath, int n) {
        String string = ((TextDetail.DetailNode)((Object)treePath.getLastPathComponent())).getName().trim();
        if (n != -1) {
            return string.substring(0, n);
        }
        int n2 = string.indexOf(91);
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        return string.trim();
    }

    private static TreePath findRootNode(TreePath treePath) {
        TreePath treePath2;
        while ((treePath2 = treePath.getParentPath()) != null) {
            treePath = treePath2;
        }
        return treePath;
    }

    private static final class TreePathWrapper {
        private final TreePath treePath;
        private final Object lastPathComp;
        private final boolean isDetail;

        TreePathWrapper(TreePath treePath) {
            this.treePath = treePath;
            this.lastPathComp = treePath.getLastPathComponent();
            this.isDetail = this.lastPathComp.getClass() != MatchingObject.class;
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != TreePathWrapper.class) {
                return false;
            }
            TreePathWrapper treePathWrapper = (TreePathWrapper)object;
            return treePathWrapper.isDetail == this.isDetail && treePathWrapper.lastPathComp.equals(this.lastPathComp);
        }

        public int hashCode() {
            int n = this.lastPathComp.hashCode();
            if (this.isDetail) {
                n += 5;
            }
            return n;
        }
    }
}

