/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.ItemSelectable;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import org.netbeans.api.search.SearchHistory;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.FindDialogMemory;
import org.netbeans.modules.search.ui.FormLayoutHelper;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public abstract class PatternSandbox
extends JPanel
implements HierarchyListener {
    protected JComboBox cboxPattern;
    private JLabel lblPattern;
    protected JLabel lblHint;
    private JLabel lblOptions;
    private JPanel pnlOptions;
    protected JTextPane textPane;
    private JButton btnApply;
    private JButton btnCancel;
    private JScrollPane textScrollPane;
    protected Highlighter highlighter;
    protected Highlighter.HighlightPainter painter;
    protected BasicSearchCriteria searchCriteria;

    protected void initComponents() {
        this.cboxPattern = new JComboBox();
        this.cboxPattern.setEditable(true);
        this.lblPattern = new JLabel();
        this.lblPattern.setLabelFor(this.cboxPattern);
        this.lblHint = new JLabel();
        this.lblHint.setForeground(SystemColor.controlDkShadow);
        this.lblOptions = new JLabel();
        this.textPane = new JTextPane();
        this.textScrollPane = new JScrollPane();
        this.textScrollPane.setViewportView(this.textPane);
        this.textScrollPane.setPreferredSize(new Dimension(350, 100));
        this.textScrollPane.setBorder(new BevelBorder(1));
        this.searchCriteria = new BasicSearchCriteria();
        this.initSpecificComponents();
        this.pnlOptions = this.createOptionsPanel();
        this.btnApply = new JButton();
        this.btnCancel = new JButton();
        this.initTextPaneContent();
        this.initHighlighter();
        this.setMnemonics();
        this.layoutComponents();
        this.initInteraction();
        this.addHierarchyListener(this);
        this.highlightMatchesLater();
    }

    private void initButtonsInteraction() {
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternSandbox.this.closeDialog();
            }
        });
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternSandbox.this.apply();
                PatternSandbox.this.closeDialog();
            }
        });
    }

    private void initTextInputInteraction() {
        this.cboxPattern.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                PatternSandbox.this.highlightMatchesLater();
            }
        });
        this.cboxPattern.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternSandbox.this.highlightMatchesLater();
            }
        });
        this.textPane.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                PatternSandbox.this.highlightMatchesLater();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                PatternSandbox.this.highlightMatchesLater();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                PatternSandbox.this.highlightMatchesLater();
            }
        });
    }

    private void layoutComponents() {
        FormLayoutHelper formLayoutHelper = new FormLayoutHelper(this, FormLayoutHelper.EAGER_COLUMN);
        formLayoutHelper.setAllGaps(true);
        JPanel jPanel = this.createFormPanel();
        JPanel jPanel2 = this.createButtonsPanel();
        formLayoutHelper.addRow(-1, jPanel.getPreferredSize().height, jPanel.getPreferredSize().height, jPanel);
        formLayoutHelper.addRow(-1, 200, Short.MAX_VALUE, this.textScrollPane);
        formLayoutHelper.addRow(-1, jPanel2.getPreferredSize().height, jPanel2.getPreferredSize().height, jPanel2);
    }

    private JPanel createButtonsPanel() {
        JPanel jPanel = new JPanel();
        FormLayoutHelper formLayoutHelper = new FormLayoutHelper(jPanel, FormLayoutHelper.EAGER_COLUMN, FormLayoutHelper.DEFAULT_COLUMN, FormLayoutHelper.DEFAULT_COLUMN);
        formLayoutHelper.setInlineGaps(true);
        formLayoutHelper.addRow(this.getExtraButton(), this.btnApply, this.btnCancel);
        return jPanel;
    }

    private JPanel createFormPanel() {
        JPanel jPanel = new JPanel();
        FormLayoutHelper formLayoutHelper = new FormLayoutHelper(jPanel, FormLayoutHelper.DEFAULT_COLUMN, FormLayoutHelper.EAGER_COLUMN);
        formLayoutHelper.setInlineGaps(true);
        formLayoutHelper.addRow(this.lblPattern, this.cboxPattern);
        if (this.lblHint.getText() != null && !"".equals(this.lblHint.getText())) {
            formLayoutHelper.addRow(new JLabel(), this.lblHint);
        }
        formLayoutHelper.addRow(this.lblOptions, this.pnlOptions);
        return jPanel;
    }

    private void setMnemonics() {
        Mnemonics.setLocalizedText((JLabel)this.lblPattern, (String)this.getPatternLabelText());
        Mnemonics.setLocalizedText((JLabel)this.lblHint, (String)this.getHintLabelText());
        Mnemonics.setLocalizedText((AbstractButton)this.btnCancel, (String)PatternSandbox.getText("PatternSandbox.btnCancel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnApply, (String)PatternSandbox.getText("PatternSandbox.btnApply.text"));
    }

    private void initHighlighter() {
        this.highlighter = new DefaultHighlighter();
        this.painter = new DefaultHighlighter.DefaultHighlightPainter(Color.ORANGE);
        this.textPane.setHighlighter(this.highlighter);
    }

    private void initInteraction() {
        this.initTextInputInteraction();
        this.initButtonsInteraction();
    }

    private void setKeys() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        String string = "cancel";
        this.getRootPane().getInputMap(1).put(keyStroke, string);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PatternSandbox.this.closeDialog();
            }
        };
        this.getRootPane().getActionMap().put(string, abstractAction);
        this.getRootPane().setDefaultButton(this.btnApply);
    }

    protected void highlightMatchesLater() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PatternSandbox.this.highlightMatches();
            }
        });
    }

    protected void highlightMatches() {
        Pattern pattern;
        this.highlighter.removeAllHighlights();
        Object object = this.cboxPattern.getEditor().getItem();
        if (object == null || object.toString().isEmpty()) {
            return;
        }
        String string = object.toString();
        try {
            pattern = this.getPatternForHighlighting(string);
            if (pattern == null) {
                throw new NullPointerException();
            }
            this.cboxPattern.getEditor().getEditorComponent().setForeground(SystemColor.textText);
        }
        catch (Throwable throwable) {
            this.cboxPattern.getEditor().getEditorComponent().setForeground(Color.red);
            return;
        }
        this.highlightIndividualMatches(pattern);
    }

    private static String getText(String string) {
        return NbBundle.getMessage(PatternSandbox.class, (String)string);
    }

    private static <T> List<T> reverse(List<T> list) {
        LinkedList<T> linkedList = new LinkedList<T>();
        for (T t : list) {
            linkedList.add(0, t);
        }
        return linkedList;
    }

    private void closeDialog() {
        this.saveTextPaneContent();
        Window window = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
        if (window != null) {
            window.dispose();
        }
    }

    private static String getSelectedItemAsString(JComboBox jComboBox) {
        if (jComboBox.getSelectedItem() != null) {
            return jComboBox.getSelectedItem().toString();
        }
        return "";
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        if (hierarchyEvent.getID() == 1400) {
            this.setKeys();
        }
    }

    protected JComponent getExtraButton() {
        return new JLabel();
    }

    protected abstract String getPatternLabelText();

    protected abstract String getHintLabelText();

    protected abstract JPanel createOptionsPanel();

    protected abstract void initSpecificComponents();

    protected abstract void apply();

    protected abstract Pattern getPatternForHighlighting(String var1);

    protected abstract void highlightIndividualMatches(Pattern var1);

    protected abstract void initTextPaneContent();

    protected abstract void saveTextPaneContent();

    protected abstract String getTitle();

    public static void openDialog(PatternSandbox patternSandbox, JComponent jComponent) {
        JDialog jDialog = new JDialog((JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, jComponent));
        jDialog.add(patternSandbox);
        jDialog.setTitle(patternSandbox.getTitle());
        jDialog.setModal(true);
        jDialog.setLocationRelativeTo(jComponent);
        jDialog.pack();
        jDialog.setVisible(true);
    }

    protected class RegexpModeListener
    implements ItemListener {
        protected RegexpModeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            PatternSandbox.this.lblHint.setVisible(itemEvent.getStateChange() == 2);
        }
    }

    static class PathPatternComposer
    extends PathPatternSandbox
    implements ItemListener {
        private JCheckBox chkFileRegexp;

        public PathPatternComposer(String string, boolean bl) {
            super(string);
            this.pathRegexp = bl;
            this.initComponents();
            if (bl) {
                this.searchCriteria.setFileNameRegexp(true);
            }
        }

        @Override
        protected void initSpecificComponents() {
            super.initSpecificComponents();
            this.chkFileRegexp = new JCheckBox();
            this.chkFileRegexp.addItemListener(this);
            this.chkFileRegexp.addItemListener(new RegexpModeListener());
            this.chkFileRegexp.setSelected(this.pathRegexp);
            Mnemonics.setLocalizedText((AbstractButton)this.chkFileRegexp, (String)PatternSandbox.getText("BasicSearchForm.chkFileNameRegex.text"));
        }

        @Override
        protected JPanel createOptionsPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(3, 0, 0));
            jPanel.setLayout(new BoxLayout(jPanel, 2));
            jPanel.add(this.chkFileRegexp);
            return jPanel;
        }

        @Override
        protected final void apply() {
            this.onApply(PatternSandbox.getSelectedItemAsString(this.cboxPattern), this.chkFileRegexp.isSelected());
        }

        protected void onApply(String string, boolean bl) {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemSelectable == this.chkFileRegexp) {
                this.searchCriteria.setFileNameRegexp(this.chkFileRegexp.isSelected());
                this.highlightMatchesLater();
            }
        }

        @Override
        protected String getHintLabelText() {
            return PatternSandbox.getText("BasicSearchForm.cboxFileNamePattern.tooltip");
        }
    }

    public static class PathPatternSandbox
    extends PatternSandbox {
        protected boolean pathRegexp;
        protected String value;

        public PathPatternSandbox(String string) {
            this.value = string;
            this.initComponents();
            this.searchCriteria.setFileNameRegexp(true);
        }

        @Override
        protected void initSpecificComponents() {
            this.cboxPattern.setSelectedItem(this.value);
            FindDialogMemory findDialogMemory = FindDialogMemory.getDefault();
            for (String string : PatternSandbox.reverse(findDialogMemory.getFileNamePatterns())) {
                this.cboxPattern.addItem(string);
            }
        }

        @Override
        protected String getPatternLabelText() {
            return PatternSandbox.getText("BasicSearchForm.lblFileNamePattern.text");
        }

        @Override
        protected String getHintLabelText() {
            return "";
        }

        @Override
        protected JPanel createOptionsPanel() {
            return new JPanel();
        }

        @Override
        protected void apply() {
            this.onApply(PatternSandbox.getSelectedItemAsString(this.cboxPattern));
        }

        protected void onApply(String string) {
        }

        @Override
        protected void initTextPaneContent() {
            String string = FindDialogMemory.getDefault().getPathSandboxContent();
            this.textPane.setText(string);
        }

        @Override
        protected void saveTextPaneContent() {
            String string = this.textPane.getText();
            FindDialogMemory.getDefault().setPathSandboxContent(string);
        }

        @Override
        protected Pattern getPatternForHighlighting(String string) {
            this.searchCriteria.setFileNamePattern(string);
            this.searchCriteria.onOk();
            return this.searchCriteria.getFileNamePattern();
        }

        @Override
        protected void highlightIndividualMatches(Pattern pattern) {
            String string = this.textPane.getText().replaceAll("\r\n", "\n");
            Pattern pattern2 = Pattern.compile("\n");
            Matcher matcher = pattern2.matcher(string);
            int n = 0;
            while (matcher.find()) {
                this.matchLine(string, pattern, n, matcher.start());
                n = matcher.end();
            }
            this.matchLine(string, pattern, n, string.length());
            this.textPane.repaint();
        }

        private void matchLine(String string, Pattern pattern, int n, int n2) {
            boolean bl;
            if (this.searchCriteria.isFileNameRegexp()) {
                Matcher matcher = pattern.matcher(string.substring(n, n2));
                bl = matcher.find();
            } else {
                int n3 = string.lastIndexOf("/", n2);
                if (n3 == -1 || n3 < n) {
                    n3 = string.lastIndexOf("\\", n2);
                }
                int n4 = n3 == -1 || n3 < n ? n : n3 + 1;
                Matcher matcher = pattern.matcher(string.substring(n4, n2));
                bl = matcher.matches();
            }
            if (bl) {
                try {
                    this.highlighter.addHighlight(n, n2, this.painter);
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
        }

        @Override
        protected JComponent getExtraButton() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(3, 0, 0));
            final JButton jButton = new JButton();
            jPanel.add(jButton);
            Mnemonics.setLocalizedText((AbstractButton)jButton, (String)PatternSandbox.getText("PathPatternSandbox.browseButton.text"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setFileSelectionMode(0);
                    jFileChooser.setMultiSelectionEnabled(true);
                    jFileChooser.showOpenDialog(jButton);
                    if (jFileChooser.getSelectedFiles() == null) {
                        return;
                    }
                    for (File file : jFileChooser.getSelectedFiles()) {
                        PathPatternSandbox.this.textPane.setText(PathPatternSandbox.this.textPane.getText() + "\n" + file.getAbsolutePath());
                    }
                }
            });
            return jPanel;
        }

        @Override
        protected String getTitle() {
            return PatternSandbox.getText("PathPatternSandbox.title");
        }
    }

    static class TextPatternSandbox
    extends PatternSandbox
    implements ItemListener {
        private JCheckBox chkMatchCase;
        private String regexp;
        private boolean matchCase;

        public TextPatternSandbox(String string, boolean bl) {
            this.regexp = string;
            this.matchCase = bl;
            this.initComponents();
            this.searchCriteria.setRegexp(true);
        }

        @Override
        protected void initSpecificComponents() {
            this.chkMatchCase = new JCheckBox();
            this.chkMatchCase.addItemListener(this);
            this.setSpecificMnemonics();
            this.chkMatchCase.setSelected(this.matchCase);
            this.cboxPattern.setSelectedItem(this.regexp);
            SearchHistory searchHistory = SearchHistory.getDefault();
            for (SearchPattern searchPattern : searchHistory.getSearchPatterns()) {
                this.cboxPattern.addItem(searchPattern.getSearchExpression());
            }
        }

        private void setSpecificMnemonics() {
            Mnemonics.setLocalizedText((AbstractButton)this.chkMatchCase, (String)PatternSandbox.getText("BasicSearchForm.chkCaseSensitive.text"));
        }

        @Override
        protected String getPatternLabelText() {
            return PatternSandbox.getText("BasicSearchForm.lblTextToFind.text");
        }

        @Override
        protected JPanel createOptionsPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout(3, 0, 0));
            jPanel.add(this.chkMatchCase);
            return jPanel;
        }

        @Override
        protected final void apply() {
            this.onApply(PatternSandbox.getSelectedItemAsString(this.cboxPattern), this.chkMatchCase.isSelected());
        }

        protected void onApply(String string, boolean bl) {
        }

        @Override
        protected void initTextPaneContent() {
            String string = FindDialogMemory.getDefault().getTextSandboxContent();
            this.textPane.setText(string);
        }

        @Override
        protected void saveTextPaneContent() {
            String string = this.textPane.getText();
            FindDialogMemory.getDefault().setTextSandboxContent(string);
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemSelectable == this.chkMatchCase) {
                this.searchCriteria.setCaseSensitive(this.chkMatchCase.isSelected());
            }
            this.highlightMatchesLater();
        }

        @Override
        protected Pattern getPatternForHighlighting(String string) {
            this.searchCriteria.onOk();
            this.searchCriteria.setTextPattern(string);
            return this.searchCriteria.getTextPattern();
        }

        @Override
        protected void highlightIndividualMatches(Pattern pattern) {
            String string = this.textPane.getText().replaceAll("\r\n", "\n");
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                try {
                    this.highlighter.addHighlight(matcher.start(), matcher.end(), this.painter);
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, badLocationException);
                }
            }
            this.textPane.repaint();
        }

        @Override
        protected String getTitle() {
            return PatternSandbox.getText("TextPatternSandbox.title");
        }

        @Override
        protected String getHintLabelText() {
            return "";
        }
    }
}

