/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import org.netbeans.modules.search.BasicComposition;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.ui.BasicAbstractResultsPanel;
import org.netbeans.modules.search.ui.BasicReplaceResultsPanel;
import org.netbeans.modules.search.ui.BasicSearchResultsPanel;
import org.netbeans.spi.search.provider.SearchResultsDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

class ResultDisplayer
extends SearchResultsDisplayer<MatchingObject.Def> {
    private ResultModel resultModel;
    private BasicSearchCriteria criteria;
    private BasicComposition composition;
    private BasicAbstractResultsPanel resultPanel;
    private Node infoNode;

    public ResultDisplayer(BasicSearchCriteria basicSearchCriteria, BasicComposition basicComposition) {
        this.criteria = basicSearchCriteria;
        this.resultModel = new ResultModel(basicSearchCriteria, basicSearchCriteria.getReplaceString());
        this.composition = basicComposition;
        this.resultModel.setCommonSearchFolder(CommonSearchRoot.find(basicComposition.getRootFiles()));
    }

    @Override
    public synchronized JComponent getVisualComponent() {
        if (this.resultPanel != null) {
            return this.resultPanel;
        }
        this.resultPanel = this.criteria.isSearchAndReplace() ? new BasicReplaceResultsPanel(this.resultModel, this.composition, this.composition.getRootFiles(), this.infoNode) : new BasicSearchResultsPanel(this.resultModel, this.composition, this.criteria.isFullText(), this.composition.getRootFiles(), this.infoNode);
        this.resultPanel.setToolTipText(this.composition.getScopeDisplayName() + ": " + this.getTitle());
        return this.resultPanel;
    }

    @Override
    public void addMatchingObject(MatchingObject.Def def) {
        if (this.resultModel.objectFound(def.getFileObject(), def.getCharset(), def.getTextDetails())) {
            this.resultPanel.update();
            this.resultPanel.addMatchingObject(this.resultModel.getMatchingObjects().get(this.resultModel.size() - 1));
        }
        if (this.resultModel.wasLimitReached()) {
            this.composition.terminate();
        }
    }

    ResultModel getResultModel() {
        return this.resultModel;
    }

    @Override
    public String getTitle() {
        if (this.criteria.getTextPattern() == null) {
            if (this.criteria.getFileNamePattern() == null) {
                return NbBundle.getMessage(ResultView.class, (String)"TEXT_MSG_RESULTS_FOR_FILE_PATTERN");
            }
            return this.criteria.getFileNamePatternExpr();
        }
        return this.criteria.getTextPatternExpr();
    }

    @Override
    public void searchStarted() {
        this.resultModel.setStartTime();
        this.resultPanel.searchStarted();
    }

    @Override
    public void searchFinished() {
        this.resultPanel.searchFinished();
    }

    @Override
    public void setInfoNode(Node node) {
        this.infoNode = node;
    }

    static class CommonSearchRoot {
        private static final int MIN_REL_PATH_LEN = 4;
        private boolean exists = true;
        private List<FileObject> path;
        private FileObject file = null;

        CommonSearchRoot() {
        }

        synchronized void update(FileObject fileObject) {
            if (this.exists) {
                if (this.exists && this.file == null) {
                    this.initCommonPath(fileObject);
                } else if (!FileUtil.isParentOf((FileObject)this.file, (FileObject)fileObject)) {
                    List<FileObject> list = CommonSearchRoot.filePathAsList(fileObject.getParent());
                    this.path = CommonSearchRoot.findCommonPath(this.path, list);
                    if (this.path.isEmpty()) {
                        this.path = null;
                        this.file = null;
                        this.exists = false;
                    } else {
                        this.file = this.path.get(this.path.size() - 1);
                    }
                }
            }
        }

        static List<FileObject> findCommonPath(List<FileObject> list, List<FileObject> list2) {
            Iterator<FileObject> iterator = list.iterator();
            Iterator<FileObject> iterator2 = list2.iterator();
            while (iterator.hasNext() && iterator2.hasNext()) {
                FileObject fileObject;
                FileObject fileObject2 = iterator.next();
                if (fileObject2.equals(fileObject = iterator2.next())) continue;
                return list.subList(0, list.indexOf(fileObject2));
            }
            return list;
        }

        static List<FileObject> filePathAsList(FileObject fileObject) {
            LinkedList<FileObject> linkedList = new LinkedList<FileObject>();
            for (FileObject fileObject2 = fileObject; fileObject2 != null; fileObject2 = fileObject2.getParent()) {
                linkedList.add(0, fileObject2);
            }
            return linkedList;
        }

        private void initCommonPath(FileObject fileObject) {
            Object object;
            for (object = fileObject; object != null; object = object.getParent()) {
                FileObject fileObject2;
                if (!this.isLikeProjectFolder((FileObject)object) || (fileObject2 = object.getParent()) == null) continue;
                this.file = fileObject2;
                this.path = CommonSearchRoot.filePathAsList(fileObject2);
                return;
            }
            object = CommonSearchRoot.filePathAsList(fileObject);
            if (object.size() > 4) {
                this.path = object.subList(0, object.size() - 4);
                this.file = this.path.get(this.path.size() - 1);
            } else {
                this.exists = false;
            }
        }

        private boolean isLikeProjectFolder(FileObject fileObject) {
            if (fileObject.getFileObject("src") != null) {
                return true;
            }
            return fileObject.getFileObject("nbproject") != null;
        }

        synchronized FileObject getFileObject() {
            if (this.exists) {
                return this.file;
            }
            return null;
        }

        private static FileObject find(List<FileObject> list) {
            CommonSearchRoot commonSearchRoot = new CommonSearchRoot();
            for (FileObject fileObject : list) {
                commonSearchRoot.update(fileObject);
            }
            return commonSearchRoot.getFileObject();
        }
    }
}

