/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Rectangle;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;

class ResultTreeScrollController
implements TreeWillExpandListener,
TreeExpansionListener {
    private int lastX = -1;
    private JScrollPane scrollPane;
    private JTree tree;
    private boolean enabled = true;

    private ResultTreeScrollController(JScrollPane jScrollPane, JTree jTree) {
        this.scrollPane = jScrollPane;
        this.tree = jTree;
    }

    @Override
    public synchronized void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
        if (this.enabled) {
            this.lastX = (int)this.scrollPane.getViewport().getViewPosition().getX();
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
    }

    @Override
    public void treeExpanded(final TreeExpansionEvent treeExpansionEvent) {
        if (!this.enabled) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Rectangle rectangle = ResultTreeScrollController.this.tree.getPathBounds(treeExpansionEvent.getPath());
                if (rectangle != null) {
                    Object object = treeExpansionEvent.getPath().getLastPathComponent();
                    int n = ResultTreeScrollController.this.tree.getModel().getChildCount(object);
                    int n2 = (int)rectangle.getHeight() * (n + 1);
                    Rectangle rectangle2 = new Rectangle(ResultTreeScrollController.this.lastX, (int)rectangle.getY(), ResultTreeScrollController.this.scrollPane.getWidth() - 20, n2);
                    ResultTreeScrollController.this.tree.scrollRectToVisible(rectangle2);
                }
            }
        });
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    static ResultTreeScrollController register(JScrollPane jScrollPane, JTree jTree) {
        ResultTreeScrollController resultTreeScrollController = new ResultTreeScrollController(jScrollPane, jTree);
        jTree.addTreeWillExpandListener(resultTreeScrollController);
        jTree.addTreeExpansionListener(resultTreeScrollController);
        jTree.setScrollsOnExpand(false);
        return resultTreeScrollController;
    }
}

