/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.search.SearchScopeDefinition;
import org.netbeans.spi.search.SearchScopeDefinitionProvider;
import org.openide.util.Lookup;

public class SearchScopeList {
    private List<SearchScopeDefinition> scopes = null;
    private List<ChangeListener> changeListeners = new ArrayList<ChangeListener>(1);
    private ProxyChangeListener proxyChangeListener = new ProxyChangeListener();

    public SearchScopeList(SearchScopeDefinition ... searchScopeDefinitionArray) {
        this.scopes = this.createScopeList(searchScopeDefinitionArray);
    }

    public void clean() {
        for (SearchScopeDefinition searchScopeDefinition : this.scopes) {
            searchScopeDefinition.removeChangeListener(this.proxyChangeListener);
            searchScopeDefinition.clean();
        }
        this.scopes.clear();
        this.changeListeners.clear();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    private List<SearchScopeDefinition> createScopeList(SearchScopeDefinition ... searchScopeDefinitionArray) {
        this.scopes = new ArrayList<SearchScopeDefinition>(6);
        Collection collection = Lookup.getDefault().lookupAll(SearchScopeDefinitionProvider.class);
        for (SearchScopeDefinitionProvider object : collection) {
            this.scopes.addAll(object.createSearchScopeDefinitions());
        }
        this.scopes.addAll(Arrays.asList(searchScopeDefinitionArray));
        Collections.sort(this.scopes, new ScopePriorityComparator());
        for (SearchScopeDefinition searchScopeDefinition : this.scopes) {
            searchScopeDefinition.addChangeListener(this.proxyChangeListener);
        }
        return this.scopes;
    }

    public List<SearchScopeDefinition> getSeachScopeDefinitions() {
        return this.scopes;
    }

    private class ProxyChangeListener
    implements ChangeListener {
        private ProxyChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            for (ChangeListener changeListener : SearchScopeList.this.changeListeners) {
                changeListener.stateChanged(changeEvent);
            }
        }
    }

    private class ScopePriorityComparator
    implements Comparator<SearchScopeDefinition> {
        private ScopePriorityComparator() {
        }

        @Override
        public int compare(SearchScopeDefinition searchScopeDefinition, SearchScopeDefinition searchScopeDefinition2) {
            return searchScopeDefinition.getPriority() - searchScopeDefinition2.getPriority();
        }
    }
}

