/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.CharConversionException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Caret;
import org.netbeans.api.search.SearchHistory;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.modules.search.Selectable;
import org.netbeans.modules.search.ui.ReplaceCheckableNode;
import org.netbeans.modules.search.ui.ResultsOutlineSupport;
import org.netbeans.modules.search.ui.UiUtils;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.xml.XMLUtil;

public final class TextDetail
implements Selectable {
    public static final int DH_SHOW = 1;
    public static final int DH_GOTO = 2;
    public static final int DH_HIDE = 3;
    private DataObject dobj;
    private int line;
    private String lineText;
    private int column;
    private int markLength;
    private Line lineObj;
    private SearchPattern searchPattern;
    private int startOffset;
    private int endOffset;
    private String matchedText;
    private boolean selected = true;
    private String lineNumberIndent = "";
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);

    public TextDetail(DataObject dataObject, SearchPattern searchPattern) {
        this.dobj = dataObject;
        this.searchPattern = searchPattern;
    }

    public void showDetail(int n) {
        JEditorPane[] jEditorPaneArray;
        this.prepareLine();
        if (this.lineObj == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (n == 3) {
            return;
        }
        EditorCookie editorCookie = (EditorCookie)this.dobj.getLookup().lookup(EditorCookie.class);
        if (editorCookie != null) {
            editorCookie.open();
        }
        if (n == 1) {
            this.lineObj.show(Line.ShowOpenType.NONE, Line.ShowVisibilityType.NONE, this.column - 1);
        } else if (n == 2) {
            this.lineObj.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, this.column - 1);
        }
        if (this.markLength > 0 && editorCookie != null && (jEditorPaneArray = editorCookie.getOpenedPanes()) != null && jEditorPaneArray.length > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Caret caret = jEditorPaneArray[0].getCaret();
                    caret.moveDot(caret.getDot() + TextDetail.this.markLength);
                }
            });
        }
        SearchHistory.getDefault().setLastSelected(SearchPattern.create(this.searchPattern.getSearchExpression(), this.searchPattern.isWholeWords(), this.searchPattern.isMatchCase(), this.searchPattern.isRegExp()));
    }

    public String getLineText() {
        return this.lineText;
    }

    public void setLineText(String string) {
        this.lineText = string;
    }

    String getLineTextPart(int n, int n2) {
        return this.lineText.substring(n, n2);
    }

    String getLineTextPart(int n) {
        return this.lineText.substring(n);
    }

    public int getLineTextLength() {
        return this.lineText == null ? 0 : this.lineText.length();
    }

    public DataObject getDataObject() {
        return this.dobj;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int n) {
        this.line = n;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int n) {
        this.column = n;
    }

    int getColumn0() {
        return this.column - 1;
    }

    public void setMarkLength(int n) {
        this.markLength = n;
    }

    public int getMarkLength() {
        return this.markLength;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int n) {
        this.endOffset = n;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(int n) {
        this.startOffset = n;
    }

    public String getMatchedText() {
        return this.matchedText;
    }

    public void setMatchedText(String string) {
        this.matchedText = string;
    }

    public void associate(int n, int n2, String string) {
        this.setLine(n);
        this.setColumn(n2);
        this.setLineText(string);
    }

    private void prepareLine() {
        LineCookie lineCookie;
        if (this.dobj == null || !this.dobj.isValid()) {
            this.lineObj = null;
        } else if (this.lineObj == null && (lineCookie = (LineCookie)this.dobj.getLookup().lookup(LineCookie.class)) != null) {
            Line.Set set = lineCookie.getLineSet();
            try {
                this.lineObj = set.getOriginal(this.line - 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.lineObj = set.getOriginal(TextDetail.findMaxLine(set));
                this.markLength = 0;
                this.column = 0;
            }
        }
    }

    private static int findMaxLine(Line.Set set) {
        int n = 0;
        int n2 = 32000;
        try {
            while (true) {
                set.getOriginal(n2);
                n = n2;
                n2 *= 2;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            while (n < n2) {
                int n3 = (n + n2 + 1) / 2;
                try {
                    set.getOriginal(n3);
                    n = n3;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException2) {
                    n2 = n3 - 1;
                }
            }
            return n;
        }
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean bl) {
        if (this.selected != bl) {
            this.selected = bl;
            this.fireChange();
        }
    }

    @Override
    public void setSelectedRecursively(boolean bl) {
        this.setSelected(bl);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void fireChange() {
        this.changeSupport.fireChange();
    }

    void setLineNumberIndent(String string) {
        this.lineNumberIndent = string;
    }

    private static class GotoDetailAction
    extends AbstractAction {
        private DetailNode detailNode;

        public GotoDetailAction(DetailNode detailNode) {
            super(UiUtils.getText("LBL_GotoDetailAction"));
            this.detailNode = detailNode;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.detailNode.gotoDetail();
        }
    }

    static final class DetailNode
    extends AbstractNode
    implements OutputListener {
        private static final String ICON = "org/netbeans/modules/search/res/textDetail.png";
        private TextDetail txtDetail;

        public DetailNode(TextDetail textDetail, boolean bl) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{textDetail, new ReplaceCheckableNode(textDetail, bl)}));
            this.txtDetail = textDetail;
            this.setShortDescription(DetailNode.getShortDesc(textDetail));
            this.setValue("output line", DetailNode.getFullDesc(textDetail));
            textDetail.prepareLine();
            textDetail.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    DetailNode.this.fireIconChange();
                    ResultsOutlineSupport.toggleParentSelected((Node)DetailNode.this);
                }
            });
            this.setIconBaseWithExtension(ICON);
        }

        public Action[] getActions(boolean bl) {
            if (!bl) {
                return new Action[]{this.getPreferredAction()};
            }
            return new Action[0];
        }

        public Action getPreferredAction() {
            return new GotoDetailAction(this);
        }

        public boolean equals(Object object) {
            return object != null && object.getClass() == DetailNode.class && ((DetailNode)((Object)object)).txtDetail.equals(this.txtDetail);
        }

        public int hashCode() {
            return this.txtDetail.hashCode() + 1;
        }

        public String getName() {
            return this.txtDetail.getLineText() + "      [" + DetailNode.getName(this.txtDetail) + "]";
        }

        public String getHtmlDisplayName() {
            try {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<font color='!controlShadow'>");
                stringBuffer.append(this.txtDetail.lineNumberIndent);
                stringBuffer.append(this.txtDetail.getLine());
                stringBuffer.append(": ");
                stringBuffer.append("</font>");
                if (this.canBeMarked()) {
                    this.appendMarkedText(stringBuffer);
                } else {
                    stringBuffer.append(DetailNode.escape(this.txtDetail.getLineText()));
                }
                stringBuffer.append("      ");
                stringBuffer.append("<font color='!controlShadow'>[");
                stringBuffer.append(DetailNode.escape(DetailNode.getLinePos(this.txtDetail)));
                stringBuffer.append("]");
                return stringBuffer.toString();
            }
            catch (CharConversionException charConversionException) {
                return null;
            }
        }

        private boolean canBeMarked() {
            int n = this.txtDetail.getColumn0();
            return this.txtDetail.getMarkLength() > 0 && n > -1 && n < this.txtDetail.getLineTextLength();
        }

        private void appendMarkedText(StringBuffer stringBuffer) throws CharConversionException {
            int n = this.txtDetail.getColumn0();
            int n2 = n + Math.min(this.txtDetail.getMarkLength(), this.txtDetail.getLineTextLength() - n);
            int n3 = n + this.txtDetail.getMarkLength();
            int n4 = this.txtDetail.getLineTextLength();
            stringBuffer.append(DetailNode.escape(this.txtDetail.getLineTextPart(0, n)));
            stringBuffer.append("<b>");
            if (n3 > n4) {
                stringBuffer.append(DetailNode.escape(this.txtDetail.getLineTextPart(n, n2)));
                stringBuffer.append(" ...");
            } else {
                stringBuffer.append(DetailNode.escape(this.txtDetail.getLineTextPart(n, n2)));
            }
            stringBuffer.append("</b>");
            if (n4 > n2) {
                stringBuffer.append(DetailNode.escape(this.txtDetail.getLineTextPart(n2)));
            }
        }

        private static String escape(String string) throws CharConversionException {
            return XMLUtil.toElementContent((String)string);
        }

        void gotoDetail() {
            this.txtDetail.showDetail(2);
        }

        private void showDetail() {
            this.txtDetail.showDetail(1);
        }

        public void outputLineSelected(OutputEvent outputEvent) {
            this.txtDetail.showDetail(1);
        }

        public void outputLineAction(OutputEvent outputEvent) {
            this.txtDetail.showDetail(2);
        }

        public void outputLineCleared(OutputEvent outputEvent) {
            this.txtDetail.showDetail(3);
        }

        private static String getName(TextDetail textDetail) {
            int n = textDetail.getLine();
            int n2 = textDetail.getColumn();
            if (n2 > 0) {
                return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_NAME1", (Object)Integer.toString(n), (Object)Integer.toString(n2));
            }
            return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_NAME2", (Object)Integer.toString(n));
        }

        private static String getLinePos(TextDetail textDetail) {
            int n = textDetail.getColumn();
            if (n > 0) {
                return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_NAME3", (Object)n);
            }
            return "";
        }

        private static String getShortDesc(TextDetail textDetail) {
            int n = textDetail.getLine();
            int n2 = textDetail.getColumn();
            if (n2 > 0) {
                return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_SHORT1", (Object[])new Object[]{Integer.toString(n), Integer.toString(n2)});
            }
            return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_SHORT2", (Object)Integer.toString(n));
        }

        private static String getFullDesc(TextDetail textDetail) {
            String string = textDetail.getDataObject().getPrimaryFile().getNameExt();
            String string2 = textDetail.getLineText();
            int n = textDetail.getLine();
            int n2 = textDetail.getColumn();
            if (n2 > 0) {
                return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_FULL1", (Object[])new Object[]{string2, string, Integer.toString(n), Integer.toString(n2)});
            }
            return NbBundle.getMessage(DetailNode.class, (String)"TEXT_DETAIL_FMT_FULL2", (Object[])new Object[]{string2, string, Integer.toString(n)});
        }

        protected void createPasteTypes(Transferable transferable, List<PasteType> list) {
        }
    }
}

