/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.matcher;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.search.MatchingObject;
import org.openide.filesystems.FileObject;

public abstract class AbstractMatcher {
    private long totalTime = 0L;
    private int matchingFiles = 0;
    private int matchingItems = 0;
    private boolean strict = true;

    public final MatchingObject.Def check(FileObject fileObject, SearchListener searchListener) {
        long l = System.currentTimeMillis();
        MatchingObject.Def def = this.checkMeasuredInternal(fileObject, searchListener);
        long l2 = System.currentTimeMillis();
        if (def != null) {
            ++this.matchingFiles;
            if (def.getTextDetails() != null && !def.getTextDetails().isEmpty()) {
                ++this.matchingItems;
            }
        }
        this.totalTime += l2 - l;
        return def;
    }

    protected abstract MatchingObject.Def checkMeasuredInternal(FileObject var1, SearchListener var2);

    public long getTotalTime() {
        return this.totalTime;
    }

    public int getMatchingFiles() {
        return this.matchingFiles;
    }

    public int getMatchingItems() {
        return this.matchingItems;
    }

    public abstract void terminate();

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean bl) {
        this.strict = bl;
    }

    public CharsetDecoder prepareDecoder(Charset charset) {
        CharsetDecoder charsetDecoder = charset.newDecoder();
        if (this.strict) {
            charsetDecoder.onMalformedInput(CodingErrorAction.REPORT);
            charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        } else {
            charsetDecoder.onMalformedInput(CodingErrorAction.IGNORE);
            charsetDecoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        return charsetDecoder;
    }
}

