/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.matcher;

import java.util.Collection;
import java.util.HashSet;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.TextRegexpUtil;
import org.netbeans.modules.search.matcher.AbstractMatcher;
import org.netbeans.modules.search.matcher.MatcherUtils;
import org.netbeans.modules.search.matcher.MultiLineStreamMatcher;
import org.netbeans.modules.search.matcher.SingleLineStreamMatcher;
import org.netbeans.modules.search.matcher.TrivialFileMatcher;
import org.openide.filesystems.FileObject;

public class DefaultMatcher
extends AbstractMatcher {
    private static final int MAX_UNRECOGNIZED_FILE_SIZE = 0x500000;
    private static final Collection<String> searchableXMimeTypes = new HashSet<String>(17);
    private static final Collection<String> searchableExtensions;
    private AbstractMatcher realMatcher;
    private boolean trivial;

    public DefaultMatcher(SearchPattern searchPattern) {
        boolean bl;
        this.trivial = MatcherUtils.isTrivialPattern(searchPattern);
        this.realMatcher = this.trivial ? new TrivialFileMatcher() : ((bl = TextRegexpUtil.canBeMultilinePattern(searchPattern.getSearchExpression())) ? new MultiLineStreamMatcher(searchPattern) : new SingleLineStreamMatcher(searchPattern));
    }

    @Override
    public MatchingObject.Def checkMeasuredInternal(FileObject fileObject, SearchListener searchListener) {
        if (this.trivial) {
            return this.realMatcher.check(fileObject, searchListener);
        }
        if (DefaultMatcher.isTextFile(fileObject)) {
            try {
                return this.realMatcher.check(fileObject, searchListener);
            }
            catch (Exception exception) {
                searchListener.fileContentMatchingError(fileObject.getPath(), exception);
                return null;
            }
        }
        searchListener.fileSkipped(fileObject, null, "Not a text file");
        return null;
    }

    @Override
    public synchronized void terminate() {
        this.realMatcher.terminate();
    }

    private static boolean isTextFile(FileObject fileObject) {
        String string = fileObject.getMIMEType();
        if (string.equals("content/unknown")) {
            if (searchableExtensions.contains(fileObject.getExt().toLowerCase())) {
                return true;
            }
            return fileObject.getSize() <= 0x500000L;
        }
        if (string.startsWith("text/")) {
            return true;
        }
        if (string.startsWith("application/")) {
            String string2 = string.substring(12);
            return string2.equals("rtf") || string2.equals("sgml") || string2.startsWith("xml-") || string2.endsWith("+xml") || string2.startsWith("x-") && searchableXMimeTypes.contains(string2.substring(2));
        }
        return false;
    }

    @Override
    public void setStrict(boolean bl) {
        super.setStrict(bl);
        this.realMatcher.setStrict(bl);
    }

    static {
        searchableXMimeTypes.add("csh");
        searchableXMimeTypes.add("httpd-eruby");
        searchableXMimeTypes.add("httpd-php");
        searchableXMimeTypes.add("httpd-php-source");
        searchableXMimeTypes.add("javascript");
        searchableXMimeTypes.add("latex");
        searchableXMimeTypes.add("php");
        searchableXMimeTypes.add("sh");
        searchableXMimeTypes.add("tcl");
        searchableXMimeTypes.add("tex");
        searchableXMimeTypes.add("texinfo");
        searchableXMimeTypes.add("troff");
        searchableExtensions = new HashSet<String>();
        searchableExtensions.add("txt");
        searchableExtensions.add("log");
    }
}

