/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.matcher;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.CharsetDecoder;
import org.openide.util.Exceptions;

class LineReader {
    private static final int FILE_LENGTH_LIMIT = 100000;
    int lastChar = 0;
    int pos = 0;
    int line = 1;
    InputStreamReader isr;
    BufferedReader br;

    LineReader(CharsetDecoder charsetDecoder, InputStream inputStream) throws IOException {
        this.isr = new InputStreamReader(inputStream, charsetDecoder);
        try {
            this.br = new BufferedReader(this.isr);
        }
        catch (Throwable throwable) {
            if (this.isr != null) {
                try {
                    this.isr.close();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            throw new IOException(throwable);
        }
    }

    LineInfo readNext() throws IOException {
        int n;
        LineInfo lineInfo = new LineInfo(this.pos, this.line);
        while ((n = this.br.read()) != -1) {
            ++this.pos;
            if (n == 10 && this.lastChar == 13) {
                lineInfo = new LineInfo(this.pos, this.line);
            } else {
                if (this.isLineTerminator(n)) {
                    ++this.line;
                    this.lastChar = n;
                    lineInfo.close();
                    return lineInfo;
                }
                lineInfo.appendCharacter(n);
            }
            this.lastChar = n;
        }
        if (lineInfo.isNotEmpty()) {
            lineInfo.close();
            return lineInfo;
        }
        return null;
    }

    private boolean isLineTerminator(int n) {
        return n == 10 || n == 13 || n == 12 || n == 8232 || n == 133 || n == 8233;
    }

    void close() {
        if (this.br != null) {
            try {
                this.br.close();
            }
            catch (Throwable throwable) {
                Exceptions.printStackTrace((Throwable)throwable);
            }
        }
        if (this.isr != null) {
            try {
                this.isr.close();
            }
            catch (Throwable throwable) {
                Exceptions.printStackTrace((Throwable)throwable);
            }
        }
    }

    static class LineInfo {
        private int start;
        private int length = 0;
        private int number;
        private StringBuilder sb = new StringBuilder();
        private String string = null;

        private LineInfo(int n, int n2) {
            this.start = n;
            this.number = n2;
        }

        private void appendCharacter(int n) throws IOException {
            this.sb.append((char)n);
            ++this.length;
            if (this.length > 100000) {
                throw new IOException("Line is too long: " + this.number);
            }
        }

        String getString() {
            return this.string;
        }

        int getNumber() {
            return this.number;
        }

        int getFileStart() {
            return this.start;
        }

        int getFileEnd() {
            return this.start + this.length;
        }

        private boolean isNotEmpty() {
            return this.length > 0;
        }

        int getLength() {
            return this.length;
        }

        void close() {
            this.string = this.sb.toString();
            this.sb = null;
        }
    }
}

