/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.ui;

import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.modules.search.FindDialogMemory;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.Selectable;
import org.netbeans.modules.search.ui.AbstractSearchResultsPanel;
import org.netbeans.modules.search.ui.MatchingObjectNode;
import org.netbeans.modules.search.ui.ReplaceCheckableNode;
import org.netbeans.modules.search.ui.ResultsOutlineCellRenderer;
import org.netbeans.modules.search.ui.UiUtils;
import org.netbeans.swing.etable.ETableColumnModel;
import org.openide.explorer.view.OutlineView;
import org.openide.explorer.view.Visualizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

public class ResultsOutlineSupport {
    private static final String ROOT_NODE_ICON = "org/netbeans/modules/search/res/context.gif";
    private static final int VERTICAL_ROW_SPACE = 2;
    OutlineView outlineView;
    private boolean replacing;
    private boolean details;
    private ResultsNode resultsNode;
    private ResultModel resultModel;
    private FolderTreeItem rootPathItem = new FolderTreeItem();
    private List<FileObject> rootFiles;
    private Node infoNode;
    private Node invisibleRoot;
    private List<TableColumn> allColumns = new ArrayList<TableColumn>(5);
    private ETableColumnModel columnModel;
    private List<MatchingObjectNode> matchingObjectNodes;
    private boolean closed = false;

    public ResultsOutlineSupport(boolean bl, boolean bl2, ResultModel resultModel, List<FileObject> list, Node node) {
        this.replacing = bl;
        this.details = bl2;
        this.resultModel = resultModel;
        this.rootFiles = list;
        this.resultsNode = new ResultsNode();
        this.infoNode = node;
        this.invisibleRoot = new AbstractSearchResultsPanel.RootNode((Node)this.resultsNode, node);
        this.matchingObjectNodes = new LinkedList<MatchingObjectNode>();
        this.createOutlineView();
    }

    private void createOutlineView() {
        this.outlineView = new OutlineView(UiUtils.getText("BasicSearchResultsPanel.outline.nodes"));
        this.outlineView.getOutline().setDefaultRenderer(Node.Property.class, (TableCellRenderer)((Object)new ResultsOutlineCellRenderer()));
        this.setOutlineColumns();
        this.outlineView.addTreeExpansionListener((TreeExpansionListener)new ExpandingTreeExpansionListener());
        this.outlineView.getOutline().setRootVisible(false);
        this.outlineView.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 2L) != 0L) {
                    if (ResultsOutlineSupport.this.outlineView.isDisplayable()) {
                        ResultsOutlineSupport.this.onAttach();
                    } else {
                        ResultsOutlineSupport.this.checkDetached(this);
                    }
                }
            }
        });
        this.outlineView.getOutline().getColumnModel().addColumnModelListener(new ColumnsListener());
        this.outlineView.getOutline().getInputMap().remove(KeyStroke.getKeyStroke(27, 0));
        this.outlineView.getOutline().setShowGrid(false);
        Font font = this.outlineView.getOutline().getFont();
        FontMetrics fontMetrics = this.outlineView.getOutline().getFontMetrics(font);
        this.outlineView.getOutline().setRowHeight(Math.max(16, fontMetrics.getHeight()) + 2);
    }

    private void onAttach() {
        this.outlineView.expandNode((Node)this.resultsNode);
    }

    private void checkDetached(final HierarchyListener hierarchyListener) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!ResultsOutlineSupport.this.outlineView.isDisplayable()) {
                    ResultsOutlineSupport.this.outlineView.removeHierarchyListener(hierarchyListener);
                    ResultsOutlineSupport.this.onDetach();
                }
            }
        });
    }

    private synchronized void onDetach() {
        this.clean();
        this.saveColumnState();
    }

    public synchronized void clean() {
        this.resultModel.close();
        for (MatchingObjectNode matchingObjectNode : this.matchingObjectNodes) {
            matchingObjectNode.clean();
        }
        this.closed = true;
    }

    private void loadColumnState() {
        int n;
        FindDialogMemory findDialogMemory = FindDialogMemory.getDefault();
        String string = this.replacing ? findDialogMemory.getResultsColumnWidthsReplacing() : (this.details ? findDialogMemory.getResultsColumnWidthsDetails() : findDialogMemory.getResultsColumnWidths());
        String[] stringArray = string.split("\\|");
        if (stringArray == null || stringArray.length != 2) {
            return;
        }
        String[] stringArray2 = stringArray[1].split(":");
        for (int i = 0; i < stringArray2.length; ++i) {
            try {
                n = Integer.parseInt(stringArray2[i]);
                int n2 = this.columnModel.getColumnIndex(this.allColumns.get(n).getIdentifier());
                this.columnModel.moveColumn(n2, i);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String[] stringArray3 = stringArray[0].split(":");
        for (n = 0; n < stringArray3.length && n < this.allColumns.size(); ++n) {
            String string2 = stringArray3[n];
            if (string2 == null || string2.isEmpty()) continue;
            try {
                int n3 = Integer.parseInt(string2);
                if (n3 == -1) {
                    this.columnModel.setColumnHidden(this.allColumns.get(n), true);
                    continue;
                }
                this.allColumns.get(n).setPreferredWidth(n3);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void saveColumnState() {
        StringBuilder stringBuilder = new StringBuilder();
        for (TableColumn object2 : this.allColumns) {
            if (this.columnModel.isColumnHidden(object2)) {
                stringBuilder.append(-1);
            } else {
                stringBuilder.append(object2.getWidth());
            }
            stringBuilder.append(":");
        }
        stringBuilder.append("|");
        Enumeration enumeration = this.columnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            int n = this.allColumns.indexOf(tableColumn);
            if (n < 0) continue;
            stringBuilder.append(n);
            stringBuilder.append(":");
        }
        String string = stringBuilder.toString();
        if (this.replacing) {
            FindDialogMemory.getDefault().setResultsColumnWidthsReplacing(string);
        } else if (this.details) {
            FindDialogMemory.getDefault().setResultsColumnWidthsDetails(string);
        } else {
            FindDialogMemory.getDefault().setResultsColumnWidths(string);
        }
    }

    private void setOutlineColumns() {
        if (this.details) {
            this.outlineView.addPropertyColumn("detailsCount", UiUtils.getText("BasicSearchResultsPanel.outline.detailsCount"));
        }
        this.outlineView.addPropertyColumn("path", UiUtils.getText("BasicSearchResultsPanel.outline.path"));
        this.outlineView.addPropertyColumn("size", UiUtils.getText("BasicSearchResultsPanel.outline.size"));
        this.outlineView.addPropertyColumn("lastModified", UiUtils.getText("BasicSearchResultsPanel.outline.lastModified"));
        this.outlineView.getOutline().setAutoResizeMode(2);
        this.columnModel = (ETableColumnModel)this.outlineView.getOutline().getColumnModel();
        Enumeration enumeration = this.columnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            this.allColumns.add((TableColumn)enumeration.nextElement());
        }
        this.loadColumnState();
        this.outlineView.setVerticalScrollBarPolicy(22);
    }

    public void update() {
        this.resultsNode.update();
    }

    private void expandOnlyChilds(Node node) {
        if (node.getChildren().getNodesCount(true) == 1) {
            Node node2 = node.getChildren().getNodeAt(0);
            this.outlineView.expandNode(node2);
            this.expandOnlyChilds(node2);
        }
    }

    private Node createNodeForMatchingObject(MatchingObject matchingObject) {
        if (matchingObject.getDataObject() == null) {
            AbstractNode abstractNode = new AbstractNode(Children.LEAF);
            abstractNode.setDisplayName("Error");
            return abstractNode;
        }
        Node node = matchingObject.getDataObject().getNodeDelegate();
        Children children = matchingObject.getTextDetails() == null || matchingObject.getTextDetails().isEmpty() ? Children.LEAF : matchingObject.getDetailsChildren(this.replacing);
        MatchingObjectNode matchingObjectNode = new MatchingObjectNode(node, children, matchingObject, this.replacing);
        this.matchingObjectNodes.add(matchingObjectNode);
        return matchingObjectNode;
    }

    public synchronized void addMatchingObject(MatchingObject matchingObject) {
        if (this.closed) {
            return;
        }
        for (FileObject fileObject : this.rootFiles) {
            if (fileObject != matchingObject.getFileObject() && !FileUtil.isParentOf((FileObject)fileObject, (FileObject)matchingObject.getFileObject())) continue;
            this.addToTreeView(this.rootPathItem, this.getRelativePath(fileObject, matchingObject.getFileObject()), matchingObject);
            return;
        }
        this.addToTreeView(this.rootPathItem, Collections.singletonList(matchingObject.getFileObject()), matchingObject);
    }

    private List<FileObject> getRelativePath(FileObject fileObject, FileObject fileObject2) {
        LinkedList<FileObject> linkedList = new LinkedList<FileObject>();
        for (FileObject fileObject3 = fileObject2; fileObject3 != null; fileObject3 = fileObject3.getParent()) {
            linkedList.add(0, fileObject3);
            if (fileObject3 == fileObject) break;
        }
        return linkedList;
    }

    private void addToTreeView(FolderTreeItem folderTreeItem, List<FileObject> list, MatchingObject matchingObject) {
        for (FolderTreeItem folderTreeItem2 : folderTreeItem.getChildren()) {
            if (folderTreeItem2.isPathLeaf() || !folderTreeItem2.getFolder().getPrimaryFile().equals(list.get(0))) continue;
            this.addToTreeView(folderTreeItem2, list.subList(1, list.size()), matchingObject);
            return;
        }
        this.createInTreeView(folderTreeItem, list, matchingObject);
    }

    private void createInTreeView(FolderTreeItem folderTreeItem, List<FileObject> list, MatchingObject matchingObject) {
        if (list.size() == 1) {
            for (FolderTreeItem folderTreeItem2 : folderTreeItem.getChildren()) {
                if (!folderTreeItem2.isPathLeaf() || !folderTreeItem2.getMatchingObject().equals(matchingObject)) continue;
                return;
            }
            folderTreeItem.addChild(new FolderTreeItem(matchingObject));
        } else {
            try {
                FolderTreeItem folderTreeItem3 = new FolderTreeItem(DataObject.find((FileObject)list.get(0)));
                folderTreeItem.addChild(folderTreeItem3);
                this.createInTreeView(folderTreeItem3, list.subList(1, list.size()), matchingObject);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
        }
    }

    public static void toggleParentSelected(Node node) {
        Node node2 = node.getParentNode();
        if (node2 == null) {
            return;
        }
        Selectable selectable = (Selectable)node2.getLookup().lookup(Selectable.class);
        if (selectable != null) {
            Node[] nodeArray = node2.getChildren().getNodes(true);
            boolean bl = false;
            for (Node node3 : nodeArray) {
                Selectable selectable2 = (Selectable)node3.getLookup().lookup(Selectable.class);
                if (selectable2 == null || !selectable2.isSelected()) continue;
                bl = true;
                break;
            }
            if (selectable.isSelected() != bl) {
                selectable.setSelected(bl);
            }
        }
    }

    public void setFolderTreeMode() {
        this.resultsNode.setFolderTreeMode();
    }

    public void setFlatMode() {
        this.resultsNode.setFlatMode();
    }

    public OutlineView getOutlineView() {
        return this.outlineView;
    }

    public Node getRootNode() {
        return this.invisibleRoot;
    }

    public Node getResultsNode() {
        return this.resultsNode;
    }

    public void setResultsNodeText(String string) {
        this.resultsNode.setHtmlAndRawDisplayName(string);
    }

    private class ColumnsListener
    implements TableColumnModelListener {
        private ColumnsListener() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            ResultsOutlineSupport.this.saveColumnState();
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            ResultsOutlineSupport.this.saveColumnState();
        }

        @Override
        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            ResultsOutlineSupport.this.saveColumnState();
        }

        @Override
        public void columnMarginChanged(ChangeEvent changeEvent) {
            ResultsOutlineSupport.this.saveColumnState();
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }
    }

    private class FolderTreeChildren
    extends Children.Keys<FolderTreeItem> {
        private FolderTreeItem item = null;

        public FolderTreeChildren(FolderTreeItem folderTreeItem) {
            this.item = folderTreeItem;
            folderTreeItem.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("children")) {
                        FolderTreeChildren.this.update();
                    }
                }
            });
        }

        protected void addNotify() {
            this.update();
        }

        void update() {
            this.setKeys(this.item.getChildren());
        }

        protected Node[] createNodes(FolderTreeItem folderTreeItem) {
            Object object = folderTreeItem.isPathLeaf() ? ResultsOutlineSupport.this.createNodeForMatchingObject(folderTreeItem.getMatchingObject()) : new FolderTreeNode(folderTreeItem);
            return new Node[]{object};
        }
    }

    private class FolderTreeNode
    extends FilterNode {
        public FolderTreeNode(FolderTreeItem folderTreeItem) {
            super(folderTreeItem.getFolder().getNodeDelegate(), (Children)new FolderTreeChildren(folderTreeItem), Lookups.fixed((Object[])new Object[]{folderTreeItem, new ReplaceCheckableNode(folderTreeItem, ResultsOutlineSupport.this.replacing), folderTreeItem.getFolder().getPrimaryFile()}));
            folderTreeItem.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    FolderTreeNode.this.fireIconChange();
                    ResultsOutlineSupport.toggleParentSelected((Node)FolderTreeNode.this);
                }
            });
            if (!folderTreeItem.isPathLeaf()) {
                this.setShortDescription(folderTreeItem.getFolder().getPrimaryFile().getPath());
            }
        }

        public PasteType[] getPasteTypes(Transferable transferable) {
            return new PasteType[0];
        }

        public PasteType getDropType(Transferable transferable, int n, int n2) {
            return null;
        }

        public Transferable drag() throws IOException {
            return UiUtils.DISABLE_TRANSFER;
        }

        public Action[] getActions(boolean bl) {
            return new Action[0];
        }
    }

    private class FolderTreeItem
    implements Selectable {
        private static final String PROP_SELECTED = "selected";
        private static final String PROP_CHILDREN = "children";
        private DataObject folder = null;
        private MatchingObject matchingObject = null;
        private List<FolderTreeItem> children = new LinkedList<FolderTreeItem>();
        private boolean selected = true;
        PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

        public FolderTreeItem() {
        }

        public FolderTreeItem(MatchingObject matchingObject) {
            this.matchingObject = matchingObject;
        }

        public FolderTreeItem(DataObject dataObject) {
            this.folder = dataObject;
        }

        void addChild(FolderTreeItem folderTreeItem) {
            this.children.add(folderTreeItem);
            this.firePropertyChange(PROP_CHILDREN, null, null);
        }

        public DataObject getFolder() {
            return this.folder;
        }

        public List<FolderTreeItem> getChildren() {
            return this.children;
        }

        public MatchingObject getMatchingObject() {
            return this.matchingObject;
        }

        public boolean isPathLeaf() {
            return this.matchingObject != null;
        }

        @Override
        public boolean isSelected() {
            return this.selected;
        }

        @Override
        public void setSelected(boolean bl) {
            if (bl == this.selected) {
                return;
            }
            this.selected = bl;
            this.firePropertyChange(PROP_SELECTED, null, null);
        }

        @Override
        public void setSelectedRecursively(boolean bl) {
            if (this.selected == bl) {
                return;
            }
            if (this.isPathLeaf()) {
                this.getMatchingObject().setSelectedRecursively(bl);
            } else {
                for (FolderTreeItem folderTreeItem : this.children) {
                    folderTreeItem.setSelectedRecursively(bl);
                }
            }
            this.setSelected(bl);
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.changeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.changeSupport.removePropertyChangeListener(propertyChangeListener);
        }

        public void firePropertyChange(String string, Object object, Object object2) {
            this.changeSupport.firePropertyChange(string, object, object2);
        }
    }

    private class FlatChildren
    extends Children.Keys<MatchingObject> {
        private FlatChildren() {
        }

        protected Node[] createNodes(MatchingObject matchingObject) {
            return new Node[]{ResultsOutlineSupport.this.createNodeForMatchingObject(matchingObject)};
        }

        private synchronized void update() {
            this.setKeys(ResultsOutlineSupport.this.resultModel.getMatchingObjects());
        }
    }

    private class ResultsNode
    extends AbstractNode {
        private FlatChildren flatChildren;
        private FolderTreeChildren folderTreeChildren;
        private String htmlDisplayName;

        public ResultsNode() {
            super((Children)new FlatChildren());
            this.htmlDisplayName = null;
            this.flatChildren = (FlatChildren)this.getChildren();
            this.folderTreeChildren = new FolderTreeChildren(ResultsOutlineSupport.this.rootPathItem);
        }

        void update() {
            this.flatChildren.update();
        }

        void setFlatMode() {
            this.setChildren((Children)this.flatChildren);
            this.expand();
        }

        void setFolderTreeMode() {
            this.setChildren((Children)this.folderTreeChildren);
            this.expand();
        }

        private void expand() {
            ResultsOutlineSupport.this.outlineView.expandNode((Node)ResultsOutlineSupport.this.resultsNode);
        }

        public Image getIcon(int n) {
            return ImageUtilities.loadImage((String)ResultsOutlineSupport.ROOT_NODE_ICON);
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }

        public Action[] getActions(boolean bl) {
            return new Action[0];
        }

        protected void createPasteTypes(Transferable transferable, List<PasteType> list) {
        }

        public void setHtmlAndRawDisplayName(String string) {
            this.htmlDisplayName = string;
            String string2 = string == null ? null : string.replaceAll("<b>", "").replaceAll("</b>", "");
            this.setDisplayName(string2);
        }

        public String getHtmlDisplayName() {
            return this.htmlDisplayName;
        }
    }

    private class ExpandingTreeExpansionListener
    implements TreeExpansionListener {
        private ExpandingTreeExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            Object object = treeExpansionEvent.getPath().getLastPathComponent();
            Node node = Visualizer.findNode((Object)object);
            if (node != null) {
                ResultsOutlineSupport.this.expandOnlyChilds(node);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        }
    }
}

