/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.search.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.search.SearchRoot;
import org.netbeans.api.search.SearchScopeOptions;
import org.netbeans.api.search.provider.SearchInfo;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.api.search.provider.impl.CompoundSearchIterator;
import org.netbeans.api.search.provider.impl.DelegatingSearchInfo;
import org.netbeans.spi.search.SearchInfoDefinition;
import org.openide.filesystems.FileObject;

public class CompoundSearchInfoDefinition
extends SearchInfoDefinition {
    private final SearchInfoDefinition[] elements;

    public CompoundSearchInfoDefinition(SearchInfoDefinition ... searchInfoDefinitionArray) {
        if (searchInfoDefinitionArray == null) {
            throw new IllegalArgumentException();
        }
        this.elements = searchInfoDefinitionArray.length != 0 ? searchInfoDefinitionArray : null;
    }

    @Override
    public boolean canSearch() {
        if (this.elements != null) {
            for (SearchInfoDefinition searchInfoDefinition : this.elements) {
                if (!searchInfoDefinition.canSearch()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<FileObject> filesToSearch(SearchScopeOptions searchScopeOptions, SearchListener searchListener, AtomicBoolean atomicBoolean) {
        if (this.elements == null) {
            return Collections.emptyList().iterator();
        }
        ArrayList<DelegatingSearchInfo> arrayList = new ArrayList<DelegatingSearchInfo>(this.elements.length);
        for (SearchInfoDefinition searchInfoDefinition : this.elements) {
            if (!searchInfoDefinition.canSearch()) continue;
            arrayList.add(new DelegatingSearchInfo(searchInfoDefinition));
        }
        return new CompoundSearchIterator(arrayList.toArray(new SearchInfo[arrayList.size()]), searchScopeOptions, searchListener, atomicBoolean);
    }

    @Override
    public List<SearchRoot> getSearchRoots() {
        LinkedList<SearchRoot> linkedList = new LinkedList<SearchRoot>();
        for (SearchInfoDefinition searchInfoDefinition : this.elements) {
            linkedList.addAll(searchInfoDefinition.getSearchRoots());
        }
        return linkedList;
    }
}

