/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.daemon;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.StatisticsImpl;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.error.ShutdownException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.IndexStatisticsDaemon;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.InterruptStatus;

public class IndexStatisticsDaemonImpl
implements IndexStatisticsDaemon,
Runnable {
    private static final boolean AS_BACKGROUND_TASK = true;
    private static final boolean AS_EXPLICIT_TASK = false;
    private static final int MAX_QUEUE_LENGTH = PropertyUtil.getSystemInt("derby.storage.indexStats.debug.queueSize", 20);
    private final HeaderPrintWriter logStream;
    private final boolean doLog;
    private final boolean doTrace;
    private final boolean traceToDerbyLog;
    private final boolean traceToStdOut;
    private boolean daemonDisabled;
    private final ContextManager ctxMgr;
    private LanguageConnectionContext daemonLCC;
    private final Database db;
    private final String dbOwner;
    private final String databaseName;
    private final ArrayList queue = new ArrayList(MAX_QUEUE_LENGTH);
    private Thread runningThread;
    private int errorsConsecutive;
    private long errorsUnknown;
    private long errorsKnown;
    private long wuProcessed;
    private long wuScheduled;
    private long wuRejectedDup;
    private long wuRejectedFQ;
    private long wuRejectedOther;
    private final long timeOfCreation;
    private long runTime;
    private final StringBuffer tsb = new StringBuffer();

    public IndexStatisticsDaemonImpl(HeaderPrintWriter headerPrintWriter, boolean bl, String string, Database database, String string2, String string3) {
        if (headerPrintWriter == null) {
            throw new IllegalArgumentException("log stream cannot be null");
        }
        this.logStream = headerPrintWriter;
        this.doLog = bl;
        this.traceToDerbyLog = string.equalsIgnoreCase("both") || string.equalsIgnoreCase("log");
        this.traceToStdOut = string.equalsIgnoreCase("both") || string.equalsIgnoreCase("stdout");
        this.doTrace = this.traceToDerbyLog || this.traceToStdOut;
        this.db = database;
        this.dbOwner = string2;
        this.databaseName = string3;
        this.ctxMgr = ContextService.getFactory().newContextManager();
        this.timeOfCreation = System.currentTimeMillis();
        this.trace(0, "created{log=" + bl + ", traceLog=" + this.traceToDerbyLog + ", traceOut=" + this.traceToStdOut + ", createThreshold=" + TableDescriptor.ISTATS_CREATE_THRESHOLD + ", absdiffThreshold=" + TableDescriptor.ISTATS_ABSDIFF_THRESHOLD + ", lndiffThreshold=" + TableDescriptor.ISTATS_LNDIFF_THRESHOLD + ", queueLength=" + MAX_QUEUE_LENGTH + "}) -> " + string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(TableDescriptor tableDescriptor) {
        String string = tableDescriptor.getIndexStatsUpdateReason();
        ArrayList arrayList = this.queue;
        synchronized (arrayList) {
            if (this.acceptWork(tableDescriptor)) {
                this.queue.add(tableDescriptor);
                ++this.wuScheduled;
                this.log(true, tableDescriptor, "update scheduled" + (string == null ? "" : ", reason=[" + string + "]") + " (queueSize=" + this.queue.size() + ")");
                if (this.runningThread == null) {
                    this.runningThread = Monitor.getMonitor().getDaemonThread(this, "index-stat-thread", false);
                    this.runningThread.start();
                }
            }
        }
    }

    private boolean acceptWork(TableDescriptor tableDescriptor) {
        String string;
        boolean bl;
        boolean bl2 = bl = !this.daemonDisabled && this.queue.size() < MAX_QUEUE_LENGTH;
        if (bl && !this.queue.isEmpty()) {
            string = tableDescriptor.getName();
            String string2 = tableDescriptor.getSchemaName();
            for (int i = 0; i < this.queue.size(); ++i) {
                TableDescriptor tableDescriptor2 = (TableDescriptor)this.queue.get(i);
                if (!tableDescriptor2.tableNameEquals(string, string2)) continue;
                bl = false;
                break;
            }
        }
        if (!bl) {
            string = tableDescriptor.getQualifiedName() + " rejected, ";
            if (this.daemonDisabled) {
                ++this.wuRejectedOther;
                string = string + "daemon disabled";
            } else if (this.queue.size() >= MAX_QUEUE_LENGTH) {
                ++this.wuRejectedFQ;
                string = string + "queue full";
            } else {
                ++this.wuRejectedDup;
                string = string + "duplicate";
            }
            this.trace(1, string);
        }
        return bl;
    }

    private void generateStatistics(LanguageConnectionContext languageConnectionContext, TableDescriptor tableDescriptor) throws StandardException {
        this.trace(1, "processing " + tableDescriptor.getQualifiedName());
        boolean bl = false;
        while (true) {
            try {
                ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
                this.updateIndexStatsMinion(languageConnectionContext, tableDescriptor, conglomerateDescriptorArray, true);
            }
            catch (StandardException standardException) {
                if (standardException.isLockTimeout() && !bl) {
                    this.trace(1, "locks unavailable, retrying");
                    bl = true;
                    languageConnectionContext.internalRollback();
                    IndexStatisticsDaemonImpl.sleep(1000L);
                    continue;
                }
                throw standardException;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isShuttingDown() {
        ArrayList arrayList = this.queue;
        synchronized (arrayList) {
            if (this.daemonDisabled || this.daemonLCC == null) {
                return true;
            }
            return !this.daemonLCC.getDatabase().isActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateIndexStatsMinion(LanguageConnectionContext languageConnectionContext, TableDescriptor tableDescriptor, ConglomerateDescriptor[] conglomerateDescriptorArray, boolean bl) throws StandardException {
        long[] lArray = new long[conglomerateDescriptorArray.length];
        ExecIndexRow[] execIndexRowArray = new ExecIndexRow[conglomerateDescriptorArray.length];
        UUID[] uUIDArray = new UUID[conglomerateDescriptorArray.length];
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        ConglomerateController conglomerateController = transactionController.openConglomerate(tableDescriptor.getHeapConglomerateId(), false, 0, 6, bl ? 1 : 4);
        try {
            for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
                if (!conglomerateDescriptorArray[i].isIndex()) {
                    lArray[i] = -1L;
                    continue;
                }
                lArray[i] = conglomerateDescriptorArray[i].getConglomerateNumber();
                uUIDArray[i] = conglomerateDescriptorArray[i].getUUID();
                execIndexRowArray[i] = conglomerateDescriptorArray[i].getIndexDescriptor().getNullIndexRow(tableDescriptor.getColumnDescriptorList(), conglomerateController.newRowLocationTemplate());
            }
        }
        finally {
            conglomerateController.close();
        }
        long[][] lArray2 = new long[lArray.length][3];
        int n = 0;
        block10: for (int i = 0; i < lArray.length; ++i) {
            int n2;
            if (lArray[i] == -1L) continue;
            if (bl && this.isShuttingDown()) break;
            lArray2[n][0] = lArray[i];
            lArray2[n][1] = System.currentTimeMillis();
            int n3 = execIndexRowArray[i].nColumns() - 1;
            long[] lArray3 = new long[n3];
            KeyComparator keyComparator = new KeyComparator(execIndexRowArray[i]);
            GroupFetchScanController groupFetchScanController = transactionController.openGroupFetchScan(lArray[i], false, 0, 6, 1, null, null, 0, null, null, 0);
            try {
                n2 = 0;
                boolean bl2 = false;
                while ((n2 = keyComparator.fetchRows(groupFetchScanController)) > 0) {
                    if (bl && this.isShuttingDown()) {
                        bl2 = true;
                        break;
                    }
                    for (int j = 0; j < n2; ++j) {
                        int n4 = keyComparator.compareWithPrevKey(j);
                        if (n4 < 0) continue;
                        int n5 = n4;
                        while (n5 < n3) {
                            int n6 = n5++;
                            lArray3[n6] = lArray3[n6] + 1L;
                        }
                    }
                }
                if (bl2) break;
                groupFetchScanController.setEstimatedRowCount(keyComparator.getRowCount());
            }
            finally {
                groupFetchScanController.close();
                groupFetchScanController = null;
            }
            lArray2[n++][2] = System.currentTimeMillis();
            n2 = 0;
            while (true) {
                try {
                    this.writeUpdatedStats(languageConnectionContext, tableDescriptor, uUIDArray[i], keyComparator.getRowCount(), lArray3, bl);
                    continue block10;
                }
                catch (StandardException standardException) {
                    if (standardException.isLockTimeout() && ++n2 < 3) {
                        this.trace(2, "lock timeout when writing stats, retrying");
                        IndexStatisticsDaemonImpl.sleep(100 * n2);
                        continue;
                    }
                    throw standardException;
                }
                break;
            }
        }
        this.log(bl, tableDescriptor, IndexStatisticsDaemonImpl.fmtScanTimes(lArray2));
    }

    private void writeUpdatedStats(LanguageConnectionContext languageConnectionContext, TableDescriptor tableDescriptor, UUID uUID, long l, long[] lArray, boolean bl) throws StandardException {
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        this.trace(1, "writing new stats (xid=" + transactionController.getTransactionIdString() + ")");
        UUID uUID2 = tableDescriptor.getUUID();
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        UUIDFactory uUIDFactory = dataDictionary.getUUIDFactory();
        this.setHeapRowEstimate(transactionController, tableDescriptor.getHeapConglomerateId(), l);
        this.invalidateStatements(languageConnectionContext, tableDescriptor, bl);
        dataDictionary.dropStatisticsDescriptors(uUID2, uUID, transactionController);
        if (l == 0L) {
            this.trace(2, "empty table, no stats written");
        } else {
            for (int i = 0; i < lArray.length; ++i) {
                StatisticsDescriptor statisticsDescriptor = new StatisticsDescriptor(dataDictionary, uUIDFactory.createUUID(), uUID, uUID2, "I", new StatisticsImpl(l, lArray[i]), i + 1);
                dataDictionary.addDescriptor(statisticsDescriptor, null, 14, true, transactionController);
            }
            ConglomerateDescriptor conglomerateDescriptor = dataDictionary.getConglomerateDescriptor(uUID);
            this.log(bl, tableDescriptor, "wrote stats for index " + (conglomerateDescriptor == null ? "n/a" : conglomerateDescriptor.getDescriptorName()) + " (" + uUID + "): rows=" + l + ", card=" + IndexStatisticsDaemonImpl.cardToStr(lArray));
            if (bl && conglomerateDescriptor == null) {
                this.log(bl, tableDescriptor, "rolled back index stats because index has been dropped");
                languageConnectionContext.internalRollback();
            }
        }
        if (bl) {
            languageConnectionContext.internalCommit(true);
        }
    }

    private void invalidateStatements(LanguageConnectionContext languageConnectionContext, TableDescriptor tableDescriptor, boolean bl) throws StandardException {
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        DependencyManager dependencyManager = dataDictionary.getDependencyManager();
        boolean bl2 = false;
        int n = 0;
        while (true) {
            try {
                if (!bl2) {
                    dataDictionary.startWriting(languageConnectionContext);
                    bl2 = true;
                }
                dependencyManager.invalidateFor(tableDescriptor, 40, languageConnectionContext);
                this.trace(1, "invalidation completed");
            }
            catch (StandardException standardException) {
                if (standardException.isLockTimeout() && bl && n < 3) {
                    if (++n > 1) {
                        this.trace(2, "releasing locks");
                        languageConnectionContext.internalRollback();
                        bl2 = false;
                    }
                    this.trace(2, "lock timeout when invalidating");
                    IndexStatisticsDaemonImpl.sleep(100 * (1 + n));
                    continue;
                }
                this.trace(1, "invalidation failed");
                throw standardException;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHeapRowEstimate(TransactionController transactionController, long l, long l2) throws StandardException {
        ScanController scanController = transactionController.openScan(l, false, 0, 6, 1, null, null, 0, null, null, 0);
        try {
            scanController.setEstimatedRowCount(l2);
        }
        finally {
            scanController.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long l = System.currentTimeMillis();
        ContextService contextService = null;
        try {
            contextService = ContextService.getFactory();
            contextService.setCurrentContextManager(this.ctxMgr);
            this.processingLoop();
        }
        catch (ShutdownException shutdownException) {
            this.trace(1, "swallowed shutdown exception: " + IndexStatisticsDaemonImpl.extractIstatInfo(shutdownException));
            this.stop();
            this.ctxMgr.cleanupOnError(shutdownException, this.db.isActive());
        }
        catch (RuntimeException runtimeException) {
            if (!this.isShuttingDown()) {
                this.log(true, null, runtimeException, "runtime exception during normal operation");
                throw runtimeException;
            }
            this.trace(1, "swallowed runtime exception during shutdown: " + IndexStatisticsDaemonImpl.extractIstatInfo(runtimeException));
        }
        finally {
            if (contextService != null) {
                contextService.resetCurrentContextManager(this.ctxMgr);
            }
            this.runTime += System.currentTimeMillis() - l;
            this.trace(0, "worker thread exit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void processingLoop() {
        block48: {
            if (this.daemonLCC == null) {
                try {
                    this.daemonLCC = this.db.setupConnection(this.ctxMgr, this.dbOwner, null, this.databaseName);
                    this.daemonLCC.setIsolationLevel(1);
                    this.daemonLCC.getTransactionExecute().setNoLockWait(true);
                }
                catch (StandardException var1_1) {
                    this.log(true, null, var1_1, "failed to initialize index statistics updater");
                    return;
                }
            }
            var1_2 = null;
            try {
                var1_2 = this.daemonLCC.getTransactionExecute();
                this.trace(0, "worker thread started (xid=" + var1_2.getTransactionIdString() + ")");
                var2_3 = null;
                var3_8 = 0L;
                while (true) lbl-1000:
                // 5 sources

                {
                    var5_9 = this.queue;
                    synchronized (var5_9) {
                        if (this.daemonDisabled) {
                            try {
                                var1_2.destroy();
                            }
                            catch (ShutdownException var6_12) {
                                // empty catch block
                            }
                            var1_2 = null;
                            this.daemonLCC = null;
                            this.queue.clear();
                            this.trace(1, "daemon disabled");
                            break block48;
                        }
                        if (this.queue.isEmpty()) {
                            this.trace(1, "queue empty");
                            break block48;
                        }
                        var2_3 = (TableDescriptor)this.queue.get(0);
                    }
                    try {
                        var3_8 = System.currentTimeMillis();
                        this.generateStatistics(this.daemonLCC, (TableDescriptor)var2_3);
                        ++this.wuProcessed;
                        this.errorsConsecutive = 0;
                        this.log(true, (TableDescriptor)var2_3, "generation complete (" + (System.currentTimeMillis() - var3_8) + " ms)");
                    }
                    catch (StandardException var5_10) {
                        ++this.errorsConsecutive;
                        if (this.handleFatalErrors(this.ctxMgr, var5_10)) ** GOTO lbl-1000
                        var6_11 = this.handleExpectedErrors((TableDescriptor)var2_3, var5_10);
                        if (!var6_11) {
                            var6_11 = this.handleUnexpectedErrors((TableDescriptor)var2_3, var5_10);
                        }
                        this.daemonLCC.internalRollback();
                    }
                    finally {
                        var5_9 = this.queue;
                        synchronized (var5_9) {
                            if (!this.queue.isEmpty()) {
                                this.queue.remove(0);
                            }
                        }
                        if (this.errorsConsecutive < 50) continue;
                        this.log(true, null, new IllegalStateException("degraded state"), "shutting down daemon, " + this.errorsConsecutive + " consecutive errors seen");
                        this.stop();
                        continue;
                    }
                    break;
                }
            }
            catch (StandardException var2_5) {
                this.log(true, null, var2_5, "thread died");
                break block48;
            }
            finally {
                var2_6 = this.queue;
                synchronized (var2_6) {
                    this.runningThread = null;
                }
                if (this.daemonLCC != null && !this.daemonLCC.isTransactionPristine()) {
                    this.log(true, null, "transaction not pristine - forcing rollback");
                    try {
                        this.daemonLCC.internalRollback();
                    }
                    catch (StandardException var2_7) {
                        this.log(true, null, var2_7, "forced rollback failed");
                    }
                }
            }
            ** GOTO lbl-1000
        }
    }

    public void runExplicitly(LanguageConnectionContext languageConnectionContext, TableDescriptor tableDescriptor, ConglomerateDescriptor[] conglomerateDescriptorArray, String string) throws StandardException {
        this.updateIndexStatsMinion(languageConnectionContext, tableDescriptor, conglomerateDescriptorArray, false);
        this.trace(0, "explicit run completed" + (string != null ? " (" + string + "): " : ": ") + tableDescriptor.getQualifiedName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Thread thread = null;
        boolean bl = false;
        ArrayList arrayList = this.queue;
        synchronized (arrayList) {
            if (!this.daemonDisabled) {
                bl = true;
                StringBuffer stringBuffer = new StringBuffer(100);
                stringBuffer.append("stopping daemon, active=").append(this.runningThread != null).append(", work/age=").append(this.runTime).append('/').append(System.currentTimeMillis() - this.timeOfCreation).append(' ');
                this.appendRunStats(stringBuffer);
                this.log(true, null, stringBuffer.toString());
                if (this.runningThread == null && this.daemonLCC != null && !this.isShuttingDown()) {
                    try {
                        this.daemonLCC.getTransactionExecute().destroy();
                    }
                    catch (ShutdownException shutdownException) {
                        // empty catch block
                    }
                    this.daemonLCC = null;
                }
                this.daemonDisabled = true;
                thread = this.runningThread;
                this.runningThread = null;
                this.queue.clear();
            }
        }
        if (thread != null) {
            while (true) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    InterruptStatus.setInterrupted();
                    continue;
                }
                break;
            }
        }
        if (bl) {
            this.ctxMgr.cleanupOnError(StandardException.normalClose(), false);
        }
    }

    private boolean handleFatalErrors(ContextManager contextManager, StandardException standardException) {
        boolean bl = false;
        if ("40XD1".equals(standardException.getMessageId())) {
            bl = true;
        } else if (this.isShuttingDown() || standardException.getSeverity() >= 45000) {
            this.trace(1, "swallowed exception during shutdown: " + IndexStatisticsDaemonImpl.extractIstatInfo(standardException));
            bl = true;
            contextManager.cleanupOnError(standardException, this.db.isActive());
        }
        if (bl) {
            this.daemonLCC.getDataDictionary().disableIndexStatsRefresher();
        }
        return bl;
    }

    private boolean handleExpectedErrors(TableDescriptor tableDescriptor, StandardException standardException) {
        String string = standardException.getMessageId();
        if ("XSAI2.S".equals(string) || "XSCH1.S".equals(string) || "XSDG9.D".equals(string) || standardException.isLockTimeout()) {
            ++this.errorsKnown;
            this.log(true, tableDescriptor, "generation aborted (reason: " + string + ") {" + IndexStatisticsDaemonImpl.extractIstatInfo(standardException) + "}");
            return true;
        }
        return false;
    }

    private boolean handleUnexpectedErrors(TableDescriptor tableDescriptor, StandardException standardException) {
        ++this.errorsUnknown;
        this.log(true, tableDescriptor, standardException, "generation failed");
        return true;
    }

    private static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            InterruptStatus.setInterrupted();
        }
    }

    private static String fmtScanTimes(long[][] lArray) {
        StringBuffer stringBuffer = new StringBuffer("scan durations (");
        for (int i = 0; i < lArray.length && lArray[i][0] > 0L; ++i) {
            stringBuffer.append('c').append(lArray[i][0]).append('=');
            if (lArray[i][2] == 0L) {
                stringBuffer.append("ABORTED,");
                continue;
            }
            long l = lArray[i][2] - lArray[i][1];
            stringBuffer.append(l).append("ms,");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1).append(")");
        return stringBuffer.toString();
    }

    private void log(boolean bl, TableDescriptor tableDescriptor, String string) {
        this.log(bl, tableDescriptor, null, string);
    }

    private void log(boolean bl, TableDescriptor tableDescriptor, Throwable throwable, String string) {
        if (bl && (this.doLog || throwable != null)) {
            PrintWriter printWriter = null;
            String string2 = "{istat} " + (tableDescriptor == null ? "" : tableDescriptor.getQualifiedName() + ": ") + string;
            if (throwable != null) {
                printWriter = new PrintWriter((Writer)this.logStream.getPrintWriter(), false);
                printWriter.print(this.logStream.getHeader().getHeader());
                printWriter.println(string2);
                throwable.printStackTrace(printWriter);
                printWriter.flush();
            } else {
                this.logStream.printlnWithHeader(string2);
            }
        }
    }

    private synchronized void trace(int n, String string) {
        if (this.doTrace) {
            this.tsb.setLength(0);
            this.tsb.append("{istat,trace@").append(this.hashCode()).append("} ");
            for (int i = 0; i < n; ++i) {
                this.tsb.append("    ");
            }
            this.tsb.append(string).append(' ');
            if (n == 0) {
                this.appendRunStats(this.tsb);
            }
            if (this.traceToDerbyLog && this.logStream != null) {
                this.logStream.printlnWithHeader(this.tsb.toString());
            }
            if (this.traceToStdOut) {
                System.out.println(this.tsb.toString());
            }
        }
    }

    private void appendRunStats(StringBuffer stringBuffer) {
        stringBuffer.append("[q/p/s=").append(this.queue.size()).append('/').append(this.wuProcessed).append('/').append(this.wuScheduled).append(",err:k/u/c=").append(this.errorsKnown).append('/').append(this.errorsUnknown).append('/').append(this.errorsConsecutive).append(",rej:f/d/o=").append(this.wuRejectedFQ).append('/').append(this.wuRejectedDup).append('/').append(this.wuRejectedOther).append(']');
    }

    private static String cardToStr(long[] lArray) {
        if (lArray.length == 1) {
            return "[" + Long.toString(lArray[0]) + "]";
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < lArray.length; ++i) {
            stringBuffer.append(lArray[i]).append(',');
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1).append(']');
        return stringBuffer.toString();
    }

    private static String extractIstatInfo(Throwable throwable) {
        String string = IndexStatisticsDaemonImpl.class.getName();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        String string2 = "<no stacktrace>";
        String string3 = "";
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            if (!stackTraceElement.getClassName().startsWith(string)) continue;
            string2 = stackTraceElement.getMethodName() + "#" + stackTraceElement.getLineNumber();
            if (i <= 0) break;
            stackTraceElement = stackTraceElementArray[i - 1];
            string2 = string2 + " -> " + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + "#" + stackTraceElement.getLineNumber();
            break;
        }
        if (throwable instanceof StandardException) {
            string3 = ", SQLSTate=" + ((StandardException)throwable).getSQLState();
        }
        return "<" + throwable.getClass() + ", msg=" + throwable.getMessage() + string3 + "> " + string2;
    }

    private static class KeyComparator {
        private static final int FETCH_SIZE = 16;
        private final DataValueDescriptor[][] rowBufferArray = new DataValueDescriptor[16][];
        private DataValueDescriptor[] lastUniqueKey;
        private DataValueDescriptor[] curr;
        private DataValueDescriptor[] prev;
        private int rowsReadLastRead = -1;
        private long numRows;

        public KeyComparator(ExecIndexRow execIndexRow) {
            this.rowBufferArray[0] = execIndexRow.getRowArray();
            this.lastUniqueKey = execIndexRow.getRowArrayClone();
        }

        public int fetchRows(GroupFetchScanController groupFetchScanController) throws StandardException {
            if (this.rowsReadLastRead == 16) {
                this.curr = this.rowBufferArray[15];
                this.rowBufferArray[15] = this.lastUniqueKey;
                this.lastUniqueKey = this.curr;
            }
            this.rowsReadLastRead = groupFetchScanController.fetchNextGroup(this.rowBufferArray, null);
            return this.rowsReadLastRead;
        }

        public int compareWithPrevKey(int n) throws StandardException {
            if (n > this.rowsReadLastRead) {
                throw new IllegalStateException("invalid access, rowsReadLastRead=" + this.rowsReadLastRead + ", index=" + n + ", numRows=" + this.numRows);
            }
            ++this.numRows;
            if (this.numRows == 1L) {
                return 0;
            }
            this.prev = n == 0 ? this.lastUniqueKey : this.rowBufferArray[n - 1];
            this.curr = this.rowBufferArray[n];
            for (int i = 0; i < this.prev.length - 1; ++i) {
                DataValueDescriptor dataValueDescriptor = this.prev[i];
                if (!dataValueDescriptor.isNull() && this.prev[i].compare(this.curr[i]) == 0) continue;
                return i;
            }
            return -1;
        }

        public long getRowCount() {
            return this.numRows;
        }
    }
}

