/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml;

import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.IXMLValidator;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.JFCGrammar;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLAttribute;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLAttributeInstance;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLNodeType;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLTag;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLTagInstance;
import com.jrockit.mc.flightrecorder.controlpanel.ui.configuration.model.xml.XMLValidationResult;
import com.jrockit.mc.ui.UIPlugin;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public final class JFCXMLValidator
implements IXMLValidator {
    private static final JFCXMLValidator SHARED = new JFCXMLValidator();

    public static IXMLValidator getValidator() {
        return SHARED;
    }

    private JFCXMLValidator() {
    }

    @Override
    public List<XMLValidationResult> validate(XMLModel model) {
        UIPlugin.getDefault().getLogger().log(Level.FINE, "Running JFC validation on " + model.getRoot().getValue(JFCGrammar.ATTRIBUTE_NAME));
        ArrayList<XMLValidationResult> errors = new ArrayList<XMLValidationResult>();
        XMLTagInstance configuration = model.getRoot();
        List<XMLTagInstance> producers = configuration.getTagsInstances(JFCGrammar.TAG_PRODUCER);
        this.collectErrors(null, configuration, new MissingChild(), errors);
        this.collectErrors(null, configuration, new InvalidAttribute(), errors);
        Set<String> qualifiedVariableNames = JFCXMLValidator.createQualifiedVariableSet(producers, JFCGrammar.ATTRIBUTE_URI);
        for (XMLTagInstance producer : producers) {
            URI producerURI = JFCXMLValidator.createTrailingSlashURI(producer.getValue(JFCGrammar.ATTRIBUTE_URI));
            this.collectErrors(null, producer, new DuplicateDefinition(), errors);
            this.collectErrors(null, producer, new DanglingReference(qualifiedVariableNames, producerURI), errors);
        }
        return errors;
    }

    private void collectErrors(Object parent, Object o, IXMLNodeValidator validator, List<XMLValidationResult> result) {
        result.add(validator.validate(parent, o));
        if (o instanceof XMLTagInstance) {
            XMLTagInstance t = (XMLTagInstance)o;
            for (XMLTagInstance xMLTagInstance : t.getTagsInstances()) {
                this.collectErrors(o, xMLTagInstance, validator, result);
            }
            for (XMLAttributeInstance xMLAttributeInstance : t.getAttributeInstances()) {
                this.collectErrors(o, xMLAttributeInstance, validator, result);
            }
        }
    }

    public static Set<String> createQualifiedVariableSet(List<XMLTagInstance> rootElements, XMLAttribute baseUriAttribute) {
        ArrayList<String> variables = new ArrayList<String>();
        for (XMLTagInstance rootElement : rootElements) {
            URI baseURI = JFCXMLValidator.createTrailingSlashURI(rootElement.getValue(baseUriAttribute));
            LinkedList<Object> q = new LinkedList<Object>();
            q.add(rootElement);
            while (!q.isEmpty()) {
                String value;
                XMLAttributeInstance ai;
                Object o = q.poll();
                if (o instanceof XMLTagInstance) {
                    for (XMLTagInstance tagInstance : ((XMLTagInstance)o).getTagsInstances()) {
                        q.add(tagInstance);
                    }
                    for (XMLAttributeInstance attributeInstance : ((XMLTagInstance)o).getAttributeInstances()) {
                        q.add(attributeInstance);
                    }
                }
                if (!(o instanceof XMLAttributeInstance) || (ai = (XMLAttributeInstance)o).getAttribute().getType() != XMLNodeType.DEFINITION || (value = ai.getValue()).trim().isEmpty()) continue;
                String variableName = baseURI.resolve(value).toString();
                variables.add(variableName);
            }
        }
        Collections.sort(variables);
        return new LinkedHashSet<String>(variables);
    }

    @Override
    public XMLTag getRootElementType() {
        return JFCGrammar.ROOT;
    }

    @Override
    public Set<XMLTag> getElementsTooKeepOnOneLine() {
        return JFCGrammar.ONE_LINE_ELEMENTS;
    }

    private static URI createTrailingSlashURI(String uri) {
        if (uri.endsWith("/")) {
            return URI.create(uri);
        }
        return URI.create(String.valueOf(uri) + '/');
    }

    private static class DanglingReference
    implements IXMLNodeValidator {
        private final Set<String> m_variableNames;
        private final URI m_baseURI;

        DanglingReference(Set<String> variableNames, URI baseURI) {
            this.m_variableNames = variableNames;
            this.m_baseURI = baseURI;
        }

        @Override
        public XMLValidationResult validate(Object parentNode, Object node) {
            String variableName;
            XMLAttributeInstance i;
            if (node instanceof XMLAttributeInstance && (i = (XMLAttributeInstance)node).getAttribute().getType() == XMLNodeType.REFERENCE && !(variableName = i.getValue()).isEmpty() && !this.m_variableNames.contains(variableName = this.m_baseURI.resolve(variableName).toString())) {
                return new XMLValidationResult(i, "Variable '" + variableName + "' can't be found.", true);
            }
            return XMLValidationResult.OK;
        }
    }

    private static class DuplicateDefinition
    implements IXMLNodeValidator {
        private Set<String> m_variables = new HashSet<String>();

        private DuplicateDefinition() {
        }

        @Override
        public XMLValidationResult validate(Object parentNode, Object node) {
            XMLAttributeInstance i;
            if (node instanceof XMLAttributeInstance && (i = (XMLAttributeInstance)node).getAttribute().getType() == XMLNodeType.DEFINITION) {
                XMLTagInstance parent;
                if (parentNode instanceof XMLTagInstance && (parent = (XMLTagInstance)parentNode).getTag() == JFCGrammar.TAG_CONDITION) {
                    return XMLValidationResult.OK;
                }
                String name = i.getValue();
                if (this.m_variables.contains(name)) {
                    return new XMLValidationResult(i, "Variable '" + name + "' is defined more than once.", true);
                }
                this.m_variables.add(i.getValue());
            }
            return XMLValidationResult.OK;
        }
    }

    static interface IXMLNodeValidator {
        public XMLValidationResult validate(Object var1, Object var2);
    }

    private static class InvalidAttribute
    implements IXMLNodeValidator {
        private InvalidAttribute() {
        }

        @Override
        public XMLValidationResult validate(Object parentNode, Object node) {
            if (node instanceof XMLAttributeInstance) {
                XMLAttributeInstance instance = (XMLAttributeInstance)node;
                XMLAttribute attribute = instance.getAttribute();
                if (attribute.isRequired() && instance.isImplicitDefault()) {
                    return new XMLValidationResult(instance, "'" + instance.getAttribute().getName() + "' is missing content.", true);
                }
                Collection<String> validValues = attribute.getValidValues();
                if (!validValues.isEmpty() && !validValues.contains(instance.getValue().toLowerCase())) {
                    StringBuilder textBuf = new StringBuilder("Attribute '");
                    textBuf.append(instance.getAttribute().getName());
                    textBuf.append("' must have one of these values: \"");
                    Iterator<String> values = validValues.iterator();
                    while (values.hasNext()) {
                        textBuf.append(values.next());
                        if (!values.hasNext()) continue;
                        textBuf.append("\", \"");
                    }
                    textBuf.append("\".");
                    return new XMLValidationResult(instance, textBuf.toString(), true);
                }
            }
            return XMLValidationResult.OK;
        }
    }

    private static class MissingChild
    implements IXMLNodeValidator {
        private MissingChild() {
        }

        @Override
        public XMLValidationResult validate(Object parentNode, Object node) {
            XMLTagInstance i;
            if (node instanceof XMLTagInstance && (i = (XMLTagInstance)node).getTag().getType() == XMLNodeType.ELEMENT_WITH_AT_LEAST_ONE_CHILD && i.getTagsInstances().isEmpty()) {
                return new XMLValidationResult(i, String.valueOf(i.getTag().getName()) + " must have at least on child element.", true);
            }
            return XMLValidationResult.OK;
        }
    }
}

