/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.actions;

import com.jrockit.mc.common.IUserAction;
import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.flightrecorder.controlpanel.ui.RecordingProvider;
import com.jrockit.mc.rjmx.ConnectionException;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.CouldNotCreateServiceException;
import com.jrockit.mc.rjmx.services.flr.EventTypeMetadata;
import com.jrockit.mc.rjmx.services.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.services.flr.IConvertibleValue;
import com.jrockit.mc.rjmx.services.flr.IEventSettingsHolder;
import com.jrockit.mc.rjmx.services.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.services.flr.IRecordingDescriptor;
import com.jrockit.mc.ui.misc.IGraphical;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;

public class PrintRecordingDescriptorAction
implements IUserAction,
IGraphical {
    private static final String NORMAL_INDENT = "  ";
    private final IRecordingDescriptor recording;
    private IFlightRecorderService flightRecorderService;
    private RecordingProvider rec;

    public PrintRecordingDescriptorAction(RecordingProvider recording) {
        this.rec = recording;
        this.recording = recording.getRecordingDescriptor();
    }

    private PrintStream createNewOutputStream() {
        PrintStream newOut = null;
        try {
            String fileName = System.getProperty("com.jrockit.mc.flightrecorder.controlpanel.ui.printRecordingFileName");
            if (fileName != null) {
                newOut = new PrintStream(new FileOutputStream(fileName));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return newOut;
    }

    private void printRecordingInfo(PrintStream stream) {
        this.printRecordingInfo(new PrintWriter(stream));
    }

    private void printRecordingInfo(PrintWriter writer) {
        try {
            this.printDivider(writer);
            this.printRecordingDescriptor(writer);
            this.printRecordingOptions(writer);
            this.printEventSettings(writer);
            this.printAvailableRecordingOptions(writer);
            this.printAvailableEventTypes(writer);
            this.printCurrentEventTypeSettings(writer);
            this.printDivider(writer);
            writer.flush();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void printDivider(PrintWriter writer) {
        writer.println("============================================================");
    }

    private void printRecordingDescriptor(PrintWriter writer) {
        writer.printf("id=%d%n", this.recording.getId());
        writer.printf("name=%s%n", this.recording.getName());
        writer.printf("state=%s%n", this.recording.getState());
        writer.printf("options=%n", new Object[0]);
        for (Map.Entry entry : this.recording.getOptions().entrySet()) {
            writer.printf("\t%s=%s%s%n", entry.getKey(), entry.getValue(), entry.getValue() != null ? NLS.bind((String)" ({0})", entry.getValue().getClass()) : "");
        }
        writer.printf("objectName=%s%n", this.recording.getObjectName());
        writer.printf("dataStartTime=%tc%n", this.recording.getDataStartTime());
        writer.printf("dataEndTime=%tc%n", this.recording.getDataEndTime());
    }

    private void printRecordingOptions(PrintWriter writer) throws FlightRecorderException, IllegalArgumentException, CouldNotCreateServiceException, ConnectionException {
        Map recordingOptions = this.flightRecorderService.getRecordingOptions(this.recording);
        writer.printf("getRecordingOptions(recordingDescriptor)=%n", new Object[0]);
        for (Map.Entry entry : recordingOptions.entrySet()) {
            writer.printf("\t%s=%n\t\t%s%n", entry.getKey(), this.toString((IConvertibleValue)entry.getValue(), "\t\t"));
        }
    }

    private void printEventSettings(PrintWriter writer) throws FlightRecorderException {
        IEventSettingsHolder eventTypeSettings = this.flightRecorderService.getEventSettings(this.recording);
        TreeMap optionMap = new TreeMap(eventTypeSettings.getEventOptions());
        writer.printf("getEventSettings(recordingDescriptor)=%n", new Object[0]);
        for (Map.Entry entry : optionMap.entrySet()) {
            writer.printf("\t%s=%n\t\t%s%n", entry.getKey(), this.toString((IConvertibleValue)entry.getValue(), "\t\t"));
        }
    }

    private void printAvailableRecordingOptions(PrintWriter writer) throws FlightRecorderException {
        Map optionDescriptors = this.flightRecorderService.getAvailableRecordingOptions();
        writer.printf("getAvailableRecordingOptions()=%n", new Object[0]);
        for (Map.Entry entry : optionDescriptors.entrySet()) {
            writer.printf("\t%s=\t%s%n", entry.getKey(), entry.getValue());
        }
    }

    private void printAvailableEventTypes(PrintWriter writer) throws FlightRecorderException {
        writer.printf("getAvailableEventTypes()=%n", new Object[0]);
        int i = 0;
        for (EventTypeMetadata eventType : this.flightRecorderService.getAvailableEventTypes()) {
            writer.printf("\t[%d]\t%s%n", i++, this.toString(eventType, "\t\t"));
        }
    }

    private void printCurrentEventTypeSettings(PrintWriter writer) throws FlightRecorderException {
        IEventSettingsHolder eventTypeSettings = this.flightRecorderService.getCurrentEventTypeSettings();
        TreeMap optionMap = new TreeMap(eventTypeSettings.getEventOptions());
        writer.printf("getCurrentEventTypeSettings()=%n", new Object[0]);
        for (Map.Entry entry : optionMap.entrySet()) {
            writer.printf("\t%s=%n\t\t%s%n", entry.getKey(), this.toString((IConvertibleValue)entry.getValue(), "\t\t"));
        }
    }

    private String toString(EventTypeMetadata eventTypeMetadata, String indent) {
        indent = String.valueOf(indent) + NORMAL_INDENT;
        return NLS.bind((String)"EventTypeMetadata[\n{0}path={1},\n{0}id={2},\n{0}uri={3},\n{0}options={4}]", (Object[])new Object[]{indent, eventTypeMetadata.getPath(), eventTypeMetadata.getId(), eventTypeMetadata.getEventURI(), eventTypeMetadata.getCapabilities()});
    }

    private String toString(IConvertibleValue<?> value, String indent) {
        indent = String.valueOf(indent) + NORMAL_INDENT;
        return NLS.bind((String)"IConvertibleValue[\n{0}serverValue={1},\n{0}configStringValue={2},\n{0}constraint={3}]", (Object[])new Object[]{indent, value.toServerOpenType(), value.toConfigString(), value.getConstraint()});
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return "Print";
    }

    public String getDescription() {
        return null;
    }

    /*
     * Loose catch block
     */
    public void execute() {
        block10: {
            PrintStream oldOut = System.err;
            PrintStream newOut = null;
            IConnectionHandle handle = null;
            try {
                handle = this.rec.getServerHandle().connect("Print Recording Info");
                this.flightRecorderService = (IFlightRecorderService)handle.getServiceOrDummy(IFlightRecorderService.class);
                newOut = this.createNewOutputStream();
                if (newOut != null) {
                    System.setErr(newOut);
                    this.printRecordingInfo(newOut);
                    System.setErr(oldOut);
                } else {
                    this.printRecordingInfo(System.err);
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                IOToolkit.closeSilently((Closeable)handle);
                IOToolkit.closeSilently(newOut);
                break block10;
            }
            catch (CouldNotCreateServiceException e) {
                e.printStackTrace();
                IOToolkit.closeSilently((Closeable)handle);
                IOToolkit.closeSilently(newOut);
                break block10;
            }
            catch (ConnectionException e) {
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        IOToolkit.closeSilently(handle);
                        IOToolkit.closeSilently(newOut);
                        throw throwable;
                    }
                }
                IOToolkit.closeSilently((Closeable)handle);
                IOToolkit.closeSilently(newOut);
                break block10;
            }
            IOToolkit.closeSilently((Closeable)handle);
            IOToolkit.closeSilently((Closeable)newOut);
        }
    }
}

