/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.actions;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.RecordingProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.services.flr.IRecordingDescriptor;
import com.jrockit.mc.ui.misc.AbstractWarningAction;
import com.jrockit.mc.ui.misc.DialogToolkit;
import java.io.Closeable;
import java.util.logging.Level;
import org.eclipse.osgi.util.NLS;

public class StopRecordingAction
extends AbstractWarningAction {
    private final RecordingProvider recording;

    public StopRecordingAction(RecordingProvider recording) {
        super(Messages.ACTION_STOP_RECORDING_LABEL, Messages.ACTION_STOP_RECORDING_TOOLTIP, ControlPanel.getDefault().getMCImageDescriptor("FLR_finished.gif"));
        this.recording = recording;
    }

    private boolean okToStopDefaultRecording() {
        return DialogToolkit.openQuestionOnUiThread((String)Messages.STOP_RECORDING_TITLE, (String)NLS.bind((String)Messages.STOP_RECORDING_MSG, (Object)this.recording.getRecordingDescriptor().getName()));
    }

    public void doExecute() {
        block6: {
            IRecordingDescriptor recordingDescriptor = this.recording.getRecordingDescriptor();
            if (recordingDescriptor.getId() != 0L || this.okToStopDefaultRecording()) {
                IConnectionHandle connection = null;
                try {
                    try {
                        connection = this.recording.getServerHandle().connect(Messages.ACTION_STOP_RECORDING_TOOLTIP);
                        ((IFlightRecorderService)connection.getServiceOrThrow(IFlightRecorderService.class)).stop(recordingDescriptor);
                    }
                    catch (Exception e) {
                        ControlPanel.getDefault().getLogger().log(Level.SEVERE, "Could not stop recording.");
                        IOToolkit.closeSilently((Closeable)connection);
                        break block6;
                    }
                }
                catch (Throwable throwable) {
                    IOToolkit.closeSilently(connection);
                    throw throwable;
                }
                IOToolkit.closeSilently((Closeable)connection);
            }
        }
    }
}

