/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.jobs;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.core.StatusFactory;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.FlightRecorderProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.RecordingProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.IServerHandle;
import com.jrockit.mc.rjmx.services.flr.IEventSettingsHolder;
import com.jrockit.mc.rjmx.services.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.services.flr.IRecordingDescriptor;
import java.io.Closeable;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public final class StartRecordingJob
extends Job {
    private final Map<String, ?> m_recordingOptions;
    private final IEventSettingsHolder m_recordingSettings;
    private final MCFile m_path;
    private final FlightRecorderProvider m_recorder;
    private volatile boolean m_canceling;

    public StartRecordingJob(FlightRecorderProvider recorder, String name, Map<String, ?> recordingOptions, IEventSettingsHolder recordingSettings, MCFile path) {
        super(NLS.bind((String)Messages.RECORDING_JOB_NAME, (Object)name));
        this.m_recordingOptions = recordingOptions;
        this.m_recordingSettings = recordingSettings;
        this.m_path = path;
        this.m_recorder = recorder;
    }

    protected void canceling() {
        this.m_canceling = true;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IStatus iStatus;
        IRecordingDescriptor startedRecording;
        String connectionName;
        IConnectionHandle connection;
        block6: {
            connection = null;
            connectionName = null;
            startedRecording = null;
            connectionName = this.m_recorder.getServerHandle().getServerDescriptor().getDisplayName();
            connection = this.m_recorder.getServerHandle().connect(this.getName());
            IFlightRecorderService flightRecorderService = (IFlightRecorderService)connection.getServiceOrThrow(IFlightRecorderService.class);
            startedRecording = flightRecorderService.start(this.m_recordingOptions, this.m_recordingSettings);
            if (startedRecording.isContinuous()) break block6;
            IStatus iStatus2 = this.monitorRecording(startedRecording, monitor, connection, flightRecorderService);
            IOToolkit.closeSilently((Closeable)connection);
            return iStatus2;
        }
        try {
            iStatus = Status.OK_STATUS;
        }
        catch (Exception e) {
            block7: {
                IStatus iStatus3;
                try {
                    IServerHandle.State state = this.m_recorder.getServerHandle().getState();
                    if (state != IServerHandle.State.DISPOSED) break block7;
                    iStatus3 = Status.OK_STATUS;
                }
                catch (Throwable throwable) {
                    IOToolkit.closeSilently(connection);
                    throw throwable;
                }
                IOToolkit.closeSilently((Closeable)connection);
                return iStatus3;
            }
            String errorMsg = startedRecording == null ? Messages.START_RECORDING_JOB_SERVICE_ERROR_MSG : Messages.START_RECORDING_JOB_ERROR_WHILE_MONITORING_RECORDING;
            IStatus iStatus4 = StatusFactory.createErr((String)NLS.bind((String)errorMsg, (Object)connectionName), (Throwable)e, (boolean)true);
            IOToolkit.closeSilently((Closeable)connection);
            return iStatus4;
        }
        IOToolkit.closeSilently((Closeable)connection);
        return iStatus;
    }

    private IStatus monitorRecording(IRecordingDescriptor startedRecording, IProgressMonitor monitor, IConnectionHandle connection, IFlightRecorderService flightRecorderService) throws Exception {
        block10: {
            RecordingProvider rec = this.m_recorder.getRecording(startedRecording);
            rec.setDumpToFile(this.m_path);
            int totalWork = StartRecordingJob.calculateSeconds(startedRecording.getDuration());
            monitor.beginTask(startedRecording.getName(), totalWork);
            int progress = 0;
            while (true) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (rec.wasClosed()) {
                    monitor.done();
                    break block10;
                }
                rec = this.m_recorder.findRecording(startedRecording.getId(), connection);
                if (this.m_canceling) {
                    if (rec != null && rec.isStoppable()) {
                        flightRecorderService.stop(rec.getRecordingDescriptor());
                        IRecordingDescriptor desc = rec.getRecordingDescriptor();
                        if (desc != null) {
                            rec.updateRecording(desc, connection);
                        }
                    }
                    break block10;
                }
                if (rec == null) break;
                if (rec.isStopped()) {
                    monitor.done();
                    break block10;
                }
                float duration = rec.getRecordingDescriptor().getDuration();
                float partOfWorkDone = duration > 0.0f ? 1.0f - (float)rec.getTimeRemaining() / duration : 0.0f;
                int newProgress = Math.round((float)totalWork * partOfWorkDone);
                int worked = newProgress - progress;
                progress = newProgress;
                try {
                    monitor.worked(worked);
                }
                catch (RuntimeException e) {
                    ControlPanel.getDefault().getLogger().log(Level.WARNING, "Could not update progress", e);
                }
            }
            monitor.done();
            return StatusFactory.createErr((String)NLS.bind((String)Messages.START_FLIGHT_RECORDING_JOB_MISSING_RECORDING, (Object)startedRecording.getName()));
        }
        return Status.OK_STATUS;
    }

    private static int calculateSeconds(long ms) {
        return (int)Math.min(ms / 1000L, Integer.MAX_VALUE);
    }
}

