/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.recordingconfiguration;

import com.jrockit.mc.flightrecorder.EventAppearance;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.recordingconfiguration.PathElement;
import com.jrockit.mc.flightrecorder.controlpanel.ui.recordingconfiguration.Property;
import com.jrockit.mc.flightrecorder.controlpanel.ui.recordingconfiguration.PropertyContainer;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.misc.ColorProvider;
import com.jrockit.mc.ui.misc.MCColor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

final class PropertyLabelProvider
extends LabelProvider
implements IFontProvider,
IColorProvider {
    private final ColorProvider m_colorProvider;

    public PropertyLabelProvider(Display display) {
        this.m_colorProvider = new ColorProvider(display, 14);
    }

    public void dispose() {
        this.m_colorProvider.dispose();
        super.dispose();
    }

    public Image getImage(Object element) {
        if (element instanceof PropertyContainer.FolderNode) {
            return UIPlugin.getDefault().getImage("fldr_obj.gif");
        }
        if (element instanceof PropertyContainer) {
            return this.getEventImage((PropertyContainer)element);
        }
        assert (element instanceof Property);
        return UIPlugin.getDefault().getImage("property_obj.gif");
    }

    private Image getEventImage(PropertyContainer container) {
        String path = container.getPath();
        Image i = this.m_colorProvider.getImage((Object)path);
        if (i == null) {
            this.m_colorProvider.registerColor((Object)path, new MCColor(EventAppearance.getColor((String)path)));
            i = this.m_colorProvider.getImage((Object)path);
        }
        return i;
    }

    public String getText(Object element) {
        if (element instanceof PathElement) {
            String text = ((PathElement)element).getHumanReadableName();
            if (element instanceof Property) {
                Property property = (Property)element;
                String name = property.getName();
                String value = property.getValue();
                if ("period".equals(name) && "everyChunk".equals(value)) {
                    value = Messages.RECORDING_TEMPLATE_ONCE_PER_CHUNK;
                }
                text = String.valueOf(text) + '=' + value;
            }
            return text;
        }
        assert (false);
        return null;
    }

    public Font getFont(Object element) {
        if (element instanceof PathElement) {
            return this.getFont((PathElement)element);
        }
        return null;
    }

    private Font getFont(PathElement pathElement) {
        switch (pathElement.getKind()) {
            case IN_CONFIGURATION: {
                return this.getPropertyDoesNotExistFont();
            }
            case IN_BOTH: {
                return this.getPropertyPartOfTemplateFont();
            }
            case IN_SERVER: {
                return this.getNormalFont();
            }
        }
        throw new IllegalArgumentException("Illegal type " + (Object)((Object)pathElement.getKind()) + '!');
    }

    private Font getPropertyDoesNotExistFont() {
        return UIPlugin.getDefault().getFontColorToolkit().getBoldItalicTableFont();
    }

    private Font getPropertyPartOfTemplateFont() {
        return UIPlugin.getDefault().getFontColorToolkit().getBoldTableFont();
    }

    private Font getNormalFont() {
        return UIPlugin.getDefault().getFontColorToolkit().getNormalTableFont();
    }

    public Color getForeground(Object element) {
        if (element instanceof PathElement && ((PathElement)element).getKind() == PathElement.PathElementKind.IN_CONFIGURATION) {
            return UIPlugin.getDefault().getFontColorToolkit().getInactiveForegroundColor();
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

