/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.recordingconfiguration;

import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.flightrecorder.configuration.IRecordingConfiguration;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplate;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplateModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.recordingconfiguration.PathElement;
import com.jrockit.mc.flightrecorder.controlpanel.ui.recordingconfiguration.Property;
import com.jrockit.mc.flightrecorder.controlpanel.ui.recordingconfiguration.PropertyContainer;
import com.jrockit.mc.flightrecorder.controlpanel.ui.recordingconfiguration.PropertyContentBuilder;
import com.jrockit.mc.flightrecorder.controlpanel.ui.recordingconfiguration.PropertyContentProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.recordingconfiguration.PropertyLabelProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.recordingconfiguration.RecordingTemplateViewerComparator;
import com.jrockit.mc.flightrecorder.controlpanel.ui.recordingconfiguration.RecordingTemplateViewerFilter;
import com.jrockit.mc.rjmx.services.flr.IConvertibleValue;
import com.jrockit.mc.rjmx.services.flr.IEventSettingsHolder;
import com.jrockit.mc.rjmx.services.flr.IOptionConstraint;
import com.jrockit.mc.rjmx.services.flr.OptionHelper;
import com.jrockit.mc.ui.UIPlugin;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RecordingTemplatePart {
    private static final int PROPERTY_EDITORS_MIN_WIDTH = 200;
    private static final int PROPERTY_EDITORS_MIN_HEIGHT = 150;
    private static final String MILLIS_PERIODICITY_CONTENT_TYPE = "millis_periodicity";
    private static final String BOOLEAN_CONTENT_TYPE = "boolean";
    private final WizardPage m_wizardPage;
    private RecordingTemplateModel editableConfigModel;
    private TreeViewer m_propertyTreeViewer;
    private PathElement m_selectedElement;
    private Composite m_propertyEditorsContainer;
    private boolean m_editable;
    private Text m_filterText;
    private RecordingTemplateViewerFilter m_filter;

    public RecordingTemplatePart(WizardPage wizardPage, RecordingTemplateModel editableConfigModel) {
        this.m_wizardPage = wizardPage;
        this.editableConfigModel = editableConfigModel;
        this.m_editable = true;
    }

    private IEventSettingsHolder getServerSettings() {
        return this.editableConfigModel.getServerSettings();
    }

    private IRecordingConfiguration getRecordingConfiguration() {
        return this.editableConfigModel.getTemplate();
    }

    public void setInput(RecordingTemplateModel editableConfigModel) {
        this.editableConfigModel = editableConfigModel;
        this.updateInput();
    }

    public void setEditable(boolean editable) {
        this.m_editable = editable;
    }

    public boolean getEditable() {
        return this.m_editable;
    }

    public Control createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gd1 = new GridData(4, 4, false, false);
        Label filterLabel = this.createFilterDetailsLabel(container);
        filterLabel.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false);
        Text filterText = this.createFilterDetailsText(container);
        filterText.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(4, 4, true, true);
        TreeViewer viewer = this.createTreeViewer(container);
        gd3.horizontalSpan = 2;
        viewer.getControl().setLayoutData((Object)gd3);
        GridData gd4 = new GridData(4, 4, true, true);
        Composite details = this.createScrollablePropertyEditorsContainer(container);
        details.setLayoutData((Object)gd4);
        this.hookListeners();
        this.updateInput();
        return container;
    }

    private Label createFilterDetailsLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.LABEL_FILTER_TEXT);
        return label;
    }

    private Text createFilterDetailsText(Composite parent) {
        this.m_filterText = new Text(parent, 2048);
        this.updateFilter();
        return this.m_filterText;
    }

    private void updateFilter() {
        if (this.m_filter != null) {
            String filterText = this.m_filterText != null ? this.m_filterText.getText() : "";
            this.m_filter.update(filterText);
        }
    }

    private Composite createScrollablePropertyEditorsContainer(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 2304);
        Composite wrapped = this.createPropertyEditorsContainer((Composite)sc);
        sc.setContent((Control)wrapped);
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        sc.setMinHeight(150);
        sc.setMinWidth(200);
        return sc;
    }

    private Composite createPropertyEditorsContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.m_propertyEditorsContainer = container;
        return container;
    }

    private TreeViewer createTreeViewer(Composite parent) {
        this.m_propertyTreeViewer = new TreeViewer(parent, 2304);
        this.m_propertyTreeViewer.setAutoExpandLevel(2);
        this.m_propertyTreeViewer.setLabelProvider((IBaseLabelProvider)new PropertyLabelProvider(this.m_propertyTreeViewer.getTree().getDisplay()));
        this.m_propertyTreeViewer.setContentProvider((IContentProvider)new PropertyContentProvider());
        this.m_filter = new RecordingTemplateViewerFilter();
        this.updateFilter();
        this.m_propertyTreeViewer.addFilter((ViewerFilter)this.m_filter);
        this.m_propertyTreeViewer.setComparator((ViewerComparator)new RecordingTemplateViewerComparator());
        return this.m_propertyTreeViewer;
    }

    private void hookListeners() {
        this.hookFilterListener();
        this.hookTreeSelectionListener();
    }

    private void hookFilterListener() {
        this.m_filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RecordingTemplatePart.this.refreshTreeWithFilter();
            }
        });
    }

    private void refreshTreeWithFilter() {
        this.updateFilter();
        this.m_propertyTreeViewer.getTree().setRedraw(false);
        this.m_propertyTreeViewer.refresh();
        if (this.m_filterText.getText().length() == 0) {
            this.m_propertyTreeViewer.collapseAll();
        } else {
            this.m_propertyTreeViewer.expandAll();
        }
        this.m_propertyTreeViewer.getTree().setRedraw(true);
        this.m_propertyTreeViewer.getTree().redraw();
    }

    private void hookTreeSelectionListener() {
        this.m_propertyTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RecordingTemplatePart.this.updateSelected(((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
    }

    private void updateInput() {
        Object[] expanded = this.m_propertyTreeViewer.getExpandedElements();
        ISelection currentSelection = this.m_propertyTreeViewer.getSelection();
        this.m_propertyTreeViewer.getTree().setRedraw(false);
        this.m_propertyTreeViewer.setInput((Object)this.editableConfigModel);
        if (this.m_filterText.getText().length() > 0) {
            this.m_propertyTreeViewer.expandAll();
        } else {
            this.m_propertyTreeViewer.setExpandedElements(expanded);
        }
        if (currentSelection != null) {
            this.m_propertyTreeViewer.setSelection(currentSelection, true);
        }
        this.m_propertyTreeViewer.getTree().setRedraw(true);
        this.m_propertyTreeViewer.getTree().redraw();
    }

    private void updateSelected(Object object) {
        if (object == this.m_selectedElement) {
            return;
        }
        this.m_selectedElement = object instanceof PathElement ? (PathElement)object : null;
        this.updatePropertyEditors();
    }

    private void updatePropertyEditors() {
        Control[] controlArray = this.m_propertyEditorsContainer.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        this.clearErrorMessage();
        Map<String, Set<Property>> properties = this.findProperties();
        for (Map.Entry<String, Set<Property>> entry : properties.entrySet()) {
            CommonValueProperties<?> cvp = this.findCommonValueProperties(entry.getValue());
            if (((CommonValueProperties)cvp).contentType == null) continue;
            GridData gd1 = new GridData(16384, 0x1000000, false, false);
            final Label propertyKeyLabel = new Label(this.m_propertyEditorsContainer, 0);
            propertyKeyLabel.setText(PropertyContentBuilder.getLocalizedOptionName(entry.getKey()));
            propertyKeyLabel.setLayoutData((Object)gd1);
            GridData gd2 = new GridData(4, 4, true, false);
            Control propertyControl = this.createPropertyControl(this.m_propertyEditorsContainer, cvp, entry.getValue());
            propertyControl.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = propertyKeyLabel.getText();
                }
            });
            propertyControl.setLayoutData((Object)gd2);
        }
        this.m_propertyEditorsContainer.layout(true, true);
    }

    private Map<String, Set<Property>> findProperties() {
        TreeMap<String, Set<Property>> properties = new TreeMap<String, Set<Property>>();
        this.findProperties(this.m_selectedElement, properties);
        return properties;
    }

    private void findProperties(PathElement pathElement, Map<String, Set<Property>> properties) {
        if (pathElement instanceof Property) {
            this.findProperties((Property)pathElement, properties);
        } else if (pathElement instanceof PropertyContainer) {
            this.findProperties((PropertyContainer)pathElement, properties);
        }
    }

    private void findProperties(PropertyContainer folder, Map<String, Set<Property>> properties) {
        for (PathElement pathElement : folder.getChildren()) {
            this.findProperties(pathElement, properties);
        }
    }

    private void findProperties(Property property, Map<String, Set<Property>> properties) {
        if (!this.propertyShouldBeModifiable(property)) {
            return;
        }
        Set<Property> propertySet = properties.get(property.getName());
        if (propertySet == null) {
            propertySet = new HashSet<Property>();
            properties.put(property.getName(), propertySet);
        }
        propertySet.add(property);
    }

    private boolean propertyShouldBeModifiable(Property property) {
        return this.editableConfigModel.isOffline() || property.getKind().contains(PathElement.PathElementKind.IN_SERVER);
    }

    private IOptionConstraint<?> getConstraintFor(Property property) {
        IConvertibleValue serverOption;
        if (this.getServerSettings() != null && (serverOption = this.getServerSettings().getEventOption(property.getEventOptionID())) != null) {
            return serverOption.getConstraint();
        }
        String optionKey = property.getName();
        return OptionHelper.getBestKnownConstraintFor((String)optionKey);
    }

    private Control createPropertyControl(Composite parent, CommonValueProperties<?> cvp, Set<Property> properties) {
        String contentType = ((CommonValueProperties)cvp).contentType;
        if (BOOLEAN_CONTENT_TYPE.equals(contentType)) {
            return this.createBooleanPropertyControl(parent, properties, cvp);
        }
        if (MILLIS_PERIODICITY_CONTENT_TYPE.equals(contentType)) {
            return this.createTextPropertyControl(parent, properties, cvp, true);
        }
        return this.createTextPropertyControl(parent, properties, cvp, false);
    }

    private CommonValueProperties<?> findCommonValueProperties(Set<Property> properties) {
        CommonValueProperties<?> cvp = null;
        for (Property property : properties) {
            IOptionConstraint<?> constraint = this.getConstraintFor(property);
            if (cvp == null) {
                cvp = this.initCommonValueProperties(constraint, property.getValue());
                continue;
            }
            this.updateCommonValueProperties(cvp, constraint, property.getValue());
        }
        return cvp;
    }

    private <T extends Comparable<T>> CommonValueProperties<T> initCommonValueProperties(IOptionConstraint<T> optionConstraint, String value) {
        CommonValueProperties cvp = new CommonValueProperties();
        cvp.contentType = optionConstraint.getContentType();
        cvp.min = optionConstraint.getMin();
        cvp.max = optionConstraint.getMax();
        cvp.type = optionConstraint.getType();
        cvp.value = value;
        return cvp;
    }

    private <T extends Comparable<T>> void updateCommonValueProperties(CommonValueProperties<?> cvp, IOptionConstraint<T> optionConstraint, String value) {
        this.updateCommonContentTypeProperty(cvp, optionConstraint);
        this.updateCommonTypeProperty(cvp, optionConstraint);
        this.updateCommonMaxValueProperty(cvp, optionConstraint);
        this.updateCommonMinValueProperty(cvp, optionConstraint);
        this.updateCommonValueProperty(cvp, value);
    }

    private void updateCommonContentTypeProperty(CommonValueProperties<?> cvp, IOptionConstraint<?> optionConstraint) {
        if (((CommonValueProperties)cvp).contentType != null && !((CommonValueProperties)cvp).contentType.equals(optionConstraint.getContentType())) {
            ((CommonValueProperties)cvp).contentType = null;
        }
    }

    private void updateCommonTypeProperty(CommonValueProperties<?> cvp, IOptionConstraint<?> optionConstraint) {
        if (((CommonValueProperties)cvp).type != null && !((CommonValueProperties)cvp).type.equals(optionConstraint.getType())) {
            ((CommonValueProperties)cvp).type = null;
            ((CommonValueProperties)cvp).max = null;
            ((CommonValueProperties)cvp).min = null;
        }
    }

    private void updateCommonMaxValueProperty(CommonValueProperties<?> cvp, IOptionConstraint<?> optionConstraint) {
        if (((CommonValueProperties)cvp).max != null && !((CommonValueProperties)cvp).max.equals(optionConstraint.getMax())) {
            ((CommonValueProperties)cvp).max = null;
        }
    }

    private void updateCommonMinValueProperty(CommonValueProperties<?> cvp, IOptionConstraint<?> optionConstraint) {
        if (((CommonValueProperties)cvp).min != null && !((CommonValueProperties)cvp).min.equals(optionConstraint.getMin())) {
            ((CommonValueProperties)cvp).min = null;
        }
    }

    private void updateCommonValueProperty(CommonValueProperties<?> cvp, Object value) {
        if (((CommonValueProperties)cvp).value != null && !((CommonValueProperties)cvp).value.equals(value)) {
            ((CommonValueProperties)cvp).value = null;
        }
    }

    private Control createBooleanPropertyControl(Composite parent, Set<Property> properties, CommonValueProperties<?> cvp) {
        if (UIPlugin.getDefault().getAccessibilityMode() && !this.getEditable()) {
            Text text = new Text(parent, 0);
            text.setEditable(false);
            text.setText(Boolean.valueOf(((CommonValueProperties)cvp).value) != false ? Messages.ACCESSIBILITY_CHECKBOX_CHECKED : Messages.ACCESSIBILITY_CHECKBOX_NOT_CHECKED);
            return text;
        }
        Button checkbox = new Button(parent, 32);
        if (((CommonValueProperties)cvp).value != null) {
            checkbox.setSelection(Boolean.valueOf(((CommonValueProperties)cvp).value).booleanValue());
        } else {
            checkbox.setGrayed(true);
            checkbox.setSelection(true);
        }
        checkbox.setEnabled(this.getEditable());
        checkbox.addSelectionListener(this.createSelectionListener(properties, checkbox));
        return checkbox;
    }

    private SelectionListener createSelectionListener(final Set<Property> properties, final Button checkbox) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (checkbox.getGrayed()) {
                    checkbox.setGrayed(false);
                    checkbox.setSelection(true);
                }
                RecordingTemplatePart.this.updateProperties(properties, Boolean.toString(checkbox.getSelection()));
            }
        };
    }

    private Text createTextPropertyControl(Composite parent, Set<Property> properties, CommonValueProperties<?> cvp, boolean periodicityHack) {
        Text text = this.getEditable() ? new Text(parent, 2048) : new Text(parent, 0);
        String value = ((CommonValueProperties)cvp).value;
        if (value != null) {
            if (periodicityHack) {
                if (value.equals("everyChunk")) {
                    value = "";
                }
                text.setMessage(Messages.RECORDING_TEMPLATE_ONCE_PER_CHUNK);
            }
            text.setText(value);
        }
        text.setEditable(this.getEditable());
        text.addModifyListener(this.createModifyListener(properties, text, cvp, periodicityHack));
        return text;
    }

    private ModifyListener createModifyListener(final Set<Property> properties, final Text text, final IOptionConstraint<?> converter, final boolean periodicityHack) {
        return new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                try {
                    String valueWithUnit = text.getText();
                    if (periodicityHack && valueWithUnit.isEmpty()) {
                        valueWithUnit = "everyChunk";
                        text.setMessage(Messages.RECORDING_TEMPLATE_ONCE_PER_CHUNK);
                    }
                    converter.toServerValue(valueWithUnit);
                    RecordingTemplatePart.this.updateProperties(properties, valueWithUnit);
                    RecordingTemplatePart.this.clearErrorMessage();
                }
                catch (QuantityConversionException e) {
                    RecordingTemplatePart.this.setErrorMessage(e.getLocalizedMessage());
                }
            }
        };
    }

    private void setErrorMessage(String errorMessage) {
        if (this.m_wizardPage != null) {
            this.m_wizardPage.setErrorMessage(errorMessage);
            this.m_wizardPage.setPageComplete(false);
        }
    }

    private void clearErrorMessage() {
        if (this.m_wizardPage != null) {
            this.m_wizardPage.setErrorMessage(null);
            this.m_wizardPage.setPageComplete(true);
        }
    }

    private void updateProperties(Set<Property> properties, String newValue) {
        IRecordingConfiguration configuration = this.getRecordingConfiguration();
        for (Property property : properties) {
            property.setValue(newValue, PathElement.PathElementKind.IN_CONFIGURATION);
            configuration.setOption(property.getEventOptionID(), newValue);
        }
        this.m_propertyTreeViewer.refresh();
        ((RecordingTemplate)configuration).getXMLModel().markDirty();
    }

    private static class CommonValueProperties<T extends Comparable<T>>
    implements IOptionConstraint<T> {
        private Class<T> type;
        private T min;
        private T max;
        private String contentType;
        private String value;

        private CommonValueProperties() {
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + '[' + this.type + ',' + this.max + ',' + this.min + ',' + this.contentType + ',' + this.value + ']';
        }

        public String getContentType() {
            return this.contentType;
        }

        public T getMax() {
            return this.max;
        }

        public T getMin() {
            return this.min;
        }

        public Class<T> getType() {
            return this.type;
        }

        public T toServerValue(String configurationValue) throws QuantityConversionException {
            return (T)OptionHelper.toServerValue((IOptionConstraint)this, (String)configurationValue);
        }

        public String toConfigString(T serverValue) {
            return OptionHelper.toConfigString((IOptionConstraint)this, serverValue);
        }
    }
}

