/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.flightrecorder.controlpanel.ui.RecordingProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.RecordingWizardModel;
import com.jrockit.mc.rjmx.ConnectionException;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import java.io.Closeable;
import java.util.Date;
import org.eclipse.osgi.util.NLS;

public class DumpRecordingWizardModel {
    private IConnectionHandle m_connection;
    private final RecordingProvider m_recordingDescriptor;
    private MCFile m_path;
    private final boolean m_recordingToDisk;
    private Date m_recordingStartTime;
    private final long m_recordingDuration;

    public DumpRecordingWizardModel(RecordingProvider recording) throws ConnectionException {
        this.m_recordingDescriptor = recording;
        this.m_path = RecordingWizardModel.getDefaultRecordingFileName();
        this.m_recordingToDisk = true;
        this.m_recordingStartTime = recording.getRecordingDescriptor().getStartTime();
        if (this.m_recordingStartTime == null) {
            this.m_recordingStartTime = new Date(this.getLocalTimeAsServerTime(System.currentTimeMillis()));
        }
        this.m_recordingDuration = recording.getRecordingDescriptor().getDuration();
        this.m_connection = recording.getServerHandle().connect(NLS.bind((String)Messages.DUMP_RECORDING_CONNECTION, (Object)recording.getName()));
    }

    public Date recordingEndTime() {
        if (this.m_recordingDuration > 0L && this.recordingIsStopped()) {
            return new Date(this.m_recordingStartTime.getTime() + this.m_recordingDuration);
        }
        return new Date(this.getLocalTimeAsServerTime(System.currentTimeMillis()));
    }

    private boolean recordingIsStopped() {
        return this.m_recordingDescriptor != null && this.m_recordingDescriptor.isStopped();
    }

    private long getLocalTimeAsServerTime(long localTime) {
        IMBeanHelperService service = (IMBeanHelperService)this.m_connection.getServiceOrDummy(IMBeanHelperService.class);
        return localTime + service.getApproximateServerTime(0L);
    }

    public RecordingProvider getRecordingDescriptor() {
        return this.m_recordingDescriptor;
    }

    public MCFile getPath() {
        return this.m_path;
    }

    public boolean isRecordingToDisk() {
        return this.m_recordingToDisk;
    }

    public Date getRecordingStartTime() {
        return this.m_recordingStartTime;
    }

    public void setPath(MCFile path) {
        this.m_path = path;
    }

    public void dispose() {
        IOToolkit.closeSilently((Closeable)this.m_connection);
    }
}

