/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.flightrecorder.controlpanel.ui.RecordingProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.jobs.UpdateRecordingJob;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.RecordingWizard;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.RecordingWizardModel;
import com.jrockit.mc.rjmx.services.flr.IEventSettingsHolder;
import com.jrockit.mc.rjmx.services.flr.RecordingOptionsBuilder;
import java.util.Map;

public class EditRecordingWizard
extends RecordingWizard {
    private RecordingProvider recording;

    public EditRecordingWizard(RecordingProvider recording, RecordingWizardModel model) {
        super(model);
        this.recording = recording;
    }

    public boolean performFinish() {
        this.editRecording(this.getModel());
        return true;
    }

    private void editRecording(RecordingWizardModel wizardModel) {
        RecordingOptionsBuilder builder = new RecordingOptionsBuilder().name(wizardModel.getName()).toDisk(true);
        if (wizardModel.isFixedRecording()) {
            builder.duration(wizardModel.getDuration()).maxSize(0L).maxAge(0L);
        } else {
            builder.duration(0L);
            if (wizardModel.hasMaxSize()) {
                builder.maxSize(wizardModel.getMaxSize());
            }
            if (wizardModel.hasMaxAge()) {
                builder.maxAge(wizardModel.getMaxAge());
            }
        }
        Map recordingOptions = builder.build();
        UpdateRecordingJob updateJob = new UpdateRecordingJob(this.recording, wizardModel.getPath(), recordingOptions, (IEventSettingsHolder)wizardModel.getAndSaveActiveConfiguration());
        updateJob.schedule();
    }
}

