/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.core.CorePlugin;
import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.flightrecorder.configuration.IRecordingConfiguration;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplate;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.RecordingTemplateRepository;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.TemplateRepositoryFactory;
import com.jrockit.mc.flightrecorder.controlpanel.ui.model.VolatileStorageDelegate;
import com.jrockit.mc.rjmx.services.flr.EventOptionID;
import com.jrockit.mc.rjmx.services.flr.EventTypeID;
import com.jrockit.mc.rjmx.services.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.services.flr.IConvertibleValue;
import com.jrockit.mc.rjmx.services.flr.IEventSettingsHolder;
import com.jrockit.mc.rjmx.services.flr.IEventTypeInfo;
import com.jrockit.mc.rjmx.services.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.services.flr.IOptionDescriptor;
import com.jrockit.mc.rjmx.services.flr.IRecordingDescriptor;
import com.jrockit.mc.rjmx.services.flr.RecordingOptionsBuilder;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.logging.Level;
import org.eclipse.osgi.util.NLS;

public final class RecordingWizardModel
extends Observable {
    private static final String DEFAULT_SELECTED_TEMPLATE = "Profiling";
    private static final String DEFAULT_FILENAME = "flight_recording_";
    private static final int DEFAULT_DURATION = 60000;
    public static final long NO_MAX_SIZE = -1L;
    public static final long NO_MAX_AGE = -1L;
    private final boolean m_editing;
    private final RecordingTemplateRepository m_templateRepository;
    private MCFile m_path;
    private String m_name;
    private boolean m_fixedRecording;
    private long m_durationMillis;
    private long m_maxSize;
    private long m_maxAge;
    private final Map<String, IOptionDescriptor> m_recordingOptions;
    private final IEventSettingsHolder m_initiallyActiveEventSettings;
    private final Map<EventTypeID, IEventTypeInfo> m_eventTypeInfos;
    private List<IRecordingConfiguration> m_activeConfigStack = new ArrayList<IRecordingConfiguration>();
    public static final String FLIGHT_RECORDING_FILE_EXTENSION = "jfr";

    private RecordingWizardModel(IFlightRecorderService flrService, boolean editing) {
        Map recordingOptions = Collections.emptyMap();
        Map eventTypeInfos = Collections.emptyMap();
        IEventSettingsHolder settingsHolder = null;
        try {
            recordingOptions = flrService.getAvailableRecordingOptions();
            eventTypeInfos = flrService.getEventTypeInfoMapByID();
            settingsHolder = flrService.getCurrentEventTypeSettings();
        }
        catch (FlightRecorderException e) {
            ControlPanel.getDefault().getLogger().log(Level.WARNING, "Could not get initial state from flight recorder", e);
        }
        this.m_eventTypeInfos = eventTypeInfos;
        this.m_initiallyActiveEventSettings = settingsHolder;
        this.m_recordingOptions = recordingOptions;
        this.m_templateRepository = this.createRepository(flrService);
        this.m_editing = editing;
    }

    public RecordingWizardModel(IFlightRecorderService flrService) {
        this(flrService, false);
        this.m_path = RecordingWizardModel.getDefaultRecordingFileName();
        this.m_name = this.getDefaultName(flrService);
        this.m_durationMillis = 60000L;
        this.m_maxSize = -1L;
        this.m_maxAge = -1L;
        this.m_fixedRecording = this.m_durationMillis > 0L;
        this.initActive();
    }

    private void initActive() {
        if (!this.m_templateRepository.isEmpty()) {
            List<IRecordingConfiguration> templates = this.m_templateRepository.getAllTemplates();
            IRecordingConfiguration best = templates.get(0);
            for (IRecordingConfiguration config : templates) {
                if (!DEFAULT_SELECTED_TEMPLATE.equals(config.getName()) || !Messages.VOLATILE_CONFIGURATION_ON_SERVER.equals(config.getLocationInfo())) continue;
                best = config;
                break;
            }
            for (IRecordingConfiguration config : templates) {
                if (!Messages.VOLATILE_CONFIGURATION_LAST_STARTED.equals(config.getLocationInfo())) continue;
                best = config;
            }
            this.setActiveConfigurationTemplate(best);
        }
    }

    public RecordingWizardModel(IFlightRecorderService flrService, IRecordingDescriptor recordingDescriptor, MCFile filename) {
        this(flrService, true);
        this.setActiveConfigurationTemplate(this.createRunningConfig(flrService, recordingDescriptor));
        this.m_templateRepository.notifyObservers();
        this.m_path = filename != null ? filename : RecordingWizardModel.getDefaultRecordingFileName();
        this.m_name = recordingDescriptor.getName();
        this.m_durationMillis = recordingDescriptor.getDuration();
        this.m_maxSize = recordingDescriptor.getMaxSize();
        if (this.m_maxSize == 0L) {
            this.m_maxSize = -1L;
        }
        this.m_maxAge = recordingDescriptor.getMaxAge();
        if (this.m_maxAge == 0L) {
            this.m_maxAge = -1L;
        }
        this.m_fixedRecording = this.m_durationMillis > 0L;
    }

    private IRecordingConfiguration createRunningConfig(IFlightRecorderService flrService, IRecordingDescriptor recordingDescriptor) {
        IRecordingConfiguration config = RecordingTemplate.createEmpty(VolatileStorageDelegate.getRunningRecordingDelegate());
        try {
            IEventSettingsHolder settings = flrService.getEventSettings(recordingDescriptor);
            for (Map.Entry entry : settings.getEventOptions().entrySet()) {
                config.setOption((EventOptionID)entry.getKey(), ((IConvertibleValue)entry.getValue()).toConfigString());
            }
            config.setName(recordingDescriptor.getName());
        }
        catch (FlightRecorderException flightRecorderException) {
            // empty catch block
        }
        config.setDescription(Messages.EDIT_RECORDING_WIZARD_RUNNING_CONFIGURATION_DESCRIPTION);
        this.m_templateRepository.add(config);
        return config;
    }

    private RecordingTemplateRepository createRepository(IFlightRecorderService flrService) {
        RecordingTemplateRepository repo = TemplateRepositoryFactory.create();
        repo.setPrototypeTemplate(RecordingTemplate.createEmpty(VolatileStorageDelegate.getWorkingCopyDelegate()));
        try {
            for (String templateXML : flrService.getServerTemplates()) {
                try {
                    repo.add(new RecordingTemplate(RecordingTemplate.createModel(templateXML), VolatileStorageDelegate.getOnServerDelegate()));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (FlightRecorderException e) {
            e.printStackTrace();
        }
        repo.notifyObservers();
        return repo;
    }

    public IEventSettingsHolder getInitialEventTypeSettings() {
        return this.m_initiallyActiveEventSettings;
    }

    public Map<EventTypeID, IEventTypeInfo> getEventTypeInfoMap() {
        return this.m_eventTypeInfos;
    }

    private String getDefaultName(IFlightRecorderService flrService) {
        boolean hasFoundUniqueName = false;
        String name = Messages.RECORDING_DESCRIPTOR_DEFAULT_NAME;
        List<IRecordingDescriptor> descriptors = this.getDescriptors(flrService);
        if (descriptors == null) {
            return name;
        }
        int count = 2;
        while (!hasFoundUniqueName) {
            try {
                boolean exists = this.existsRecordingName(descriptors, name);
                if (exists) {
                    name = String.valueOf(Messages.RECORDING_DESCRIPTOR_DEFAULT_NAME) + ' ' + count++;
                    continue;
                }
                hasFoundUniqueName = true;
            }
            catch (Exception e) {
                break;
            }
        }
        return name;
    }

    private boolean existsRecordingName(List<IRecordingDescriptor> descriptors, String name) {
        for (IRecordingDescriptor descriptor : descriptors) {
            if (!name.equals(descriptor.getName())) continue;
            return true;
        }
        return false;
    }

    private List<IRecordingDescriptor> getDescriptors(IFlightRecorderService flrService) {
        try {
            return flrService.getAvailableRecordings();
        }
        catch (FlightRecorderException e) {
            ControlPanel.getDefault().getLogger().log(Level.WARNING, "Could not retrieve recording descriptors!", e);
            return null;
        }
    }

    public MCFile getPath() {
        return this.m_path;
    }

    public String getRecordingName() {
        return this.m_name;
    }

    public boolean isFixedRecording() {
        return this.m_fixedRecording;
    }

    public long getDuration() {
        return this.m_durationMillis;
    }

    public long getMaxSize() {
        return this.m_maxSize;
    }

    public long getMaxAge() {
        return this.m_maxAge;
    }

    public Map<String, Object> buildOptions() {
        RecordingOptionsBuilder builder = new RecordingOptionsBuilder().name(this.getRecordingName());
        if (this.isFixedRecording()) {
            builder.duration(this.getDuration()).maxSize(0L).maxAge(0L).toDisk(true);
        } else {
            builder.duration(0L);
            if (this.hasMaxSize()) {
                builder.maxSize(this.getMaxSize());
            }
            if (this.hasMaxAge()) {
                builder.maxAge(this.getMaxAge());
            }
        }
        return builder.build();
    }

    public IRecordingConfiguration getAndSaveActiveConfiguration() {
        IRecordingConfiguration config = this.getActiveConfiguration();
        if (config != null) {
            IRecordingConfiguration lastStarted = config.createWorkingCopy();
            if (this.getName() != null) {
                String name = NLS.bind((String)Messages.RECORDING_WIZARD_LAST_STARTED_SETTINGS_FOR_NAME_MSG, (Object)this.getName());
                lastStarted.setName(name);
            }
            if (this.getPath() != null) {
                String desc = NLS.bind((String)Messages.RECORDING_WIZARD_LAST_STARTED_DESCRIPTION_MSG, (Object)this.getPath().getPath().toOSString());
                lastStarted.setDescription(desc);
            }
            TemplateRepositoryFactory.saveAsLastStarted(lastStarted);
        }
        return config;
    }

    public void setActiveConfigurationTemplate(IRecordingConfiguration template) {
        if (template != null) {
            this.m_activeConfigStack.clear();
            this.m_activeConfigStack.add(template);
            this.setChanged();
            this.notifyObservers();
        }
    }

    public IRecordingConfiguration getActiveConfiguration() {
        if (!this.m_activeConfigStack.isEmpty()) {
            return this.m_activeConfigStack.get(this.m_activeConfigStack.size() - 1);
        }
        return null;
    }

    public IRecordingConfiguration getCurrentConfigurationAt(int wizardStage) {
        if (this.m_activeConfigStack.size() > wizardStage) {
            return this.m_activeConfigStack.get(wizardStage);
        }
        if (this.m_activeConfigStack.isEmpty()) {
            return null;
        }
        if (wizardStage > 0) {
            IRecordingConfiguration base = this.getCurrentConfigurationAt(wizardStage - 1);
            assert (this.m_activeConfigStack.size() == wizardStage);
            IRecordingConfiguration derived = base.createWorkingCopy();
            this.m_activeConfigStack.add(derived);
            return derived;
        }
        return null;
    }

    public void flushConfigurationsBeyond(int wizardStage) {
        int maxSize = wizardStage + 1;
        while (this.m_activeConfigStack.size() > maxSize) {
            this.m_activeConfigStack.remove(maxSize);
        }
    }

    public static MCFile getDefaultRecordingFileName() {
        return CorePlugin.getDefault().getIDESupport().getValidDefaultFile(DEFAULT_FILENAME, FLIGHT_RECORDING_FILE_EXTENSION);
    }

    public static MCFile openRecordingFileBrowser(MCFile currentPath) {
        return CorePlugin.getDefault().getIDESupport().browseForSaveAsFile(Messages.RECORDING_FILE_BROWSER_TITLE, currentPath.getPath().lastSegment(), currentPath.getPath().removeLastSegments(1), FLIGHT_RECORDING_FILE_EXTENSION, Messages.RECORDING_FILE_BROWSER_DESCRIPTION);
    }

    public boolean isEditing() {
        return this.m_editing;
    }

    public void setDuration(long millis) {
        this.m_durationMillis = millis;
    }

    public void setNoMaxSize() {
        this.m_maxSize = -1L;
    }

    public void setMaxSize(long maxSize) {
        this.m_maxSize = maxSize;
    }

    public void setNoMaxAge() {
        this.m_maxAge = -1L;
    }

    public void setMaxAge(long maxAge) {
        this.m_maxAge = maxAge;
    }

    public String getName() {
        return this.m_name;
    }

    public RecordingTemplateRepository getTemplateRepository() {
        return this.m_templateRepository;
    }

    public void setPath(MCFile path) {
        this.m_path = path;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setFixedRecording(boolean fixedRecording) {
        this.m_fixedRecording = fixedRecording;
    }

    public boolean hasMaxSize() {
        return this.m_maxSize > -1L;
    }

    public boolean hasMaxAge() {
        return this.m_maxAge > -1L;
    }

    public Map<String, IOptionDescriptor> getAvailableRecordingOptions() {
        return this.m_recordingOptions;
    }
}

