/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.controlpanel.ui.wizards;

import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.common.util.SizeToolkit;
import com.jrockit.mc.common.util.TimeRangeToolkit;
import com.jrockit.mc.components.ui.SetData;
import com.jrockit.mc.core.MCFile;
import com.jrockit.mc.flightrecorder.configuration.IRecordingConfiguration;
import com.jrockit.mc.flightrecorder.controlpanel.ui.ControlPanel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.RecordingWizardModel;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.TemplateLabelProvider;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.TemplateManagerWizardPage;
import com.jrockit.mc.flightrecorder.controlpanel.ui.wizards.TemplateProvider;
import com.jrockit.mc.rjmx.services.flr.IEventSettingsHolder;
import com.jrockit.mc.rjmx.services.flr.IOptionDescriptor;
import com.jrockit.mc.ui.misc.HelpSupport;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;

public final class RecordingWizardPage
extends WizardPage {
    private static final String START_JFR_HELP_CTX = "com.jrockit.mc.flightrecorder.controlpanel.ui.RecordingWizard";
    private static final int VISIBLE_ITEMS_IN_COMBO = 10;
    private static final String COMPONENT_ID = "recordingwizard";
    public static final String PAGE_NAME = "startRecordingWizard";
    public static final String EDIT_PAGE_NAME = "editRecordingWizard";
    private static final int WIZARD_STAGE = 0;
    private TemplateProvider m_comboProvider;
    private ComboViewer m_comboViewer;
    private Text m_description;
    private Text m_filenameText;
    private Button m_fixedOption;
    private Text m_durationText;
    private Button m_continuousOption;
    private Text m_maxSizeText;
    private Text m_maxAgeText;
    private final RecordingWizardModel m_model;

    public RecordingWizardPage(RecordingWizardModel model) {
        super(model.isEditing() ? EDIT_PAGE_NAME : PAGE_NAME);
        this.m_model = model;
        this.setImageDescriptor(ControlPanel.getDefault().getMCImageDescriptor("startjfrwiz.gif"));
    }

    public IWizardPage getNextPage() {
        IWizardPage next = this.m_model.getCurrentConfigurationAt(0).hasControlElements() ? this.getWizard().getPage("recordingEventOptionsWizard") : this.getWizard().getPage("advancedOptionWizard");
        return next;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        int indent = this.convertWidthInCharsToPixels(4);
        if (this.m_model.isEditing()) {
            this.setTitle(Messages.EDIT_RECORDING_WIZARD_PAGE_TITLE);
            this.setDescription(Messages.EDIT_RECORDING_WIZARD_PAGE_DESCRIPTION);
        } else {
            this.setTitle(Messages.START_RECORDING_WIZARD_PAGE_TITLE);
            this.setDescription(Messages.START_RECORDING_WIZARD_PAGE_DESCRIPTION);
        }
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        GridData gd1 = new GridData(4, 4, true, false);
        Composite settingsContainer = this.createSettingsContainer(container, indent);
        settingsContainer.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false);
        Label separator = this.creatSeparator(container);
        separator.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(4, 4, true, false);
        Composite descriptionContainer = this.createTemplateDescriptionContainer(container);
        descriptionContainer.setLayoutData((Object)gd3);
        FormText helpText = RecordingWizardPage.addHelpText(container);
        if (helpText != null) {
            GridData gd4 = new GridData(4, 4, true, false);
            helpText.setLayoutData((Object)gd4);
        }
        this.refresh();
        this.selectInitialOption();
        this.setControl((Control)container);
    }

    public static FormText addHelpText(Composite parent) {
        Action helpAction = HelpSupport.getHelpAction((String)START_JFR_HELP_CTX);
        if (helpAction != null) {
            FormText fText = new FormText(parent, 0);
            fText.setText(Messages.RECORDING_WIZARD_PAGE_HELP_LINK, true, true);
            GridData gridDataFAQ = new GridData(768);
            gridDataFAQ.horizontalSpan = 2;
            fText.setLayoutData((Object)gridDataFAQ);
            fText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter((IAction)helpAction){
                private final /* synthetic */ IAction val$helpAction;
                {
                    this.val$helpAction = iAction;
                }

                public void linkActivated(HyperlinkEvent e) {
                    this.val$helpAction.run();
                }
            });
            return fText;
        }
        return null;
    }

    private void selectInitialOption() {
        boolean fixedRecording = this.m_model.isFixedRecording();
        if (this.m_fixedOption != null) {
            this.m_fixedOption.setSelection(fixedRecording);
            this.setFixedRecordingControlsEnabled(fixedRecording);
        }
        if (this.m_continuousOption != null) {
            this.m_continuousOption.setSelection(!fixedRecording);
            this.setContinuousRecordingControlsEnabled(!fixedRecording);
        }
    }

    private void storeSettings() {
        try {
            if (this.m_fixedOption != null && this.m_fixedOption.getSelection()) {
                this.m_model.setDuration(TimeRangeToolkit.parseMillis((String)this.m_durationText.getText()));
            }
            if (this.m_continuousOption != null && this.m_continuousOption.getSelection()) {
                String text = this.m_maxSizeText.getText();
                if (text.length() == 0) {
                    this.m_model.setNoMaxSize();
                } else {
                    this.m_model.setMaxSize(SizeToolkit.parseBytes((String)text));
                }
                text = this.m_maxAgeText.getText();
                if (text.length() == 0) {
                    this.m_model.setNoMaxAge();
                } else {
                    this.m_model.setMaxAge(TimeRangeToolkit.parseMillis((String)this.m_maxAgeText.getText()));
                }
            }
        }
        catch (QuantityConversionException e) {
            ControlPanel.getDefault().getLogger().log(Level.WARNING, "Could not parse value even though validation passed! This should not happen! ", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean validateSettings() {
        try {
            String text;
            if (this.m_model.getName().length() == 0) {
                this.invalidatePageWithMessage(Messages.RECORDING_WIZARD_PAGE_RECORDING_NAME_ERROR_MSG);
                return false;
            }
            if (this.m_fixedOption != null && this.m_fixedOption.getSelection()) {
                text = this.m_durationText.getText();
                try {
                    long duration = TimeRangeToolkit.parseMillis((String)text);
                    if (duration <= 0L) {
                        this.invalidatePageWithMessage(Messages.RECORDING_WIZARD_PAGE_RECORDING_TIME_GT_ZERO);
                        return false;
                    }
                }
                catch (QuantityConversionException e) {
                    this.invalidatePageWithMessage(NLS.bind((String)Messages.RECORDING_WIZARD_PAGE_RECORDING_TIME_ERROR_MSG, (Object)e.getLocalizedMessage()));
                    return false;
                }
            }
            if (this.m_continuousOption != null && this.m_continuousOption.getSelection()) {
                text = this.m_maxSizeText.getText();
                if (text.length() != 0) {
                    try {
                        SizeToolkit.parseBytes((String)text);
                    }
                    catch (QuantityConversionException e) {
                        this.invalidatePageWithMessage(NLS.bind((String)Messages.RECORDING_WIZARD_PAGE_MAX_SIZE_ERROR_MSG, (Object)e.getLocalizedMessage()));
                        return false;
                    }
                }
                if ((text = this.m_maxAgeText.getText()).length() != 0) {
                    try {
                        TimeRangeToolkit.parseMillis((String)text);
                    }
                    catch (QuantityConversionException e) {
                        this.invalidatePageWithMessage(NLS.bind((String)Messages.RECORDING_WIZARD_PAGE_MAX_AGE_ERROR_MSG, (Object)e.getLocalizedMessage()));
                        return false;
                    }
                }
            }
            if (this.m_model.getPath() == null) {
                this.invalidatePageWithMessage(Messages.RECORDING_WIZARD_PAGE_NOT_VALID_FOLDER);
                return false;
            }
            if (this.m_model.getActiveConfiguration() != null) {
                this.storeSettings();
                this.m_model.buildOptions();
                this.setErrorMessage(null);
                this.setPageComplete(true);
                return true;
            }
            if (this.m_model.getTemplateRepository().isEmpty()) {
                this.invalidatePageWithMessage(Messages.RECORDING_WIZARD_PAGE_NO_TEMPLATES_IN_MANAGER_ERROR_MSG);
                return false;
            }
            this.invalidatePageWithMessage(Messages.RECORDING_WIZARD_PAGE_NO_TEMPLATE_SELECTED_ERROR_MSG);
            return false;
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message != null) {
                this.invalidatePageWithMessage(message);
                return false;
            }
            this.invalidatePageWithMessage(Messages.RECORDING_WIZARD_PAGE_CAUGHT_EXCEPTION);
            throw new RuntimeException(e);
        }
    }

    private void invalidatePageWithMessage(String msg) {
        this.setErrorMessage(msg);
        this.setPageComplete(false);
    }

    private void createTemplateControls(Composite parent) {
        GridData gd0 = new GridData(4, 4, false, true);
        Label label = new Label(parent, 0);
        label.setText(Messages.LABEL_TEMPLATE);
        label.setLayoutData((Object)gd0);
        GridData gd1 = new GridData(4, 4, true, true);
        gd1.horizontalSpan = 3;
        this.m_comboProvider = new TemplateProvider();
        this.m_comboViewer = this.createSelector(parent, (IContentProvider)this.m_comboProvider);
        this.m_comboViewer.getControl().setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, false, false);
        Button templateManagerButton = this.createTemplateManagerButton(parent);
        templateManagerButton.setLayoutData((Object)gd2);
        this.hookSelectionListener();
    }

    private void hookSelectionListener() {
        this.m_comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IRecordingConfiguration config = RecordingWizardPage.this.getSelected();
                if (RecordingWizardPage.this.m_comboProvider.clearExtraTemplateUnless(config)) {
                    RecordingWizardPage.this.m_comboViewer.refresh();
                }
                if (config != null) {
                    RecordingWizardPage.this.setActiveTemplate(config);
                    RecordingWizardPage.this.setMessage(null);
                    RecordingWizardPage.this.validateSettings();
                }
            }
        });
    }

    private Button createTemplateManagerButton(Composite parent) {
        Button button = new Button(parent, 0);
        button.setText(Messages.BUTTON_TEMPLATE_MANAGER_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RecordingWizardPage.this.openTemplateManager();
            }
        });
        return button;
    }

    private void refresh() {
        IRecordingConfiguration config = this.m_model.getCurrentConfigurationAt(0);
        if (!this.m_model.getTemplateRepository().contains(config)) {
            this.m_comboProvider.setExtraTemplate(config);
        } else {
            this.m_comboProvider.setExtraTemplate(null);
        }
        this.m_comboViewer.refresh();
        if (config != null) {
            this.m_comboViewer.setSelection((ISelection)new StructuredSelection((Object)config), true);
        }
    }

    private IRecordingConfiguration getSelected() {
        IStructuredSelection ss = (IStructuredSelection)this.m_comboViewer.getSelection();
        return (IRecordingConfiguration)(!ss.isEmpty() ? ss.getFirstElement() : null);
    }

    private Composite createTemplateDescriptionContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        container.setLayout((Layout)layout);
        this.createTemplateControls(container);
        this.createDescriptionControls(container);
        return container;
    }

    private void createDescriptionControls(Composite container) {
        GridData gd1 = new GridData(4, 4, false, true);
        Control label = this.createTemplateDescriptionLabel(container);
        label.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.heightHint = 140;
        gd2.horizontalSpan = 4;
        Control description = this.createDescriptionText(container);
        description.setLayoutData((Object)gd2);
    }

    private Control createTemplateDescriptionLabel(Composite parent) {
        Label descriptionLabel = new Label(parent, 0);
        descriptionLabel.setText(Messages.LABEL_TEMPLATE_DESCRIPTION);
        return descriptionLabel;
    }

    private Control createDescriptionText(Composite parent) {
        this.m_description = new Text(parent, 2634);
        this.m_description.setEnabled(true);
        return this.m_description;
    }

    private Label creatSeparator(Composite parent) {
        return new Label(parent, 258);
    }

    private ComboViewer createSelector(Composite parent, IContentProvider contentProvider) {
        ComboViewer comboViewer = new ComboViewer(parent);
        comboViewer.getCombo().setVisibleItemCount(10);
        comboViewer.setContentProvider(contentProvider);
        comboViewer.setInput((Object)this.m_model.getTemplateRepository());
        comboViewer.setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider());
        return comboViewer;
    }

    public void setActiveTemplate(IRecordingConfiguration template) {
        this.m_model.setActiveConfigurationTemplate(template);
        this.setDescriptionText(template);
    }

    private void setDescriptionText(IRecordingConfiguration rt) {
        if (this.m_description != null && !this.m_description.isDisposed()) {
            String description = rt != null ? rt.getDescription() : "";
            this.m_description.setText(description);
            this.m_description.setToolTipText(description);
        }
    }

    private Composite createSettingsContainer(Composite parent, int indent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        container.setLayout((Layout)layout);
        this.createFileNameInput(container);
        this.createName(container);
        this.createTimeFixedOption(container);
        this.createDuration(container, indent);
        this.createContinuousOptions(indent, container);
        return container;
    }

    private void createContinuousOptions(int indent, Composite container) {
        if (this.shouldHaveContinuousControls()) {
            this.createContinuousOption(container);
            this.createMaxSize(container, indent);
            this.createMaxAge(container, indent);
        }
    }

    private void createFileNameInput(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, true);
        Label label = this.createFilenameLabel(parent);
        label.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 0x1000000, true, true);
        gd2.horizontalSpan = 3;
        this.m_filenameText = this.createFilenameText(parent);
        this.m_filenameText.setLayoutData((Object)gd2);
        this.m_filenameText.setText(this.m_model.getPath() == null ? "" : this.m_model.getPath().getPath().toOSString());
        GridData gd3 = new GridData(4, 4, false, true);
        Button browseButton = this.createFilenameBrowseButton(parent);
        browseButton.setLayoutData((Object)gd3);
    }

    private Text createFilenameText(Composite parent) {
        Text text = new Text(parent, 2056);
        text.setEnabled(false);
        return text;
    }

    private void updateFilename() {
        this.m_filenameText.setText(this.m_model.getPath() == null ? "" : this.m_model.getPath().getPath().toOSString());
        this.validateSettings();
    }

    private Label createFilenameLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.LABEL_FILENAME_TEXT);
        return label;
    }

    private Button createFilenameBrowseButton(Composite parent) {
        final Button button = new Button(parent, 0);
        button.setText(Messages.BUTTON_BROWSE_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MCFile path = RecordingWizardModel.openRecordingFileBrowser(RecordingWizardPage.this.m_model.getPath());
                if (path != null) {
                    RecordingWizardPage.this.m_model.setPath(path);
                    RecordingWizardPage.this.updateFilename();
                }
                button.setFocus();
            }
        });
        return button;
    }

    private void createName(Composite parent) {
        GridData gd1 = new GridData(4, 4, false, true);
        Label label = this.createNameLabel(parent);
        label.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.horizontalSpan = 4;
        Text text = this.createNameText(parent);
        text.setLayoutData((Object)gd2);
    }

    private Text createNameText(Composite parent) {
        final Text text = new Text(parent, 2048);
        this.findToolTipText((Control)text, "recordingOption.name");
        text.setText(this.m_model.getName());
        text.setEditable(!this.m_model.isEditing());
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RecordingWizardPage.this.m_model.setName(text.getText());
                RecordingWizardPage.this.validateSettings();
            }
        });
        return text;
    }

    private Label createNameLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.LABEL_NAME_TEXT);
        return label;
    }

    private void createTimeFixedOption(Composite parent) {
        if (this.shouldHaveDurationControl()) {
            GridData gd1 = new GridData(4, 4, true, true);
            gd1.horizontalSpan = 5;
            this.m_fixedOption = new Button(parent, 16);
            this.m_fixedOption.setText(Messages.BUTTON_TIME_FIXED_RECORDING_TEXT);
            this.m_fixedOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RecordingWizardPage.this.m_model.setFixedRecording(true);
                    RecordingWizardPage.this.setContinuousRecordingControlsEnabled(false);
                    RecordingWizardPage.this.setFixedRecordingControlsEnabled(true);
                    RecordingWizardPage.this.validateSettings();
                }
            });
            this.m_fixedOption.setLayoutData((Object)gd1);
        }
    }

    private void createDuration(Composite parent, int indent) {
        if (this.shouldHaveDurationControl()) {
            GridData gd1 = new GridData(4, 4, false, true);
            gd1.horizontalIndent = indent;
            Label label = this.createDurationLabel(parent);
            label.setLayoutData((Object)gd1);
            GridData gd2 = new GridData(4, 4, true, true);
            gd2.horizontalSpan = 4;
            Text text = this.createDurationText(parent);
            text.setLayoutData((Object)gd2);
        }
    }

    private Text createDurationText(Composite parent) {
        this.m_durationText = new Text(parent, 2048);
        this.findToolTipText((Control)this.m_durationText, "recordingOption.duration");
        this.m_durationText.setText(TimeRangeToolkit.convertMillisToNormalizedString((long)this.m_model.getDuration(), (TimeRangeToolkit.Format)TimeRangeToolkit.Format.LOCALIZED));
        SetData.set((Widget)this.m_durationText, (String)COMPONENT_ID, (String)"duration");
        this.m_durationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RecordingWizardPage.this.validateSettings();
            }
        });
        return this.m_durationText;
    }

    private Label createDurationLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.LABEL_RECORDING_TIME_TEXT);
        return label;
    }

    private void createMaxSize(Composite parent, int indent) {
        GridData gd1 = new GridData(4, 4, false, true);
        gd1.horizontalIndent = indent;
        Label label = this.createMaxSizeLabel(parent);
        label.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.horizontalSpan = 4;
        Text text = this.createMaxSizeText(parent);
        text.setLayoutData((Object)gd2);
    }

    private Label createMaxSizeLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.LABEL_MAX_SIZE);
        return label;
    }

    private Text createMaxSizeText(Composite parent) {
        this.m_maxSizeText = new Text(parent, 2048);
        if (this.m_model.hasMaxSize()) {
            this.m_maxSizeText.setText(SizeToolkit.convertBytesToString((long)this.m_model.getMaxSize(), (SizeToolkit.Format)SizeToolkit.Format.LOCALIZED));
        }
        this.findToolTipText((Control)this.m_maxSizeText, "recordingOption.maxSize");
        this.m_maxSizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RecordingWizardPage.this.validateSettings();
            }
        });
        return this.m_maxSizeText;
    }

    private void createMaxAge(Composite parent, int indent) {
        GridData gd1 = new GridData(4, 4, false, true);
        gd1.horizontalIndent = indent;
        Label label = this.createMaxAgeLabel(parent);
        label.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.horizontalSpan = 4;
        Text text = this.createMaxAgeText(parent);
        text.setLayoutData((Object)gd2);
    }

    private Label createMaxAgeLabel(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.LABEL_MAX_AGE);
        return label;
    }

    private Text createMaxAgeText(Composite parent) {
        this.m_maxAgeText = new Text(parent, 2048);
        if (this.m_model.hasMaxAge()) {
            this.m_maxAgeText.setText(TimeRangeToolkit.convertMillisToNormalizedString((long)this.m_model.getMaxAge(), (TimeRangeToolkit.Format)TimeRangeToolkit.Format.LOCALIZED));
        }
        this.findToolTipText((Control)this.m_maxAgeText, "recordingOption.maxAge");
        this.m_maxAgeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RecordingWizardPage.this.validateSettings();
            }
        });
        return this.m_maxAgeText;
    }

    private void setFixedRecordingControlsEnabled(boolean enabled) {
        if (this.m_durationText != null) {
            this.m_durationText.setEnabled(enabled);
        }
    }

    private void setContinuousRecordingControlsEnabled(boolean enabled) {
        this.m_maxSizeText.setEnabled(enabled);
        this.m_maxAgeText.setEnabled(enabled);
    }

    private void createContinuousOption(Composite parent) {
        GridData gd1 = new GridData(4, 4, true, true);
        gd1.horizontalSpan = 5;
        this.m_continuousOption = new Button(parent, 16);
        this.m_continuousOption.setText(Messages.BUTTON_CONTINUOUS_RECORDING_TEXT);
        this.m_continuousOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RecordingWizardPage.this.m_model.setFixedRecording(false);
                RecordingWizardPage.this.setFixedRecordingControlsEnabled(false);
                RecordingWizardPage.this.setContinuousRecordingControlsEnabled(true);
                RecordingWizardPage.this.validateSettings();
            }
        });
        this.m_continuousOption.setLayoutData((Object)gd1);
    }

    private boolean shouldHaveDurationControl() {
        return !this.m_model.isEditing() || this.m_model.isFixedRecording();
    }

    private boolean shouldHaveContinuousControls() {
        return !this.m_model.isEditing() || !this.m_model.isFixedRecording();
    }

    private void findToolTipText(Control control, String key) {
        IOptionDescriptor descriptor = this.m_model.getAvailableRecordingOptions().get(key);
        if (descriptor != null) {
            control.setToolTipText(descriptor.getDescription());
        }
    }

    protected void openTemplateManager() {
        Dialog dialog = TemplateManagerWizardPage.createDialogFor(this.getShell(), this.m_model.getTemplateRepository(), this.m_model.getInitialEventTypeSettings(), this.m_model.getEventTypeInfoMap());
        dialog.open();
        this.refresh();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            IRecordingConfiguration template = this.m_model.getCurrentConfigurationAt(0);
            IRecordingConfiguration active = this.m_model.getActiveConfiguration();
            if (template != null && !active.equalSettings((IEventSettingsHolder)template)) {
                this.setMessage(Messages.START_RECORDING_WIZARD_LATER_STAGE_CHANGE_WARNING, 2);
            } else {
                this.setMessage(null);
            }
            this.validateSettings();
        }
        super.setVisible(visible);
    }
}

