/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.dial;

import com.jrockit.mc.ui.accessibility.FocusTracker;
import com.jrockit.mc.ui.dial.DialInformationViewer;
import com.jrockit.mc.ui.dial.DialViewer;
import com.jrockit.mc.ui.dial.Messages;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class Dial {
    private Composite m_dialComposite;
    private DialViewer m_dialViewer;
    private DialInformationViewer m_dialInformationViewer;
    private CLabel m_noValuesYetLabel;
    private StackLayout stackLayout = new StackLayout();

    protected void enableNoValueYetVeil(boolean enabled) {
        Object newTop;
        Object object = newTop = enabled ? this.m_noValuesYetLabel : this.m_dialInformationViewer;
        if (this.stackLayout.topControl != newTop) {
            this.stackLayout.topControl = newTop;
            this.m_dialComposite.layout(true, true);
        }
    }

    public boolean setInput(Object input) {
        this.enableNoValueYetVeil(false);
        boolean updated = false;
        updated = this.getDialViewer().setInput(input) || updated;
        updated = this.getDialInformationViewer().setInput(input) || updated;
        this.getDialViewer().refresh();
        this.getDialInformationViewer().refresh();
        return updated;
    }

    protected Composite createDialComposite(Composite parent, FormToolkit formToolkit) {
        this.m_dialComposite = new Composite(parent, 0){

            public boolean setFocus() {
                if (Dial.this.m_dialViewer != null && !Dial.this.m_dialViewer.isDisposed()) {
                    return Dial.this.m_dialViewer.setFocus();
                }
                return Dial.this.m_dialComposite.setFocus();
            }
        };
        formToolkit.adapt(this.m_dialComposite);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.m_dialComposite.setLayout((Layout)layout);
        this.m_dialViewer = new DialViewer(this.m_dialComposite, 0);
        FocusTracker.enableFocusTracking(this.m_dialViewer);
        this.m_dialViewer.setLayoutData(new GridData(4, 4, true, true));
        formToolkit.adapt((Composite)this.m_dialViewer);
        Composite infoPart = new Composite(this.m_dialComposite, 0);
        infoPart.setLayoutData((Object)new GridData(4, 4, true, false));
        infoPart.setLayout((Layout)this.stackLayout);
        this.m_noValuesYetLabel = new CLabel(infoPart, 0x1000000);
        this.m_noValuesYetLabel.setText(Messages.DialViewer_NO_VALUE_YET_TEXT);
        formToolkit.adapt((Composite)this.m_noValuesYetLabel);
        this.stackLayout.topControl = this.m_noValuesYetLabel;
        this.m_dialInformationViewer = new DialInformationViewer(infoPart, formToolkit, 0);
        formToolkit.adapt((Composite)this.m_dialInformationViewer);
        formToolkit.paintBordersFor(this.m_dialComposite);
        return this.m_dialComposite;
    }

    public DialViewer getDialViewer() {
        return this.m_dialViewer;
    }

    protected DialInformationViewer getDialInformationViewer() {
        return this.m_dialInformationViewer;
    }

    public void dispose() {
        if (this.m_dialComposite != null && !this.m_dialComposite.isDisposed()) {
            this.m_dialComposite.dispose();
        }
    }
}

