/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.dial;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.ui.misc.ColorConstants;
import com.jrockit.mc.ui.misc.MCColor;
import org.w3c.dom.Element;

public class DialConfiguration
implements XmlEnabled {
    public static final String XKL_TAG_DIAL_CONFIGURATION = "dialConfiguration";
    private static final String KEY_MULTIPLIER = "multipler";
    private static final String KEY_USE_WATERMARK = "useWatermark";
    private static final String KEY_GRADIENT_BEGIN_VALUE = "gradientBeginValue";
    private static final String KEY_GRADIENT_END_VALUE = "gradientEndValue";
    private static final String KEY_GRADIENT_BEGIN_COLOR = "gradientBeginColor";
    private static final String KEY_GRADIENT_END_COLOR = "gradientEndColor";
    private static final String KEY_WATERMARK_COLOR = "watermarkColor";
    private static final String KEY_TITLE = "title";
    private static final String KEY_VALUETYPE = "valueType";
    private MCColor m_gradientBeginColor = ColorConstants.DIAL_GOOD_COLOR.create();
    private MCColor m_gradientEndColor = ColorConstants.DIAL_BAD_COLOR.create();
    private MCColor m_waterMarkColor = ColorConstants.DIAL_MAX_COLOR.create();
    private double m_multiplier = 1.0;
    private double m_gradientBeginValue = Double.NEGATIVE_INFINITY;
    private double m_gradientEndValue = Double.NEGATIVE_INFINITY;
    private String m_title = "";
    private String m_valueType = "small.number";
    private boolean m_useWatermark = true;

    public String getTitle() {
        return this.m_title;
    }

    public double getMultiplier() {
        return this.m_multiplier;
    }

    public MCColor getWatermarkColor() {
        return this.m_waterMarkColor;
    }

    public MCColor getGradientBeginColor() {
        return this.m_gradientBeginColor;
    }

    public void setGradientBeginColor(MCColor color) {
        this.m_gradientBeginColor = color;
    }

    public void setGradientEndColor(MCColor color) {
        this.m_gradientEndColor = color;
    }

    public double getGradientBeginValue() {
        return this.m_gradientBeginValue;
    }

    public double getGradientEndValue() {
        return this.m_gradientEndValue;
    }

    public MCColor getGradientEndColor() {
        return this.m_gradientEndColor;
    }

    public void setTitle(String text) {
        this.m_title = text;
    }

    public void setValueType(String valueType) {
        this.m_valueType = valueType;
    }

    public void setMultiplier(double multiplier) {
        this.m_multiplier = multiplier;
    }

    public boolean getUseWatermark() {
        return this.m_useWatermark;
    }

    public void setUseWatermark(boolean useWatermark) {
        this.m_useWatermark = useWatermark;
    }

    public void setGradientBeginValue(double beginValue) {
        this.m_gradientBeginValue = beginValue;
    }

    public void setGradientEndValue(double endValue) {
        this.m_gradientEndValue = endValue;
    }

    public String getValueType() {
        return this.m_valueType;
    }

    public void setWatermarkColor(MCColor color) {
        this.m_waterMarkColor = color;
    }

    public void exportToXml(Element parentNode) {
        Element dialNode = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        XmlToolkit.setSetting((Element)dialNode, (String)KEY_MULTIPLIER, (double)this.m_multiplier);
        XmlToolkit.setSetting((Element)dialNode, (String)KEY_TITLE, (String)this.m_title);
        XmlToolkit.setSetting((Element)dialNode, (String)KEY_VALUETYPE, (String)this.m_valueType);
        XmlToolkit.setSetting((Element)dialNode, (String)KEY_USE_WATERMARK, (boolean)this.m_useWatermark);
        if (this.m_gradientBeginValue != Double.NEGATIVE_INFINITY) {
            XmlToolkit.setSetting((Element)dialNode, (String)KEY_GRADIENT_BEGIN_VALUE, (double)this.m_gradientBeginValue);
        }
        if (this.m_gradientEndValue != Double.NEGATIVE_INFINITY) {
            XmlToolkit.setSetting((Element)dialNode, (String)KEY_GRADIENT_END_VALUE, (double)this.m_gradientEndValue);
        }
        Element e1 = XmlToolkit.createElement((Element)dialNode, (String)KEY_GRADIENT_BEGIN_COLOR);
        this.m_gradientBeginColor.exportToXml(e1);
        Element e2 = XmlToolkit.createElement((Element)dialNode, (String)KEY_GRADIENT_END_COLOR);
        this.m_gradientEndColor.exportToXml(e2);
        Element e3 = XmlToolkit.createElement((Element)dialNode, (String)KEY_WATERMARK_COLOR);
        this.m_waterMarkColor.exportToXml(e3);
    }

    public String getComponentTag() {
        return XKL_TAG_DIAL_CONFIGURATION;
    }

    public void initializeFromXml(Element node) throws Exception {
        this.m_multiplier = XmlToolkit.getSetting((Element)node, (String)KEY_MULTIPLIER, (double)this.m_multiplier);
        this.m_title = XmlToolkit.getSetting((Element)node, (String)KEY_TITLE, (String)this.m_title);
        this.m_valueType = XmlToolkit.getSetting((Element)node, (String)KEY_VALUETYPE, (String)this.m_valueType);
        this.m_useWatermark = XmlToolkit.getSetting((Element)node, (String)KEY_USE_WATERMARK, (boolean)this.m_useWatermark);
        this.m_gradientBeginValue = XmlToolkit.getSetting((Element)node, (String)KEY_GRADIENT_BEGIN_VALUE, (double)this.m_gradientBeginValue);
        this.m_gradientEndValue = XmlToolkit.getSetting((Element)node, (String)KEY_GRADIENT_END_VALUE, (double)this.m_gradientEndValue);
        this.initializeColor(node, KEY_GRADIENT_BEGIN_COLOR, this.m_gradientBeginColor);
        this.initializeColor(node, KEY_GRADIENT_END_COLOR, this.m_gradientEndColor);
        this.initializeColor(node, KEY_WATERMARK_COLOR, this.m_waterMarkColor);
    }

    private void initializeColor(Element parentNode, String tag, MCColor color) throws Exception {
        Element colorNode;
        Element node = XmlToolkit.getFirstChildNodeByTag((Element)parentNode, (String)tag);
        if (node != null && (colorNode = XmlToolkit.getFirstChildNodeByTag((Element)node, (String)"color")) != null) {
            color.initializeFromXml(colorNode);
        }
    }
}

