/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.dial;

import com.jrockit.mc.ui.accessibility.FocusTracker;
import com.jrockit.mc.ui.accessibility.SimpleTraverseListener;
import com.jrockit.mc.ui.dial.IDialInformationProvider;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public final class DialInformationViewer
extends Composite {
    private final Map<String, DialInformationWidget> m_dialInformationWidgets = new LinkedHashMap<String, DialInformationWidget>();
    private final Map<String, IDialInformationProvider> m_dialInformation = new LinkedHashMap<String, IDialInformationProvider>();
    private final Map<String, Object> m_inputs = new LinkedHashMap<String, Object>();
    private final FormToolkit m_toolkit;

    public DialInformationViewer(Composite parent, FormToolkit toolkit, int style) {
        super(parent, style);
        this.m_toolkit = toolkit;
        this.addTraverseListener(new SimpleTraverseListener(true));
    }

    public IDialInformationProvider getDialInformationProvider(String identfier) {
        return this.m_dialInformation.get(identfier);
    }

    public void addDialInformationProvider(String identifier, IDialInformationProvider information) {
        this.m_dialInformation.put(identifier, information);
        this.disposeWidgets();
        this.createWidgets();
    }

    public void removeDialInformationProvider(IDialInformationProvider information) {
        for (Map.Entry<String, IDialInformationProvider> entry : this.m_dialInformation.entrySet()) {
            if (entry.getValue() != information) continue;
            this.m_dialInformation.remove(entry.getKey());
            break;
        }
        this.disposeWidgets();
        this.createWidgets();
    }

    public void clear() {
        this.disposeWidgets();
        this.m_dialInformation.clear();
    }

    public boolean setInput(String identifier, Object input) {
        return this.m_inputs.put(identifier, input) != input;
    }

    public void refresh() {
        Iterator<String> iterator = this.m_dialInformationWidgets.keySet().iterator();
        while (iterator.hasNext()) {
            String element;
            String identifier = element = iterator.next();
            DialInformationWidget widget = this.m_dialInformationWidgets.get(identifier);
            widget.setInput(this.getInput(identifier));
            widget.refresh();
        }
    }

    public boolean setInput(Object input) {
        boolean updated = false;
        for (String element : this.m_dialInformation.keySet()) {
            String identifier = element;
            if (this.m_inputs.put(identifier, input) == input) continue;
            updated = true;
        }
        return updated;
    }

    public void dispose() {
        this.clear();
    }

    private Object getInput(String id) {
        return this.m_inputs.get(id);
    }

    private void createWidgets() {
        int columnIndex = 0;
        for (String element : this.m_dialInformation.keySet()) {
            String identifier = element;
            IDialInformationProvider info = this.m_dialInformation.get(identifier);
            if (info == null) continue;
            TableWrapData td = new TableWrapData(256, 16);
            Control dialInfoWidget = this.createWidget(this.calculateStyle(columnIndex, this.m_dialInformation.size()), identifier, info);
            dialInfoWidget.setLayoutData((Object)td);
            ++columnIndex;
        }
        this.setLayout((Layout)this.createWidgetLayout(this.m_dialInformation.size()));
        this.layout(true, true);
    }

    private Control createWidget(int style, String identifier, IDialInformationProvider provider) {
        DialInformationWidget widget = new DialInformationWidget(this, style, provider);
        this.m_toolkit.adapt((Composite)widget);
        FocusTracker.enableFocusTracking((Composite)widget);
        this.m_dialInformationWidgets.put(identifier, widget);
        return widget;
    }

    private TableWrapLayout createWidgetLayout(int columnCount) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 0;
        layout.bottomMargin = 0;
        layout.leftMargin = 0;
        layout.rightMargin = 0;
        layout.numColumns = columnCount;
        layout.makeColumnsEqualWidth = true;
        return layout;
    }

    private int calculateStyle(int columnIndex, int columnCount) {
        if (columnCount > 1) {
            if (columnIndex == 0) {
                return 131072;
            }
            if (columnIndex == columnCount - 1) {
                return 16384;
            }
        }
        return 0x1000000;
    }

    private void disposeWidgets() {
        Iterator<DialInformationWidget> iterator = this.m_dialInformationWidgets.values().iterator();
        while (iterator.hasNext()) {
            DialInformationWidget element;
            DialInformationWidget widget = element = iterator.next();
            widget.dispose();
        }
        this.m_dialInformationWidgets.clear();
    }

    private static class DialInformationWidget
    extends CLabel {
        private final IDialInformationProvider m_provider;
        private Object m_input;

        public DialInformationWidget(Composite parent, int style, IDialInformationProvider provider) {
            super(parent, style);
            this.m_provider = provider;
        }

        public void setInput(Object input) {
            this.m_input = input;
        }

        public void refresh() {
            String text = String.valueOf(this.m_provider.getName(this.m_input)) + ' ' + this.m_provider.getValue(this.m_input);
            this.setText(text);
            this.setToolTipText(this.m_provider.getDescription(this.m_input));
        }
    }
}

