/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.dial;

import com.jrockit.mc.common.environment.OS;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.accessibility.AccessibilityConstants;
import com.jrockit.mc.ui.accessibility.MCAccessibleListener;
import com.jrockit.mc.ui.dial.IDeviceDescription;
import com.jrockit.mc.ui.dial.IDialProvider;
import com.jrockit.mc.ui.dial.ImageDescription;
import com.jrockit.mc.ui.misc.IRefreshable;
import com.jrockit.mc.ui.misc.IToolTipTextProvider;
import com.jrockit.mc.ui.misc.MCColor;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class DialViewer
extends Composite
implements IRefreshable {
    private static final int TITLE_VERTICAL_PADDING = 3;
    private static final String DRAW_PROPERTY = "com.jrockit.mc.ui.dial.immediatedraw";
    private static final boolean IMMEDIATE_DRAWING;
    private final Map<String, IDialProvider> m_dials = new LinkedHashMap<String, IDialProvider>();
    private final Map<String, Object> m_inputs = new LinkedHashMap<String, Object>();
    private final MCAccessibleListener m_accessibleListener;
    private IToolTipTextProvider m_toolTipTextProvider;
    private final MouseTrackListener m_tooltipListenerListener = this.createMouseTrackListener();
    private Range m_gradientRange = new Range(Double.NaN, Double.NaN);
    private MCColor m_gradientBeginColor;
    private MCColor m_gradientEndColor;
    private IDeviceDescription m_deviceDescription;
    private ImageDescription m_lastImageDescription;
    private Image m_lastBackGroundImage;
    private int m_lastWidth = 0;
    private int m_lastHeight = 0;
    private String m_title;
    private int m_lastYOffset = 0;

    static {
        boolean drawImmediately = System.getProperty(DRAW_PROPERTY) != null ? Boolean.getBoolean(DRAW_PROPERTY) : OS.getType() == OS.Type.MAC;
        IMMEDIATE_DRAWING = drawImmediately;
    }

    public DialViewer(Composite parent, int style) {
        super(parent, 0x20000000);
        this.m_accessibleListener = new MCAccessibleListener();
        this.m_accessibleListener.setComponentType(AccessibilityConstants.COMPONENT_TYPE_DIAL);
        this.getAccessible().addAccessibleListener((AccessibleListener)this.m_accessibleListener);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                DialViewer.this.draw(e.gc, 0, 0, DialViewer.this.getClientArea().width, DialViewer.this.getClientArea().height, false);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (DialViewer.this.m_lastBackGroundImage != null && !DialViewer.this.m_lastBackGroundImage.isDisposed()) {
                    DialViewer.this.m_lastBackGroundImage.dispose();
                    DialViewer.this.m_lastBackGroundImage = null;
                }
            }
        });
    }

    MouseTrackListener createMouseTrackListener() {
        return new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                IToolTipTextProvider toolTipTextProvider = DialViewer.this.getToolTipTextProvider();
                if (toolTipTextProvider != null && DialViewer.this.mouseHoversOverDial(e.x, e.y)) {
                    DialViewer.this.setToolTipText(toolTipTextProvider.getToolTipText(null));
                } else {
                    DialViewer.this.setToolTipText(null);
                }
            }

            public void mouseExit(MouseEvent e) {
                DialViewer.this.setToolTipText(null);
            }
        };
    }

    private boolean mouseHoversOverDial(int x, int y) {
        int drawnX = this.getBounds().width / 2;
        int drawnY = this.m_lastImageDescription.origin.y + this.m_lastYOffset;
        double deltaX = x - drawnX;
        double deltaY = y - drawnY;
        double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        return deltaY <= 0.0 && distance < 108.0;
    }

    public void setTitle(String title) {
        if (!this.isDisposed()) {
            this.m_accessibleListener.setName(title);
            this.m_title = title;
            this.redraw();
        }
    }

    public String getText() {
        return this.m_title;
    }

    public void setDeviceDescription(IDeviceDescription provider) {
        this.m_deviceDescription = provider;
        this.m_lastBackGroundImage = null;
        this.m_lastWidth = -1;
        this.m_lastHeight = -1;
    }

    private Point normalizedToDevice(ImageDescription config, int xOffset, int yOffset, double radius, double normalizedValue) {
        double radians = config.imageFunction.toRadians(normalizedValue);
        return new Point(xOffset += config.origin.x + (int)Math.round(radius * Math.cos(radians)), yOffset += config.origin.y - (int)Math.round(radius * Math.sin(radians)));
    }

    public void setGradientRange(double start, double end, MCColor gradientBeginColor, MCColor gradientEndColor) {
        this.m_gradientRange = new Range(start, end);
        this.m_gradientBeginColor = gradientBeginColor;
        this.m_gradientEndColor = gradientEndColor;
    }

    public void addDialProvider(String identifier, IDialProvider provider) {
        this.m_dials.put(identifier, provider);
    }

    public boolean removeDialProvider(String identifier) {
        return this.m_dials.remove(identifier) != null;
    }

    public IToolTipTextProvider getToolTipTextProvider() {
        return this.m_toolTipTextProvider;
    }

    public void setToolTipTextProvider(IToolTipTextProvider provider) {
        this.removeMouseTrackListener(this.m_tooltipListenerListener);
        this.m_toolTipTextProvider = provider;
        if (this.m_toolTipTextProvider != null) {
            this.addMouseTrackListener(this.m_tooltipListenerListener);
        }
    }

    @Override
    public boolean refresh() {
        if (!this.isDisposed()) {
            if (IMMEDIATE_DRAWING) {
                if (this.isVisible()) {
                    GC gc = new GC((Drawable)this);
                    this.draw(gc, 0, 0, this.getClientArea().width, this.getClientArea().height, true);
                    gc.dispose();
                }
            } else {
                this.redraw();
            }
            return true;
        }
        return false;
    }

    public boolean setInput(String identifier, Object input) {
        Object oldInput = this.getInput(identifier);
        if (oldInput != input) {
            this.m_inputs.put(identifier, input);
            return true;
        }
        return false;
    }

    private Range createNormalizedGradientRange(Range worldRange) {
        double start = this.m_gradientRange.start;
        double end = this.m_gradientRange.end;
        double nA = this.normalizeForDevice(worldRange.start, worldRange.end, start);
        double nB = this.normalizeForDevice(worldRange.start, worldRange.end, end);
        return new Range(Math.min(nA, nB), Math.max(nA, nB));
    }

    private void drawGradientBackground(GC gc, ImageDescription config, Range worldRange, RGB startRGB, RGB endRGB) {
        Range gradRange = this.createNormalizedGradientRange(worldRange);
        Color oldColor = gc.getBackground();
        double n = 1.0;
        while (n >= 0.0) {
            Color color = this.createColor(gc.getDevice(), startRGB, endRGB, n, gradRange);
            gc.setBackground(color);
            this.fillArc(gc, config, n);
            color.dispose();
            n -= 0.01;
        }
        gc.setBackground(oldColor);
    }

    private Color createColor(Device device, RGB startRGB, RGB endRGB, double n, Range gradRange) {
        if (n < gradRange.start) {
            return new Color(device, startRGB);
        }
        if (n > gradRange.end) {
            return new Color(device, endRGB);
        }
        return new Color(device, DialViewer.blend(startRGB, endRGB, DialViewer.normalize(gradRange.start, gradRange.end, n)));
    }

    private void fillArc(GC gc, ImageDescription config, double n) {
        int r = (int)Math.round(config.gradientRadius);
        int lA = (int)Math.round(Math.toDegrees(config.imageFunction.toRadians(0.0)));
        int rA = (int)Math.round(Math.toDegrees(config.imageFunction.toRadians(n)));
        gc.fillArc(config.origin.x - r, config.origin.y - r, 2 * r, 2 * r, rA, lA - rA);
    }

    private double normalizeForDevice(double start, double end, double value) {
        double multiplier = this.m_deviceDescription.getNormalizationFactor(start, end);
        return value / multiplier;
    }

    private static double normalize(double start, double end, double value) {
        double total = end - start;
        return total != 0.0 ? (value - start) / total : 0.0;
    }

    private static RGB blend(RGB a, RGB b, double p) {
        return new RGB(DialViewer.interpolateRGB(a.red, b.red, p), DialViewer.interpolateRGB(a.green, b.green, p), DialViewer.interpolateRGB(a.blue, b.blue, p));
    }

    private static int interpolateRGB(int startValue, int endValue, double percentage) {
        return (int)((long)startValue + Math.round(percentage * (double)(endValue - startValue)));
    }

    public Collection<IDialProvider> getDialProviders() {
        return Collections.unmodifiableCollection(this.m_dials.values());
    }

    public Collection<String> getDialProvidersID() {
        return Collections.unmodifiableCollection(this.m_dials.keySet());
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        IDeviceDescription idd = this.getDeviceDescription();
        if (idd == null) {
            return new Point(0, 0);
        }
        ImageDescription imageDescription = idd.getImageDescription(0.0, 100.0);
        Rectangle imageBounds = imageDescription.image.getBounds();
        Point size = this.computeTitleSize();
        size.x = Math.max(size.x, imageBounds.width);
        size.y += imageBounds.height;
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    private Point computeTitleSize() {
        if (this.m_title == null) {
            return new Point(0, 0);
        }
        GC gc = new GC((Drawable)this);
        Font oldFont = gc.getFont();
        FontData[] fontData = oldFont.getFontData();
        Font newFont = new Font(gc.getDevice(), fontData[0].getName(), fontData[0].getHeight(), 1);
        gc.setFont(newFont);
        Point size = gc.textExtent(this.m_title);
        size.y += 3;
        newFont.dispose();
        gc.dispose();
        return size;
    }

    private void draw(GC gc, int x, int y, int width, int height, boolean drawOptimal) {
        IDeviceDescription idd = this.getDeviceDescription();
        if (idd != null) {
            int xOffset = (width - idd.getSize().x) / 2;
            xOffset = Math.max(0, xOffset);
            Range dialsRange = new Range(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY);
            String[] identifiers = this.getDialProvidersID().toArray(new String[this.getDialProvidersID().size()]);
            MCColor[] colors = new MCColor[identifiers.length];
            double[] values = new double[identifiers.length];
            int n = 0;
            while (n < identifiers.length) {
                IDialProvider provider = this.getDialProvider(identifiers[n]);
                if (provider != null) {
                    Object input = this.getInput(identifiers[n]);
                    colors[n] = provider.getColor(input);
                    values[n] = provider.getValue(input);
                    if (values[n] != Double.NEGATIVE_INFINITY) {
                        dialsRange.start = Math.min(dialsRange.start, values[n]);
                        dialsRange.end = Math.max(dialsRange.end, values[n]);
                    }
                }
                ++n;
            }
            ImageDescription imageDescription = idd.getImageDescription(dialsRange.start, dialsRange.end);
            int yOffset = height - imageDescription.image.getBounds().height;
            Image image = this.getBackgroundImage(gc, imageDescription, dialsRange, width, height, xOffset, 0);
            if (image != null) {
                this.m_lastYOffset = yOffset;
                gc.drawImage(image, 0, yOffset);
            }
            gc.setAntialias(1);
            if (!drawOptimal && this.m_title != null) {
                this.drawTitle(gc, xOffset, height, imageDescription, this.m_title);
            }
            this.drawDialText(gc, xOffset, yOffset, imageDescription, this.getDeviceDescription().getText(dialsRange.start, dialsRange.end));
            Color oldBackground = gc.getBackground();
            int oldAlpha = gc.getAlpha();
            int oldAntiAlias = gc.getAntialias();
            int n2 = 0;
            while (n2 < identifiers.length) {
                if (values[n2] != Double.NEGATIVE_INFINITY) {
                    this.drawDial(gc, xOffset, yOffset, imageDescription, dialsRange, values[n2], colors[n2].getAlpha(), colors[n2]);
                }
                ++n2;
            }
            gc.setAntialias(oldAntiAlias);
            gc.setAlpha(oldAlpha);
            gc.setBackground(oldBackground);
        }
    }

    private Object getInput(String key) {
        return this.m_inputs.get(key);
    }

    public IDeviceDescription getDeviceDescription() {
        return this.m_deviceDescription;
    }

    private Image getBackgroundImage(GC gc, ImageDescription imageDescription, Range range, int width, int height, int xOffset, int yOffset) {
        if (!imageDescription.equals(this.m_lastImageDescription) || this.m_lastBackGroundImage == null || this.m_lastWidth != width || this.m_lastHeight != height) {
            this.createBackground(gc, range, imageDescription, width, height, xOffset, yOffset);
            this.m_lastImageDescription = imageDescription;
            this.m_lastHeight = height;
            this.m_lastWidth = width;
        }
        return this.m_lastBackGroundImage;
    }

    private void createBackground(GC gc, Range range, ImageDescription imageDescription, int width, int height, int xOffset, int yOffset) {
        if (this.m_lastBackGroundImage != null) {
            this.m_lastBackGroundImage.dispose();
        }
        this.m_lastBackGroundImage = new Image((Device)this.getDisplay(), width, height);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (DialViewer.this.m_lastBackGroundImage != null && !DialViewer.this.m_lastBackGroundImage.isDisposed()) {
                    DialViewer.this.m_lastBackGroundImage.dispose();
                    DialViewer.this.removeDisposeListener(this);
                }
            }
        });
        GC fullBackgroundGC = new GC((Drawable)this.m_lastBackGroundImage);
        Image panelImage = new Image((Device)this.getDisplay(), imageDescription.image.getBounds().width, imageDescription.image.getBounds().height);
        GC dialGC = new GC((Drawable)panelImage);
        Image g = UIPlugin.getDefault().getImage("dial-bkgnd.png");
        int i = 0;
        while (i < panelImage.getBounds().width) {
            dialGC.drawImage(g, i, 0);
            i += g.getBounds().width;
        }
        this.drawBackground(dialGC, imageDescription, range);
        dialGC.dispose();
        i = 0;
        while (i < this.m_lastBackGroundImage.getBounds().width) {
            fullBackgroundGC.drawImage(g, i, yOffset);
            i += g.getBounds().width;
        }
        fullBackgroundGC.drawImage(panelImage, xOffset, yOffset);
        fullBackgroundGC.dispose();
        panelImage.dispose();
    }

    private void drawTitle(GC gc, int xOffset, int height, ImageDescription config, String text) {
        Font oldFont = gc.getFont();
        FontData[] fontData = oldFont.getFontData();
        Font newFont = new Font(gc.getDevice(), fontData[0].getName(), fontData[0].getHeight(), 1);
        gc.setFont(newFont);
        Point textExtent = gc.textExtent(text);
        int x = config.dialTextCenter.x - Math.round((float)textExtent.x / 2.0f);
        int y = height - config.image.getBounds().height - 3 - textExtent.y;
        y = Math.max(0, y);
        Color c = UIPlugin.getDefault().getFormColors(this.getDisplay()).getColor("org.eclipse.ui.forms.TITLE");
        gc.setForeground(c);
        gc.setAlpha(192);
        gc.drawString(text, x + xOffset, y, true);
        gc.setAlpha(255);
        gc.setFont(oldFont);
        newFont.dispose();
    }

    private void drawDialText(GC gc, int xOffset, int YOffset, ImageDescription config, String text) {
        Font oldFont = gc.getFont();
        FontData[] fontData = oldFont.getFontData();
        Font newFont = new Font(gc.getDevice(), fontData[0].getName(), fontData[0].getHeight(), 1);
        gc.setFont(newFont);
        Point textExtent = gc.textExtent(text);
        int x = config.dialTextCenter.x - textExtent.x / 2 + xOffset;
        int y = config.dialTextCenter.y - textExtent.y / 2 + YOffset;
        Color foreground = new Color(gc.getDevice(), 0, 0, 0);
        gc.setForeground(foreground);
        gc.setAlpha(192);
        gc.drawString(text, x, y, true);
        gc.setAlpha(255);
        foreground.dispose();
        gc.setFont(oldFont);
        newFont.dispose();
    }

    private void drawDial(GC gc, int x, int y, ImageDescription config, Range worldRange, double value, double transparency, MCColor color) {
        double nValue = this.normalizeForDevice(worldRange.start, worldRange.end, value);
        Point gaugeStart = this.normalizedToDevice(config, x, y, config.dialStartRadius, nValue);
        Point gaugeEnd = this.normalizedToDevice(config, x, y, config.dialEndRadius, nValue);
        Point gaugeEdge1 = this.normalizedToDevice(config, x, y, config.dialStartRadius, nValue + 0.02);
        Point gaugeEdge2 = this.normalizedToDevice(config, x, y, config.dialStartRadius, nValue - 0.02);
        int[] edges = new int[]{gaugeEnd.x, gaugeEnd.y, gaugeEdge1.x, gaugeEdge1.y, gaugeEdge2.x, gaugeEdge2.y};
        Color fillColor = color.createSWTColor(gc.getDevice());
        gc.setAlpha(color.getAlpha());
        gc.setBackground(fillColor);
        gc.setForeground(fillColor);
        gc.fillPolygon(edges);
        gc.drawPolygon(edges);
        gc.drawLine(gaugeStart.x, gaugeStart.y, gaugeEnd.x, gaugeEnd.y);
        fillColor.dispose();
    }

    private void drawBackground(GC gc, ImageDescription config, Range range) {
        if (!Double.isNaN(this.m_gradientRange.start) && !Double.isNaN(this.m_gradientRange.end) && range != null) {
            if (this.hasInfity(this.m_gradientRange.start) || this.hasInfity(this.m_gradientRange.end)) {
                this.drawUnNormalizedbackground(gc, config, this.m_gradientBeginColor.getRGBColor(), this.m_gradientEndColor.getRGBColor());
            } else if (this.m_gradientRange.start < this.m_gradientRange.end) {
                this.drawGradientBackground(gc, config, range, this.m_gradientBeginColor.getRGBColor(), this.m_gradientEndColor.getRGBColor());
            } else {
                this.drawGradientBackground(gc, config, range, this.m_gradientEndColor.getRGBColor(), this.m_gradientBeginColor.getRGBColor());
            }
        }
        gc.drawImage(config.image, 0, 0);
    }

    private void drawUnNormalizedbackground(GC gc, ImageDescription config, RGB startRGB, RGB endRGB) {
        double n = 1.0;
        while (n >= 0.0) {
            Color color = new Color(gc.getDevice(), DialViewer.blend(startRGB, endRGB, n));
            gc.setBackground(color);
            this.fillArc(gc, config, n);
            color.dispose();
            n -= 0.01;
        }
    }

    private boolean hasInfity(double value) {
        return value == Double.NEGATIVE_INFINITY || value == Double.POSITIVE_INFINITY;
    }

    public IDialProvider getDialProvider(String key) {
        return this.m_dials.get(key);
    }

    public boolean setInput(Object input) {
        boolean updated = false;
        for (String element : this.m_dials.keySet()) {
            String identifier = element;
            if (this.m_inputs.put(identifier, input) == input) continue;
            updated = true;
        }
        return updated;
    }

    public void clear() {
        this.m_dials.clear();
        this.m_inputs.clear();
    }

    private static class Range {
        public double start;
        public double end;

        public Range(double start, double end) {
            this.start = start;
            this.end = end;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Range)) {
                return false;
            }
            Range r = (Range)o;
            return r.start == this.start && r.end == this.end;
        }
    }
}

