/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.dial;

import com.jrockit.mc.ui.dial.IImageFunction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class ImageDescription {
    public Image image;
    public Point origin;
    public double dialStartRadius;
    public double dialEndRadius;
    public double gradientRadius;
    public static final int DIAL_RADIUS = 108;
    public IImageFunction imageFunction;
    public Point dialTextCenter;

    public static ImageDescription createStandardConfiguration(Image image) {
        ImageDescription config = new ImageDescription();
        config.image = image;
        config.dialStartRadius = 20.0;
        config.dialEndRadius = config.image.getBounds().width / 2 - 33;
        config.gradientRadius = config.image.getBounds().width / 2 - 10;
        config.origin = new Point(config.image.getBounds().width / 2, config.image.getBounds().height - 1);
        config.imageFunction = new ImageFunction();
        config.dialTextCenter = new Point(config.origin.x, config.origin.y - 35);
        return config;
    }

    private boolean safeEquals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        return a != null && a.equals(b);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ImageDescription)) {
            return false;
        }
        ImageDescription desc = (ImageDescription)o;
        return o != null && this.safeEquals(desc.image, this.image) && this.safeEquals(desc.origin, this.origin) && desc.dialStartRadius == this.dialStartRadius && desc.dialEndRadius == this.dialEndRadius && desc.gradientRadius == this.gradientRadius && this.safeEquals(desc.dialTextCenter, this.dialTextCenter);
    }

    static class ImageFunction
    implements IImageFunction {
        ImageFunction() {
        }

        @Override
        public double toRadians(double n) {
            return Math.toRadians((-800.0 * n * n * n + 1200.0 * n * n - 1912.0 * n) / 9.0 + 174.0);
        }
    }
}

