/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.dial;

import com.jrockit.mc.ui.dial.IDeviceDescription;
import com.jrockit.mc.ui.dial.ImageDescription;
import org.eclipse.swt.graphics.Point;

public class MultiRangeDeviceDescription
implements IDeviceDescription {
    private final IDeviceDescription[] m_descriptions;
    private final IDeviceDescription m_primary;

    public MultiRangeDeviceDescription(IDeviceDescription primary, IDeviceDescription[] backups) {
        this.m_descriptions = backups;
        this.m_primary = primary;
    }

    public IDeviceDescription getFirstValidDevice(double start, double end) {
        ImageDescription primary = this.m_primary.getImageDescription(start, end);
        if (primary == null) {
            IDeviceDescription[] iDeviceDescriptionArray = this.m_descriptions;
            int n = this.m_descriptions.length;
            int n2 = 0;
            while (n2 < n) {
                IDeviceDescription m_description = iDeviceDescriptionArray[n2];
                if (m_description.getImageDescription(start, end) != null) {
                    return m_description;
                }
                ++n2;
            }
        }
        return this.m_primary;
    }

    @Override
    public ImageDescription getImageDescription(double start, double end) {
        return this.getFirstValidDevice(start, end).getImageDescription(start, end);
    }

    @Override
    public double getNormalizationFactor(double start, double end) {
        return this.getFirstValidDevice(start, end).getNormalizationFactor(start, end);
    }

    @Override
    public String getText(double start, double end) {
        return this.getFirstValidDevice(start, end).getText(start, end);
    }

    @Override
    public Point getSize() {
        return this.m_primary.getSize();
    }

    @Override
    public String getDisplayName() {
        return this.m_primary.getDisplayName();
    }

    @Override
    public String getIdentifier() {
        return this.m_primary.getIdentifier();
    }
}

