/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.dial;

import com.jrockit.mc.ui.misc.IRefreshable;
import java.util.Vector;
import org.eclipse.swt.widgets.Display;

public class RefreshController {
    private final Vector<IRefreshable> m_refreshables = new Vector();
    private final Display m_display;
    private int m_updateInterval = 50;
    private boolean m_keepAlive;

    public RefreshController(Display display) {
        this.m_display = display;
    }

    public void setUpdateInterval(int millis) {
        this.m_updateInterval = millis;
    }

    public long getUpdateInterval() {
        return this.m_updateInterval;
    }

    public void add(IRefreshable refeshable) {
        this.m_refreshables.add(refeshable);
    }

    public void remove(IRefreshable refeshable) {
        this.m_refreshables.remove(refeshable);
    }

    public void stop() {
        this.m_keepAlive = false;
    }

    public void start() {
        if (!this.m_keepAlive) {
            this.m_keepAlive = true;
            this.scheduleUpdate();
        }
    }

    private void scheduleUpdate() {
        this.m_display.timerExec(this.m_updateInterval, new Runnable(){

            @Override
            public void run() {
                if (RefreshController.this.m_keepAlive) {
                    RefreshController.this.update();
                    RefreshController.this.scheduleUpdate();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        IRefreshable[] refreshables;
        Vector<IRefreshable> vector = this.m_refreshables;
        synchronized (vector) {
            refreshables = this.m_refreshables.toArray(new IRefreshable[this.m_refreshables.size()]);
        }
        IRefreshable[] iRefreshableArray = refreshables;
        int n = refreshables.length;
        int n2 = 0;
        while (n2 < n) {
            IRefreshable refreshable = iRefreshableArray[n2];
            refreshable.refresh();
            ++n2;
        }
    }

    public void clear() {
        this.m_refreshables.clear();
    }
}

