/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.dial;

import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.dial.IDeviceDescription;
import com.jrockit.mc.ui.dial.ImageDescription;
import com.jrockit.mc.ui.dial.Messages;
import com.jrockit.mc.ui.model.fields.NormalizedScientificNotationField;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class ScientificDeviceDescription
implements IDeviceDescription {
    public static final String SCIENTIFIC_NOTATION = "scientific.notation";

    @Override
    public ImageDescription getImageDescription(double start, double end) {
        return ImageDescription.createStandardConfiguration(UIPlugin.getDefault().getImage("dial_1_to_10.png"));
    }

    @Override
    public String getText(double start, double end) {
        int exp = NormalizedScientificNotationField.calculateExponential(end);
        if (exp == 0) {
            return "";
        }
        return "\u00d710E" + exp;
    }

    private int getExponent(double end) {
        int exponent = -15;
        while (Math.pow(10.0, exponent) < end) {
            ++exponent;
        }
        return exponent;
    }

    @Override
    public double getNormalizationFactor(double start, double end) {
        return Math.pow(10.0, this.getExponent(end));
    }

    @Override
    public Point getSize() {
        Image image = UIPlugin.getDefault().getImage("dial_1_to_10.png");
        return new Point(image.getBounds().width, image.getBounds().height);
    }

    @Override
    public String getDisplayName() {
        return Messages.ScientificDeviceDescription_SCIENTIFIC_NOTATION_TEXT;
    }

    @Override
    public String getIdentifier() {
        return SCIENTIFIC_NOTATION;
    }
}

