/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.dial;

import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.dial.IDeviceDescription;
import com.jrockit.mc.ui.dial.ImageDescription;
import com.jrockit.mc.ui.dial.ShiftStep;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class ShiftingDeviceDescription
implements IDeviceDescription {
    private final ShiftStep[] m_shifts;
    private final String m_displayName;
    private final String m_identifier;
    private final boolean m_mirrorNegative;

    public ShiftingDeviceDescription(ShiftStep[] shifts, String displayName, String identifier, boolean mirroNegative) {
        this.m_shifts = shifts;
        this.m_displayName = displayName;
        this.m_identifier = identifier;
        this.m_mirrorNegative = mirroNegative;
    }

    private ShiftStep getShift(double value) {
        if (value < 0.0 && this.m_mirrorNegative) {
            int n = 0;
            while (n < this.m_shifts.length) {
                if (-this.m_shifts[n].getEnd() <= value && value <= -this.m_shifts[n].getStart()) {
                    return this.m_shifts[n];
                }
                ++n;
            }
        } else {
            ShiftStep[] shiftStepArray = this.m_shifts;
            int n = this.m_shifts.length;
            int n2 = 0;
            while (n2 < n) {
                ShiftStep m_shift = shiftStepArray[n2];
                if (m_shift.getStart() <= value && value <= m_shift.getEnd()) {
                    return m_shift;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public ImageDescription getImageDescription(double start, double end) {
        ShiftStep shift = this.getShift(end);
        if (shift == null) {
            return null;
        }
        return ImageDescription.createStandardConfiguration(shift.getImage());
    }

    @Override
    public String getText(double start, double end) {
        ShiftStep s = this.getShift(end);
        return s == null ? "" : s.getDialText();
    }

    @Override
    public double getNormalizationFactor(double start, double end) {
        ShiftStep s = this.getShift(end);
        return s == null ? Double.NEGATIVE_INFINITY : s.getNormalizationFactor();
    }

    @Override
    public Point getSize() {
        Image image = UIPlugin.getDefault().getImage("dial_1_to_10.png");
        return new Point(image.getBounds().width, image.getBounds().height);
    }

    @Override
    public String getDisplayName() {
        return this.m_displayName;
    }

    @Override
    public String getIdentifier() {
        return this.m_identifier;
    }
}

