/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.dial;

import com.jrockit.mc.ui.dial.IDialProvider;
import com.jrockit.mc.ui.misc.MCColor;

public class WatermarkDial
implements IDialProvider {
    private double m_maxValue = Double.NEGATIVE_INFINITY;
    private final MCColor m_color;

    public WatermarkDial(MCColor color) {
        this.m_color = color;
        this.m_color.setAlpha(50);
    }

    @Override
    public MCColor getColor(Object input) {
        return this.m_color;
    }

    @Override
    public double getValue(Object input) {
        this.m_maxValue = Math.max(this.getDoubleValue(input), this.m_maxValue);
        return this.m_maxValue;
    }

    private double getDoubleValue(Object input) {
        if (input instanceof Number) {
            return ((Number)input).doubleValue();
        }
        return Double.NEGATIVE_INFINITY;
    }

    public void clearWatermark() {
        this.m_maxValue = Double.NEGATIVE_INFINITY;
    }
}

