/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.dnd;

public class TableStringBuilder {
    private static final String CRLF = "\r\n";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String SPACE_INDENT = "   ";
    private static final String TAB = "\t";
    private static final String SEMI_COLON = ";";
    private static final String QUOTE = "\"";
    private static final String DOUBLE_QUOTE = "\"\"";
    private static final String LEFT_PARENTHESIS = "(";
    private static final String RIGHT_PARENTHESIS = ")";
    private StringBuilder builder = new StringBuilder();
    private boolean newLine = true;
    private boolean formatAsCsv;

    public TableStringBuilder(boolean formatAsCsv) {
        this.formatAsCsv = formatAsCsv;
    }

    public void appendNewLine() {
        this.builder.append(this.formatAsCsv ? CRLF : LINE_SEPARATOR);
        this.newLine = true;
    }

    private void appendColumnSeparator() {
        if (this.newLine) {
            this.newLine = false;
        } else {
            this.builder.append(this.formatAsCsv ? SEMI_COLON : TAB);
        }
    }

    public void appendCellHeader(String header, String unit) {
        this.appendColumnSeparator();
        String fieldStr = String.valueOf(header) + (unit == null ? "" : LEFT_PARENTHESIS + unit + RIGHT_PARENTHESIS);
        this.builder.append(this.escapeCell(fieldStr));
    }

    public void appendCell(String cellValue, int indents) {
        indents = this.newLine ? indents : 0;
        this.appendColumnSeparator();
        StringBuilder cellStringBuilder = new StringBuilder();
        int n = 0;
        while (n < indents) {
            cellStringBuilder.append(SPACE_INDENT);
            ++n;
        }
        cellStringBuilder.append(cellValue);
        this.builder.append(this.escapeCell(cellStringBuilder.toString()));
    }

    private String escapeCell(String str) {
        return this.formatAsCsv ? QUOTE + str.replaceAll(QUOTE, DOUBLE_QUOTE) + QUOTE : str;
    }

    public String toString() {
        return this.builder.toString();
    }
}

