/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.fields;

import com.jrockit.mc.ui.accessibility.FocusTracker;
import com.jrockit.mc.ui.fields.AbstractFieldTableContentProvider;
import com.jrockit.mc.ui.fields.FieldLabelProvider;
import com.jrockit.mc.ui.misc.IColorProvider;
import com.jrockit.mc.ui.misc.MCColor;
import com.jrockit.mc.ui.misc.ToolTipManager;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.Row;
import com.jrockit.mc.ui.model.fields.StructuredRowSelection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormText;

public final class PieFieldViewer
extends ContentViewer {
    private static final int ANTI_ALIASING_MARGIN = 10;
    private static final int LINE_WIDTH = 1;
    private static final MCColor PIE_OUTILNE_COLOR = new MCColor(0, 0, 0);
    private static final MCColor PIE_NOT_VALID_COLOR = new MCColor(192, 192, 192);
    private static final int START_ANGLE_OFFSET = 90;
    private Field m_dataField;
    private Control m_control;
    private ToolTipProvider m_tooltipProvider = new ToolTipProvider();
    private Object m_input;
    private ISelection m_selection = StructuredSelection.EMPTY;

    public PieFieldViewer(Composite parent) {
        this.m_control = this.crearteControl(parent);
    }

    private Control crearteControl(Composite parent) {
        Composite control = new Composite(parent, 0x20000000);
        this.hookPaintListener(control);
        this.hookAccessibleListener(control);
        this.hookTooltipListener(control);
        this.hookFocusListener(control);
        this.hookSelectionListener(control);
        return control;
    }

    public ISelection getSelection() {
        return this.m_selection;
    }

    public void refresh() {
        this.m_control.redraw();
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.m_selection = selection;
    }

    public Control getControl() {
        return this.m_control;
    }

    public int getMargin() {
        return 10;
    }

    public void setLabelProvider(IBaseLabelProvider provider) {
        if (provider != null && !(provider instanceof FieldLabelProvider)) {
            throw new RuntimeException("LabelProvider must be null or an instance of FieldLabelProvider");
        }
        super.setLabelProvider(provider);
    }

    public void setDataField(Field field) {
        this.m_dataField = field;
    }

    public Field getDataField() {
        return this.m_dataField;
    }

    public void setContentProvider(IContentProvider contentProvider) {
        if (!(contentProvider instanceof AbstractFieldTableContentProvider)) {
            throw new RuntimeException("ContentProvider must be an AbstractFieldTableContentProvider");
        }
        super.setContentProvider(contentProvider);
    }

    protected double getValue(Row element) {
        if (this.m_dataField != null) {
            Object o = element.getColumn(this.m_dataField.INDEX);
            return o instanceof Number ? ((Number)o).doubleValue() : Double.NaN;
        }
        return Double.NaN;
    }

    protected double getTotal(Row[] elements) {
        double total = 0.0;
        Row[] rowArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Row element = rowArray[n2];
            total += this.getValue(element);
            ++n2;
        }
        return total;
    }

    private Field[] getFields() {
        if (this.getFieldLabelProvider() != null) {
            return this.getFieldLabelProvider().getFields();
        }
        return null;
    }

    private void drawDropShadow(GC gc, Point center, int radius) {
        if (radius < 1) {
            return;
        }
        gc.setAntialias(1);
        int r = 0;
        while (r < 8) {
            Color d = new Color(gc.getDevice(), 250 - r * 12, 250 - r * 12, 250 - r * 12);
            gc.setBackground(d);
            gc.fillArc(center.x - radius, center.y - radius, radius * 2 + 8 - r, radius * 2 + 8 - r, 0, 360);
            d.dispose();
            ++r;
        }
        gc.setAntialias(0);
    }

    public Point getCenter() {
        if (this.m_control != null) {
            return new Point(this.m_control.getBounds().width / 2, this.m_control.getBounds().height / 2);
        }
        return null;
    }

    public int getRadius() {
        if (this.m_control != null) {
            return Math.min(this.m_control.getBounds().width / 2, this.m_control.getBounds().height / 2) - this.getMargin();
        }
        return 0;
    }

    public Row[] getRowElements() {
        AbstractFieldTableContentProvider provider = (AbstractFieldTableContentProvider)this.getContentProvider();
        Assert.isNotNull((Object)provider);
        Object[] object = provider.getElements(this.getInput());
        if (object instanceof Row[]) {
            return (Row[])object;
        }
        return new Row[0];
    }

    private void drawBackground(GC gc, Rectangle rect) {
        gc.fillRectangle(rect);
    }

    public boolean hasValidPieData() {
        Row[] elements = this.getRowElements();
        if (elements == null || elements.length == 0) {
            return false;
        }
        Row[] rowArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Row element = rowArray[n2];
            double value = this.getValue(element);
            if (Double.isNaN(value) || value < 0.0) {
                return false;
            }
            ++n2;
        }
        return this.getTotal(elements) > 0.0;
    }

    private static boolean hasValidCenter(Point center) {
        return center != null && center.x >= 0 && center.y > 0;
    }

    private IColorProvider getColorProvider() {
        ILabelProvider provider;
        FieldLabelProvider flp = this.getFieldLabelProvider();
        if (flp != null && (provider = flp.getSubProvider()) != null) {
            if (!(provider instanceof IColorProvider)) {
                throw new RuntimeException("Subprovider of FieldLabelProvider must be an instanceof IColorProvider");
            }
            return (IColorProvider)provider;
        }
        return null;
    }

    private FieldLabelProvider getFieldLabelProvider() {
        return (FieldLabelProvider)this.getLabelProvider();
    }

    private GcConfig getGcConfiguration(GC gc) {
        GcConfig gcConfig = new GcConfig();
        gcConfig.forground = gc.getForeground();
        gcConfig.background = gc.getBackground();
        gcConfig.linewidth = gc.getLineWidth();
        gcConfig.antiAlising = gc.getAntialias();
        return gcConfig;
    }

    private void setGcConfiguration(GC gc, GcConfig config) {
        gc.setForeground(config.forground);
        gc.setBackground(config.background);
        gc.setLineWidth(config.linewidth);
        gc.setAntialias(config.antiAlising);
    }

    private GcConfig createPieGCConfig(Display display) {
        GcConfig gcConfig = new GcConfig();
        gcConfig.background = PIE_NOT_VALID_COLOR.createSWTColor((Device)display);
        gcConfig.antiAlising = 1;
        gcConfig.forground = PIE_OUTILNE_COLOR.createSWTColor((Device)display);
        gcConfig.linewidth = 1;
        return gcConfig;
    }

    private void drawPie(GC gc, Point center, int radius) {
        IColorProvider colorProvider = this.getColorProvider();
        if (PieFieldViewer.hasValidCenter(center) && radius > 0 && colorProvider != null) {
            GcConfig oldGCConfig = this.getGcConfiguration(gc);
            GcConfig pieConfig = null;
            try {
                pieConfig = this.createPieGCConfig(Display.getDefault());
                this.setGcConfiguration(gc, pieConfig);
                if (this.hasValidPieData()) {
                    this.drawSlices(gc, center, radius, pieConfig);
                } else {
                    this.drawInvalidPie(gc, center, radius, pieConfig);
                }
            }
            finally {
                this.setGcConfiguration(gc, oldGCConfig);
                if (pieConfig != null) {
                    pieConfig.dispose();
                }
            }
        }
    }

    public void setInput(Object input) {
        this.m_input = input;
    }

    public Object getInput() {
        return this.m_input;
    }

    private void drawInvalidPie(GC gc, Point center, int radius, GcConfig pieConfig) {
        gc.setBackground(pieConfig.background);
        this.drawPieSlice(gc, center.x, center.y, radius, 0, 360);
    }

    private void drawSlices(GC gc, Point center, int radius, GcConfig pieConfig) {
        IColorProvider colorProvider = this.getColorProvider();
        Row[] elements = this.getRowElements();
        double total = this.getTotal(elements);
        double normalizedShare = 0.0;
        int startAngle = 0;
        boolean oneSingle = false;
        int n = elements.length - 1;
        while (n >= 0) {
            Color backgroundColor = colorProvider.getColor(elements[n].getElement());
            if (backgroundColor != null) {
                gc.setBackground(backgroundColor);
            } else {
                gc.setBackground(pieConfig.background);
            }
            int nextAngle = (int)(360.0 * (normalizedShare += this.getValue(elements[n]) / total) + 0.5);
            if (nextAngle - startAngle == 360) {
                oneSingle = true;
            }
            if (startAngle != nextAngle) {
                this.drawPieSliceFromOffset(gc, center.x, center.y, radius, startAngle, nextAngle, !oneSingle);
            }
            startAngle = nextAngle;
            --n;
        }
        if (!oneSingle) {
            this.drawPieLine(gc, center.x, center.y, radius, 90);
        }
    }

    public Row getRowAtPosition(int x, int y) {
        Point center = this.getCenter();
        int radius = this.getRadius();
        if (center != null && this.hasValidPieData() && this.isInsideCircle(x, y, center.x, center.y, radius)) {
            double offsetAngle;
            Row[] elements = this.getRowElements();
            double total = this.getTotal(elements);
            double selectedAngle = this.get2PIAngle(center.x, -center.y, x, -y);
            if (selectedAngle < (offsetAngle = 1.5707963267948966)) {
                selectedAngle += Math.PI * 2;
            }
            selectedAngle -= offsetAngle;
            double radian = 0.0;
            int n = elements.length - 1;
            while (n >= 0) {
                if (selectedAngle <= (radian += Math.PI * 2 * this.getValue(elements[n]) / total)) {
                    return elements[n];
                }
                --n;
            }
        }
        return null;
    }

    protected boolean isInsideCircle(int x, int y, int centerX, int centerY, int radius) {
        return (x - centerX) * (x - centerX) + (y - centerY) * (y - centerY) < radius * radius;
    }

    protected double get2PIAngle(int centerX, int centerY, int positionX, int positionY) {
        double angle = Math.atan2(positionY - centerY, positionX - centerX);
        return angle < 0.0 ? angle + Math.PI * 2 : angle;
    }

    protected void drawPieSliceFromOffset(GC gc, int x, int y, int radius, int startAngle, int endAngle, boolean pieLine) {
        int startWithOffset = startAngle + 90;
        int endWithOffset = endAngle + 90;
        this.drawPieSlice(gc, x, y, radius, startWithOffset, endWithOffset - startWithOffset);
        if (pieLine) {
            this.drawPieLine(gc, x, y, radius, startWithOffset);
        }
    }

    private void drawPieLine(GC gc, int x, int y, int radius, int startWithOffset) {
        int x1 = (int)((double)radius * Math.cos(Math.toRadians(startWithOffset)));
        int y1 = (int)((double)radius * Math.sin(Math.toRadians(startWithOffset)));
        Color oldColor = gc.getForeground();
        int oldAlpha = gc.getAlpha();
        Color color = new Color(gc.getDevice(), 0, 0, 0);
        gc.setAlpha(96);
        gc.setForeground(color);
        gc.drawLine(x, y, x + x1, y - y1);
        color.dispose();
        gc.setForeground(oldColor);
        gc.setAlpha(oldAlpha);
    }

    private void hookSelectionListener(Composite control) {
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 1 && (e.stateMask & SWT.MOD4) == 0) {
                    IStructuredSelection s = this.createSelection(e.x, e.y);
                    PieFieldViewer.this.setSelection((ISelection)s);
                    PieFieldViewer.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)PieFieldViewer.this, (ISelection)s));
                }
            }

            private IStructuredSelection createSelection(int x, int y) {
                Row row = PieFieldViewer.this.getRowAtPosition(x, y);
                Field[] fields = PieFieldViewer.this.getFields();
                Object ss = StructuredSelection.EMPTY;
                if (row != null && fields != null) {
                    ss = new StructuredRowSelection(row, fields);
                }
                return ss;
            }
        });
    }

    private void hookFocusListener(Composite control) {
        FocusTracker.enableFocusTracking(control);
    }

    private void hookTooltipListener(Composite control) {
        new ToolTipManager(control, this.m_tooltipProvider);
    }

    private void hookAccessibleListener(Composite control) {
        control.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = "Pie chart";
            }
        });
    }

    private void hookPaintListener(final Composite control) {
        control.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                PieFieldViewer.this.drawBackground(e.gc, control.getBounds());
                PieFieldViewer.this.drawDropShadow(e.gc, PieFieldViewer.this.getCenter(), PieFieldViewer.this.getRadius());
                PieFieldViewer.this.drawPie(e.gc, PieFieldViewer.this.getCenter(), PieFieldViewer.this.getRadius());
            }
        });
    }

    protected void drawPieSlice(GC gc, int x, int y, int radius, int startAngle, int arcAngle) {
        gc.fillArc(x - radius, y - radius, radius * 2, radius * 2, startAngle, arcAngle);
        gc.drawArc(x - radius, y - radius, radius * 2, radius * 2, startAngle, arcAngle);
    }

    private static class GcConfig {
        Color forground;
        Color background;
        int linewidth;
        int antiAlising;

        private GcConfig() {
        }

        public void dispose() {
            if (this.forground != null && !this.forground.isDisposed()) {
                this.forground.dispose();
            }
            if (this.background != null && !this.background.isDisposed()) {
                this.background.dispose();
            }
        }
    }

    public final class ToolTipProvider
    implements ToolTipManager.ToolTipProvider {
        @Override
        public boolean initializeToolTip(FormText text, int x, int y) {
            if (PieFieldViewer.this.getFieldLabelProvider() != null) {
                return this.initializeToolTip(PieFieldViewer.this.getFieldLabelProvider().getFields(), PieFieldViewer.this.getRowAtPosition(x, y), text);
            }
            return false;
        }

        public boolean initializeToolTip(Field[] fields, Row row, FormText toolTip) {
            IColorProvider cp;
            Image image;
            String text;
            if (row != null && (text = this.buildTooltipText(fields, row, (image = (cp = PieFieldViewer.this.getColorProvider()).getImage(row.getElement())) != null)) != null) {
                toolTip.setText(text, true, true);
                if (image != null) {
                    toolTip.setImage("image", image);
                }
                return true;
            }
            return false;
        }

        public String buildTooltipText(Field[] fields, Row row, boolean color) {
            if (fields.length == 0) {
                return null;
            }
            StringBuilder builder = new StringBuilder();
            builder.append("<form>");
            int n = 0;
            while (n < fields.length) {
                builder.append("<p vspace='false'>");
                if (color && n == 0) {
                    builder.append("<img align='middle' href='image' />\u00a0");
                }
                if (n == 0) {
                    builder.append("<b>");
                    builder.append(this.unformattedRow(fields[n], row));
                    builder.append("</b>");
                } else {
                    builder.append(this.unformattedRow(fields[n], row));
                }
                builder.append("</p>");
                ++n;
            }
            builder.append("</form>");
            return builder.toString();
        }

        private String unformattedRow(Field field, Row row) {
            String name = field.getName();
            String content = field.formatObject(row.getColumn(field.INDEX));
            return String.valueOf(name) + ": " + content;
        }
    }
}

