/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.handlers;

import com.jrockit.mc.ui.dnd.ClipboardManager;
import com.jrockit.mc.ui.dnd.TableStringBuilder;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.IRowTreeSelection;
import com.jrockit.mc.ui.model.fields.IStructuredRowSelection;
import com.jrockit.mc.ui.model.fields.Row;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class CopySelectionHandler
extends AbstractHandler {
    private ISelectionProvider selectionProvider;

    public CopySelectionHandler(ISelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
        selectionProvider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CopySelectionHandler.this.setBaseEnabled(!event.getSelection().isEmpty());
            }
        });
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        CopySelectionHandler.copySelection(this.selectionProvider.getSelection());
        return null;
    }

    private static void copySelection(ISelection selection) {
        ClipboardManager cbm = ClipboardManager.getDefault();
        if (!selection.isEmpty() && selection instanceof IStructuredRowSelection) {
            int n;
            int n2;
            Field[] fieldArray;
            TableStringBuilder builder = new TableStringBuilder(cbm.shouldCopyAsCsv());
            IStructuredRowSelection rs = (IStructuredRowSelection)selection;
            Field[] fields = rs.getFields();
            boolean copyOnlyVisible = cbm.shouldCopyOnlyVisible();
            boolean copyRaw = cbm.shouldCopyAsRawData();
            if (cbm.shouldCopyColumnHeaders()) {
                fieldArray = fields;
                n2 = fields.length;
                n = 0;
                while (n < n2) {
                    Field field = fieldArray[n];
                    if (!copyOnlyVisible || field.isVisible()) {
                        builder.appendCellHeader(field.getName(), field.getUnit());
                    }
                    ++n;
                }
                builder.appendNewLine();
            }
            if (selection instanceof IRowTreeSelection) {
                fieldArray = ((IRowTreeSelection)selection).getRowPaths();
                n2 = fieldArray.length;
                n = 0;
                while (n < n2) {
                    Field path = fieldArray[n];
                    Row row = (Row)path.getLastSegment();
                    CopySelectionHandler.appendRow(builder, fields, row, cbm.shouldIndentForStructure() ? path.getSegmentCount() - 1 : 0, copyOnlyVisible, copyRaw);
                    builder.appendNewLine();
                    ++n;
                }
            } else {
                Iterator<?> it = rs.rowIterator();
                while (it.hasNext()) {
                    CopySelectionHandler.appendRow(builder, fields, (Row)it.next(), 0, copyOnlyVisible, copyRaw);
                    builder.appendNewLine();
                }
            }
            cbm.setContents(builder.toString());
        }
    }

    private static void appendRow(TableStringBuilder builder, Field[] fields, Row row, int indents, boolean copyOnlyVisible, boolean copyRaw) {
        Object[] values = row.getColumns();
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (!copyOnlyVisible || field.isVisible()) {
                Object cellValue = values[field.INDEX];
                String cellValueStr = cellValue == null ? "" : (copyRaw ? field.formatForClipboard(cellValue) : field.formatObject(cellValue));
                builder.appendCell(cellValueStr, indents);
            }
            ++n2;
        }
    }
}

