/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.handlers;

import com.jrockit.mc.ui.handlers.FieldConfigureHandler;
import com.jrockit.mc.ui.handlers.FieldSortHandler;
import com.jrockit.mc.ui.handlers.FieldToggleHandler;
import com.jrockit.mc.ui.handlers.Messages;
import com.jrockit.mc.ui.handlers.MultiFieldHandler;
import com.jrockit.mc.ui.handlers.Toolkit;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.MethodField;
import com.jrockit.mc.ui.model.fields.MultiField;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.menus.AbstractContributionFactory;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.services.IServiceLocator;

public class FieldViewerContributionFactory
extends AbstractContributionFactory {
    private static final int MAX_FIELD_ITEMS = 10;
    private final Field[] m_fields;
    private final IWorkbenchPartSite m_site;
    private final String m_menuId;

    public FieldViewerContributionFactory(Field[] fields, IWorkbenchPartSite site, String id) {
        super("popup:" + id + "?after=" + "group.viewerSetup", "mission.control");
        this.m_fields = fields;
        this.m_site = site;
        this.m_menuId = id;
    }

    public Collection<Command> createCommands() {
        CommandBuilder cb = new CommandBuilder((ICommandService)this.m_site.getService(ICommandService.class), this.m_menuId);
        this.construct(cb);
        return cb.getCommands();
    }

    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        this.construct(new ContributionBuilder(additions, serviceLocator, this.m_menuId, this.m_fields));
    }

    public Collection<IHandler> createHandlers() {
        HandlerBuilder hb = new HandlerBuilder(this.m_menuId, (ICommandService)this.m_site.getService(ICommandService.class));
        this.construct(hb);
        return hb.getHandlers();
    }

    public void construct(AbstractBuilder builder) {
        this.constructVisibiltyToggles(builder);
        this.constructVisibilityConfigurer(builder);
        this.constructSortSelection(builder);
        this.constructSpecialized(builder);
    }

    private boolean hasSpecialField() {
        Field[] fieldArray = this.m_fields;
        int n = this.m_fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field m_field = fieldArray[n2];
            if (m_field instanceof MultiField) {
                return true;
            }
            if (m_field instanceof MethodField) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void constructSpecialized(AbstractBuilder builder) {
        if (this.hasSpecialField()) {
            builder.buildSeparator();
        }
        Field[] fieldArray = this.m_fields;
        int n = this.m_fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field m_field = fieldArray[n2];
            if (m_field instanceof MultiField) {
                builder.buildMultiField((MultiField)m_field);
            }
            if (m_field instanceof MethodField) {
                builder.buildMethodField((MethodField)m_field);
            }
            ++n2;
        }
    }

    private void constructVisibilityConfigurer(AbstractBuilder builder) {
        if (this.m_fields.length > 1) {
            builder.buildVisibilityConfigurer();
        }
    }

    private void constructVisibiltyToggles(AbstractBuilder builder) {
        if (this.m_fields.length > 1) {
            int n = 0;
            while (n < this.m_fields.length && n < 10) {
                builder.buildVisibility(this.m_fields[n]);
                ++n;
            }
        }
    }

    private void constructSortSelection(AbstractBuilder builder) {
        Field[] fieldArray = this.m_fields;
        int n = this.m_fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field m_field = fieldArray[n2];
            builder.buildSort(m_field);
            ++n2;
        }
    }

    private static abstract class AbstractBuilder {
        private final String m_menuId;

        public AbstractBuilder(String menuId) {
            this.m_menuId = menuId;
        }

        public abstract void buildVisibility(Field var1);

        public abstract void buildSort(Field var1);

        public abstract void buildVisibilityConfigurer();

        public abstract void buildMultiField(MultiField var1);

        public abstract void buildMethodField(MethodField var1);

        public abstract void buildSeparator();

        protected final String getId(Field field, String property) {
            String id = field.IDENTIFIER;
            int index = id.indexOf("_FIELD");
            if (index != -1 && id.length() > 1) {
                id = id.substring(index + 1).toLowerCase();
            }
            return String.valueOf(id) + "." + property;
        }

        protected final String getMenuId(Field field, String property) {
            return String.valueOf(this.m_menuId) + "." + this.getId(field, property) + ".menu";
        }

        protected final String getVisibilityId(Field field) {
            return this.getId(field, "visibility");
        }

        protected final String getSortId(Field field) {
            return this.getId(field, "sort");
        }

        protected final String getSortOrderId(Field field, String order) {
            return this.getId(field, "sort." + order);
        }

        protected final String getMultiFieldId(MultiField field, Field subField) {
            return this.getId(field, "" + subField.INDEX);
        }

        protected final String getMethodId(Field field, String property) {
            return this.getId(field, "method.settings." + property);
        }

        protected final String getVisibilityConfigurerId() {
            return "fields.configure";
        }

        protected final String getClassId(Field field, String property) {
            return this.getId(field, "class.settings" + property);
        }
    }

    private static class CommandBuilder
    extends AbstractBuilder {
        private final List<Command> m_commands = new ArrayList<Command>();
        private final ICommandService m_commandService;

        public CommandBuilder(ICommandService commandService, String sectionIdentifier) {
            super(sectionIdentifier);
            this.m_commandService = commandService;
        }

        @Override
        public void buildVisibilityConfigurer() {
            this.buildCommand(Messages.FieldViewerContributionFactory_CONFIGURE_TEXT, this.getVisibilityConfigurerId());
        }

        @Override
        public void buildVisibility(Field field) {
            this.buildFieldCommand(field, this.getVisibilityId(field));
        }

        @Override
        public void buildSort(Field field) {
            this.buildFieldCommand(field, this.getSortOrderId(field, "ascending"));
            this.buildFieldCommand(field, this.getSortOrderId(field, "descending"));
        }

        private void buildFieldCommand(Field field, String id) {
            this.buildCommand(field.getName(), id);
        }

        private void buildCommand(String name, String id) {
            this.m_commands.add(Toolkit.createCommand(this.m_commandService, name, "field.menu", id));
        }

        @Override
        public void buildMethodField(MethodField field) {
            this.buildFieldCommand(field, this.getMethodId(field, "return_value_visible"));
            this.buildFieldCommand(field, this.getMethodId(field, "return_value_package_visible"));
            this.buildFieldCommand(field, this.getMethodId(field, "class_visible"));
            this.buildFieldCommand(field, this.getMethodId(field, "class_package_visible"));
            this.buildFieldCommand(field, this.getMethodId(field, "parameter_visible"));
            this.buildFieldCommand(field, this.getMethodId(field, "parameter_package_visible"));
        }

        @Override
        public void buildMultiField(MultiField field) {
            Field[] children;
            Field[] fieldArray = children = field.getSupportedChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Field element = fieldArray[n2];
                this.buildCommand(element.getName(), this.getMultiFieldId(field, element));
                ++n2;
            }
        }

        public Collection<Command> getCommands() {
            return this.m_commands;
        }

        @Override
        public void buildSeparator() {
            this.m_commands.add(null);
        }
    }

    private static class ContributionBuilder
    extends AbstractBuilder {
        private final IContributionRoot m_additions;
        private final MenuManager m_viewColumn;
        private final IServiceLocator m_serviceLocator;
        private final Map<String, IContributionItem> m_itemCache = new HashMap<String, IContributionItem>();

        public ContributionBuilder(IContributionRoot additions, IServiceLocator locator, String sectionIdentigier, Field[] fields) {
            super(sectionIdentigier);
            this.m_additions = additions;
            this.m_serviceLocator = locator;
            this.m_viewColumn = Toolkit.createMenuManager(Messages.FieldViewerContributionFactory_VIEW_COLUMNS_MENU_TEXT, "viewcolumn");
            this.addSortMenu(fields);
            this.m_additions.addContributionItem((IContributionItem)this.m_viewColumn, null);
        }

        private void addSortMenu(final Field[] fields) {
            MenuManager m_sortColumn = Toolkit.createMenuManager(Messages.FieldViewerContributionFactory_SORT_COLUMNS_MENU_TEXT, "sortcolumn");
            m_sortColumn.setRemoveAllWhenShown(true);
            m_sortColumn.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    if (fields.length > 1) {
                        Field[] fieldArray = fields;
                        int n = fields.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Field field = fieldArray[n2];
                            MenuManager fieldMenu = Toolkit.createMenuManager(field.getName(), ContributionBuilder.this.getSortId(field));
                            if (field.isVisible()) {
                                fieldMenu.add(Toolkit.createContribution(ContributionBuilder.this.m_serviceLocator, ContributionBuilder.this.getSortOrderId(field, "ascending"), Messages.FieldViewerContributionFactory_SORT_ASCENDING_TEXT, 8));
                                fieldMenu.add(Toolkit.createContribution(ContributionBuilder.this.m_serviceLocator, ContributionBuilder.this.getSortOrderId(field, "descending"), Messages.FieldViewerContributionFactory_SORT_DESCENDING_TEXT, 8));
                                manager.add((IContributionItem)fieldMenu);
                            }
                            ++n2;
                        }
                    }
                }
            });
            this.m_additions.addContributionItem((IContributionItem)m_sortColumn, null);
        }

        @Override
        public void buildVisibilityConfigurer() {
            IContributionItem item = this.createCachedContribution(this.getVisibilityConfigurerId(), Messages.FieldViewerContributionFactory_CONFIGURE_TEXT, 8);
            this.m_viewColumn.add(item);
        }

        @Override
        public void buildVisibility(Field field) {
            IContributionItem ici = this.createCachedContribution(this.getVisibilityId(field), field.getName(), 32);
            this.m_viewColumn.add(ici);
        }

        @Override
        public void buildSort(Field field) {
        }

        private IContributionItem createCheckedContribution(Field field, String property, String label) {
            return this.createCachedContribution(this.getMethodId(field, property), label, 32);
        }

        private IContributionItem createCachedContribution(String commandId, String label, int style) {
            if (this.m_itemCache.containsKey(commandId)) {
                return this.m_itemCache.get(commandId);
            }
            CommandContributionItemParameter param = new CommandContributionItemParameter(this.m_serviceLocator, null, commandId, style);
            param.label = label;
            CommandContributionItem item = new CommandContributionItem(param);
            this.m_itemCache.put(commandId, (IContributionItem)item);
            return item;
        }

        @Override
        public void buildMethodField(MethodField field) {
            MenuManager main = Toolkit.createMenuManager(MessageFormat.format(Messages.FieldViewerContributionFactory_SETTINGS_METHOD_FIELD_X_TEXT, field.getName()), this.getMenuId(field, "main"));
            MenuManager returnValueMenu = Toolkit.createMenuManager(Messages.FieldViewerContributionFactory_METHOD_RETURN_VALUE_MENU_TEXT, this.getMenuId(field, "method"));
            returnValueMenu.add(this.createCheckedContribution(field, "return_value_visible", Messages.FieldViewerContributionFactory_METHOD_RETURN_VALUE_VISIBLE_TEXT));
            returnValueMenu.add(this.createCheckedContribution(field, "return_value_package_visible", Messages.FieldViewerContributionFactory_METHOD_RETURN_VALUE_PACKAGE_NAME_VISIBLE_TEXT));
            main.add((IContributionItem)returnValueMenu);
            MenuManager classMenu = Toolkit.createMenuManager(Messages.FieldViewerContributionFactory_METHOD_CLASS_MENU_TEXT, this.getMenuId(field, "class"));
            main.add((IContributionItem)classMenu);
            classMenu.add(this.createCheckedContribution(field, "class_visible", Messages.FieldViewerContributionFactory_METHOD_CLASS_VISIBLE_TEXT));
            classMenu.add(this.createCheckedContribution(field, "class_package_visible", Messages.FieldViewerContributionFactory_METHOD_CLASS_PACKAGE_NAME_VISIBLE_TEXT));
            MenuManager parameterMenu = Toolkit.createMenuManager(Messages.FieldViewerContributionFactory_METHOD_PARAMETERS_MENU_TEXT, this.getMenuId(field, "parameters"));
            main.add((IContributionItem)parameterMenu);
            parameterMenu.add(this.createCheckedContribution(field, "parameter_visible", Messages.FieldViewerContributionFactory_METHOD_PARAMETERS_VISIBLE_TEXT));
            parameterMenu.add(this.createCheckedContribution(field, "parameter_package_visible", Messages.FieldViewerContributionFactory_METHOD_PARAMETERS_PACKAGE_VISIBLE_TEXT));
            this.m_additions.addContributionItem((IContributionItem)main, null);
        }

        @Override
        public void buildMultiField(MultiField field) {
            Field[] children;
            MenuManager main = Toolkit.createMenuManager(field.getName(), this.getId(field, "multi.menu"));
            Field[] fieldArray = children = field.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Field element = fieldArray[n2];
                IContributionItem ici = this.createCachedContribution(this.getMultiFieldId(field, element), element.getName(), 16);
                main.add(ici);
                ++n2;
            }
            this.m_additions.addContributionItem((IContributionItem)main, null);
        }

        @Override
        public void buildSeparator() {
            this.m_additions.addContributionItem((IContributionItem)new Separator(), null);
        }
    }

    private static class HandlerBuilder
    extends AbstractBuilder {
        private final List<IHandler> m_handlers = new ArrayList<IHandler>();
        private final ICommandService m_commandService;

        public HandlerBuilder(String sectionidentifier, ICommandService service) {
            super(sectionidentifier);
            this.m_commandService = service;
        }

        @Override
        public void buildVisibilityConfigurer() {
            this.m_handlers.add((IHandler)new FieldConfigureHandler());
        }

        @Override
        public void buildVisibility(Field field) {
            this.m_handlers.add((IHandler)new FieldToggleHandler(field, "visible", "visibility.change", true));
        }

        @Override
        public void buildSort(Field field) {
            this.m_handlers.add((IHandler)new FieldSortHandler(field, true));
            this.m_handlers.add((IHandler)new FieldSortHandler(field, false));
        }

        @Override
        public void buildMethodField(MethodField field) {
            this.m_handlers.add((IHandler)new FieldToggleHandler(field, "return_value_visible", "content.change", false));
            this.m_handlers.add((IHandler)new FieldToggleHandler(field, "return_value_package_visible", "content.change", false));
            this.m_handlers.add((IHandler)new FieldToggleHandler(field, "class_visible", "content.change", true));
            this.m_handlers.add((IHandler)new FieldToggleHandler(field, "class_package_visible", "content.change", true));
            this.m_handlers.add((IHandler)new FieldToggleHandler(field, "parameter_visible", "content.change", true));
            this.m_handlers.add((IHandler)new FieldToggleHandler(field, "parameter_package_visible", "content.change", false));
        }

        @Override
        public void buildMultiField(MultiField field) {
            Field[] children;
            HashMap<String, Field> map = new HashMap<String, Field>();
            Field[] fieldArray = children = field.getSupportedChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Field element = fieldArray[n2];
                MultiFieldHandler mf = new MultiFieldHandler(this.m_commandService, field, element, map);
                map.put(this.getMultiFieldId(field, element), element);
                this.m_handlers.add((IHandler)mf);
                ++n2;
            }
        }

        public Collection<IHandler> getHandlers() {
            return this.m_handlers;
        }

        @Override
        public void buildSeparator() {
            this.m_handlers.add(null);
        }
    }
}

